/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import com.peterphi.std.types.SampleCount;
import com.peterphi.std.types.Timebase;
import com.peterphi.std.types.Timecode;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;

public class TimecodeBuilder {
    private static final int DROP_FRAMES_PER_TEN_MIN = 18;
    private boolean negative = false;
    private long days = 0L;
    private long hours = 0L;
    private long minutes = 0L;
    private long seconds = 0L;
    private long frames = 0L;
    private Timebase rate = null;
    private boolean dropFrame = false;

    public TimecodeBuilder withTimecode(Timecode timecode) {
        return this.withNegative(timecode.isNegative()).withDays(timecode.getDaysPart()).withHours(timecode.getHoursPart()).withMinutes(timecode.getMinutesPart()).withSeconds(timecode.getSecondsPart()).withFrames(timecode.getFramesPart()).withDropFrame(timecode.isDropFrame()).withRate(timecode.getTimebase());
    }

    public TimecodeBuilder withTime(Date dateTime) {
        return this.withTime(new DateTime((Object)dateTime));
    }

    public TimecodeBuilder withTime(DateTime dateTime) {
        return this.withTime(dateTime.toLocalTime());
    }

    public TimecodeBuilder withTime(LocalTime time) {
        return this.withTime(time, Timebase.HZ_25);
    }

    public TimecodeBuilder withTime(LocalTime time, Timebase timebase) {
        Timecode baseTimecode = new TimecodeBuilder().withHours(time.getHourOfDay()).withMinutes(time.getMinuteOfHour()).withSeconds(time.getSecondOfMinute()).withRate(timebase).build();
        Timecode timecode = baseTimecode.add(new SampleCount(time.getMillisOfSecond(), Timebase.HZ_1000));
        return this.withTimecode(timecode);
    }

    public TimecodeBuilder withNegative(boolean negative) {
        this.negative = negative;
        return this;
    }

    public TimecodeBuilder withDays(long days) {
        this.days = days;
        return this;
    }

    public TimecodeBuilder withHours(long hours) {
        this.hours = hours;
        return this;
    }

    public TimecodeBuilder withMinutes(long minutes) {
        this.minutes = minutes;
        return this;
    }

    public TimecodeBuilder withSeconds(long seconds) {
        this.seconds = seconds;
        return this;
    }

    public TimecodeBuilder withFrames(long frames) {
        this.frames = frames;
        return this;
    }

    public TimecodeBuilder withDropFrame(boolean dropFrame) {
        this.dropFrame = dropFrame;
        return this;
    }

    public TimecodeBuilder withRate(Timebase rate) {
        this.rate = rate;
        return this;
    }

    public Timecode build() {
        return new Timecode(this.negative, this.days, this.hours, this.minutes, this.seconds, this.frames, this.rate, this.dropFrame);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getDays() {
        return this.days;
    }

    public long getHours() {
        return this.hours;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getFrames() {
        return this.frames;
    }

    public Timebase getRate() {
        return this.rate;
    }

    public boolean isDropFrame() {
        return this.dropFrame;
    }

    public String toString() {
        return "[TimecodeBuildernegative=" + this.negative + ", days=" + this.days + ", hours=" + this.hours + ", minutes=" + this.minutes + ", seconds=" + this.seconds + ", frames=" + this.frames + ", rate=" + this.rate + ", dropFrame=" + this.dropFrame + ']';
    }

    public static TimecodeBuilder fromTimecode(Timecode timecode) {
        return new TimecodeBuilder().withTimecode(timecode);
    }

    public static TimecodeBuilder fromEncodedValue(String encoded) {
        try {
            String[] parts = encoded.split("@");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Expected timecode@timebase but got " + encoded);
            }
            String smpte = parts[0];
            String timebase = parts[1];
            return TimecodeBuilder.fromSMPTE(smpte).withRate(Timebase.getInstance(timebase));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Cannot parse timecode expr " + encoded + " - " + e.getMessage(), e);
        }
    }

    public static TimecodeBuilder fromSMPTE(String smpte) {
        boolean dropFrame = smpte.indexOf(59) != -1;
        boolean negative = smpte.charAt(0) == '-';
        String[] parts = smpte.replace(';', ':').split(":");
        if (parts.length > 5 || parts.length < 4) {
            throw new IllegalArgumentException("Field mismatch: expected 4 or 5 ([dd:]hh:mm:ss:ff) but got " + parts.length);
        }
        int i = 0;
        int days = parts.length == 5 ? Math.abs(Integer.parseInt(parts[i++])) : 0;
        int hours = Math.abs(Integer.parseInt(parts[i++]));
        int minutes = Integer.parseInt(parts[i++]);
        int seconds = Integer.parseInt(parts[i++]);
        int frames = Integer.parseInt(parts[i++]);
        return new TimecodeBuilder().withNegative(negative).withDropFrame(dropFrame).withDays(days).withHours(hours).withMinutes(minutes).withSeconds(seconds).withFrames(frames);
    }

    public static TimecodeBuilder fromSamples(SampleCount samples, boolean dropFrame) {
        return TimecodeBuilder.fromFrames(samples.getSamples(), dropFrame, samples.getRate());
    }

    public static TimecodeBuilder fromFrames(long signedFrameNumber, boolean dropFrame, Timebase rate) {
        double fps = rate.getSamplesPerSecond();
        boolean negative = signedFrameNumber < 0L;
        long frameNumber = Math.abs(signedFrameNumber);
        if (dropFrame) {
            frameNumber = TimecodeBuilder.compensateForDropFrame(frameNumber, fps);
        }
        long frames = Math.round(Math.floor((double)frameNumber % fps));
        long seconds = Math.round(Math.floor((double)frameNumber / fps)) % 60L;
        long minutes = Math.round(Math.floor((double)frameNumber / fps)) / 60L % 60L;
        long hours = Math.round(Math.floor((double)frameNumber / fps)) / 60L / 60L % 24L;
        long days = Math.round(Math.floor((double)frameNumber / fps / 60.0 / 60.0 / 24.0));
        return new TimecodeBuilder().withNegative(negative).withDropFrame(dropFrame).withDays(days).withHours(hours).withMinutes(minutes).withSeconds(seconds).withFrames(frames).withRate(rate);
    }

    private static long compensateForDropFrame(long frames, double framesPerSecond) {
        double framesPerMin = framesPerSecond * 60.0;
        double framesPerTenMin = framesPerMin * 10.0 + 18.0;
        long numberOfTenMinExtents = Math.round(Math.floor((double)frames / framesPerTenMin));
        long numberOfTrailingExtents = Math.round(Math.floor((double)frames % framesPerTenMin / framesPerMin));
        long compensated = frames + numberOfTenMinExtents * 18L + numberOfTrailingExtents * 2L;
        return compensated;
    }
}

