/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import com.peterphi.std.types.ResamplingException;
import com.peterphi.std.types.SampleCount;
import com.peterphi.std.types.Timebase;
import com.peterphi.std.types.TimecodeBuilder;
import com.peterphi.std.types.TimecodeComparator;

public class Timecode {
    private static final String FRAME_SEPARATOR_NO_DROP_FRAMES = ":";
    private static final String FRAME_SEPARATOR_DROP_FRAMES = ";";
    private final boolean negative;
    private final long days;
    private final long hours;
    private final long minutes;
    private final long seconds;
    private final long frames;
    private final Timebase timebase;
    private final boolean dropFrame;

    Timecode(boolean negative, long days, long hours, long minutes, long seconds, long frames, Timebase timebase, boolean dropFrame) {
        if (days < 0L || days > 99L) {
            throw new IllegalArgumentException("Days must be 0-99! Got: " + days);
        }
        if (hours < 0L || hours > 23L) {
            throw new IllegalArgumentException("Hours must be 0-23! Hours: " + hours);
        }
        if (minutes < 0L || minutes > 59L) {
            throw new IllegalArgumentException("Minutes must be 0-60! Got: " + minutes);
        }
        if (seconds < 0L || seconds > 59L) {
            throw new IllegalArgumentException("Seconds must be 0-60! Got: " + seconds);
        }
        if (frames < 0L) {
            throw new IllegalArgumentException("Frames may not be negative! Got " + frames);
        }
        if ((double)frames >= timebase.getSamplesPerSecond()) {
            throw new IllegalArgumentException("Frame component must represent < 1 second! Got " + frames + " with timebase " + timebase.toEncodedString());
        }
        this.timebase = timebase;
        this.dropFrame = dropFrame;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.frames = frames;
        boolean isNonZero = days + hours + minutes + seconds + frames != 0L;
        this.negative = negative && isNonZero;
    }

    public TimecodeBuilder builder() {
        return TimecodeBuilder.fromTimecode(this);
    }

    public long getDurationInFrames() {
        return this.getDurationInFrames(true);
    }

    public long getDurationInFrames(boolean allowDropFrameRemoval) {
        double fps = this.timebase.getSamplesPerSecond();
        double totalFrames = this.frames;
        totalFrames += (double)this.seconds * fps;
        totalFrames += (double)(this.minutes * 60L) * fps;
        totalFrames += (double)(this.hours * 60L * 60L) * fps;
        totalFrames += (double)(this.days * 24L * 60L * 60L) * fps;
        if (this.dropFrame && allowDropFrameRemoval) {
            long totalMins = this.hours * 60L + this.minutes;
            long dropFrames = totalMins * 2L - totalMins / 10L * 2L;
            totalFrames -= (double)dropFrames;
        }
        if (this.negative) {
            totalFrames *= -1.0;
        }
        return Math.round(totalFrames);
    }

    public long getDurationInSeconds() {
        return this.hours * 60L * 60L + this.minutes * 60L + this.seconds;
    }

    public long getFramesPartAsMicroseconds() {
        int microsecondsPerFrame = (int)(1000000.0 / this.timebase.getSamplesPerSecond());
        return (long)microsecondsPerFrame * this.frames;
    }

    public long getFramesPartAsMilliseconds() {
        int milliSecondsPerFrame = (int)(1000.0 / this.timebase.getSamplesPerSecond());
        return (long)milliSecondsPerFrame * this.frames;
    }

    public boolean isDropFrame() {
        return this.dropFrame;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getFramesPart() {
        return this.frames;
    }

    public long getSecondsPart() {
        return this.seconds;
    }

    public long getMinutesPart() {
        return this.minutes;
    }

    public long getHoursPart() {
        return this.hours;
    }

    public long getDaysPart() {
        return this.days;
    }

    public Timebase getTimebase() {
        return this.timebase;
    }

    public String toSMPTEString() {
        return this.toSMPTEString(false);
    }

    public String toSMPTEString(boolean includeDays) {
        String negativeIndicator;
        String frameIndicator = this.dropFrame ? FRAME_SEPARATOR_DROP_FRAMES : FRAME_SEPARATOR_NO_DROP_FRAMES;
        String string = negativeIndicator = this.negative ? "-" : "";
        if (this.days == 0L || !includeDays) {
            return String.format("%s%02d:%02d:%02d%s%02d", negativeIndicator, this.hours, this.minutes, this.seconds, frameIndicator, this.frames);
        }
        return String.format("%s%02d:%02d:%02d:%02d%s%02d", negativeIndicator, this.days, this.hours, this.minutes, this.seconds, frameIndicator, this.frames);
    }

    public String toFfmpegString() {
        long hours = this.hours + 24L * this.days;
        return String.format("%02d:%02d:%02d.%06d", hours, this.minutes, this.seconds, this.getFramesPartAsMicroseconds());
    }

    public String toISODurationWithFrames(boolean includeDays) {
        if (includeDays && this.days != 0L) {
            return String.format("P%02dDT%02dH%02dM%02dS%02dF", this.days, this.hours, this.minutes, this.seconds, this.frames);
        }
        return String.format("PT%02dH%02dM%02dS%02dF", this.hours, this.minutes, this.seconds, this.frames);
    }

    public String toEncodedString() {
        return this.toEncodedString(true);
    }

    public String toEncodedString(boolean includeDays) {
        return this.toSMPTEString(includeDays) + "@" + this.getTimebase().toEncodedString();
    }

    @Deprecated
    public String toVidispineString() {
        return this.getSampleCount().toVidispineString();
    }

    public boolean between(Timecode start, Timecode end) {
        return TimecodeComparator.between(this, start, end);
    }

    public boolean eq(Timecode that) {
        return TimecodeComparator.eq(this, that);
    }

    public boolean gt(Timecode that) {
        return TimecodeComparator.gt(this, that);
    }

    public boolean lt(Timecode that) {
        return TimecodeComparator.lt(this, that);
    }

    public boolean le(Timecode that) {
        return TimecodeComparator.le(this, that);
    }

    public boolean ge(Timecode that) {
        return TimecodeComparator.ge(this, that);
    }

    public Timecode subtract(SampleCount samples) {
        SampleCount mySamples = this.getSampleCount();
        SampleCount result = mySamples.subtract(samples);
        return Timecode.getInstance(result, this.dropFrame);
    }

    public Timecode add(SampleCount samples) {
        SampleCount mySamples = this.getSampleCount();
        SampleCount totalSamples = mySamples.add(samples);
        return TimecodeBuilder.fromSamples(totalSamples, this.dropFrame).build();
    }

    public Timecode addPrecise(SampleCount samples) throws ResamplingException {
        SampleCount mySamples = this.getSampleCount();
        SampleCount totalSamples = mySamples.addPrecise(samples);
        return TimecodeBuilder.fromSamples(totalSamples, this.dropFrame).build();
    }

    public SampleCount getSampleCount() {
        return new SampleCount(this.getDurationInFrames(), this.timebase);
    }

    public SampleCount getSampleCount(Timecode from) {
        SampleCount me = this.getSampleCount();
        SampleCount them = from.getSampleCount();
        return me.subtract(them);
    }

    public SampleCount getSampleCountPrecise(Timecode from) throws ResamplingException {
        SampleCount me = this.getSampleCount();
        SampleCount them = from.getSampleCount();
        return me.subtractPrecise(them);
    }

    public Timecode resample(Timebase toRate) {
        Timebase fromRate = this.getTimebase();
        if (!fromRate.equals(toRate)) {
            long resampled = toRate.resample(this.getFramesPart(), fromRate);
            if ((double)resampled < toRate.getSamplesPerSecond()) {
                return new Timecode(this.negative, this.days, this.hours, this.minutes, this.seconds, resampled, toRate, this.dropFrame);
            }
            return new Timecode(this.negative, this.days, this.hours, this.minutes, this.seconds, 0L, toRate, this.dropFrame).add(new SampleCount(resampled, toRate));
        }
        return this;
    }

    public Timecode resamplePrecise(Timebase toRate) throws ResamplingException {
        Timecode resampled = this.resample(toRate);
        Timecode back = resampled.resample(this.timebase);
        if (back.getSecondsPart() != this.getSecondsPart() || back.getFramesPart() != this.getFramesPart()) {
            throw new ResamplingException("Timecode resample would have lost precision: " + this.toString() + "@" + this.timebase + " to " + toRate);
        }
        return resampled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Timecode)) {
            return false;
        }
        Timecode timecode = (Timecode)o;
        if (this.days != timecode.days) {
            return false;
        }
        if (this.dropFrame != timecode.dropFrame) {
            return false;
        }
        if (this.frames != timecode.frames) {
            return false;
        }
        if (this.hours != timecode.hours) {
            return false;
        }
        if (this.minutes != timecode.minutes) {
            return false;
        }
        if (this.negative != timecode.negative) {
            return false;
        }
        if (this.seconds != timecode.seconds) {
            return false;
        }
        return this.timebase.equals(timecode.timebase);
    }

    public int hashCode() {
        int result = this.negative ? 1 : 0;
        result = 31 * result + (int)(this.days ^ this.days >>> 32);
        result = 31 * result + (int)(this.hours ^ this.hours >>> 32);
        result = 31 * result + (int)(this.minutes ^ this.minutes >>> 32);
        result = 31 * result + (int)(this.seconds ^ this.seconds >>> 32);
        result = 31 * result + (int)(this.frames ^ this.frames >>> 32);
        result = 31 * result + this.timebase.hashCode();
        result = 31 * result + (this.dropFrame ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.toSMPTEString();
    }

    public static final Timecode getInstance(long frameNumber, boolean dropFrame, Timebase timebase) {
        return TimecodeBuilder.fromFrames(frameNumber, dropFrame, timebase).build();
    }

    public static final Timecode getInstance(SampleCount samples) {
        return Timecode.getInstance(samples, false);
    }

    @Deprecated
    public static final Timecode getInstance(SampleCount samples, boolean dropFrame) {
        return TimecodeBuilder.fromSamples(samples, dropFrame).build();
    }

    @Deprecated
    public static final Timecode getInstance(SampleCount samples, boolean dropFrame, boolean supportDays) {
        Timecode timecode = Timecode.getInstance(samples, dropFrame);
        if (!supportDays && timecode.getDaysPart() != 0L) {
            throw new IllegalArgumentException("supportDays disabled but resulting timecode had a days component: " + timecode.toEncodedString());
        }
        return timecode;
    }

    public static final Timecode getInstance(String encoded) {
        return TimecodeBuilder.fromEncodedValue(encoded).build();
    }

    public static final Timecode valueOf(String encoded) {
        if (encoded == null) {
            return null;
        }
        return Timecode.getInstance(encoded);
    }

    @Deprecated
    public static final Timecode getSmpteTimecode(String smpte, Timebase timebase) {
        return Timecode.getInstance(smpte, timebase);
    }

    public static final Timecode getInstance(String smpte, Timebase timebase) {
        return TimecodeBuilder.fromSMPTE(smpte).withRate(timebase).build();
    }

    @Deprecated
    public static final Timecode getInstance(long frameNumber, boolean dropFrame, Timebase timebase, boolean supportDays) {
        Timecode timecode = Timecode.getInstance(frameNumber, dropFrame, timebase);
        if (!supportDays && timecode.getDaysPart() != 0L) {
            throw new IllegalArgumentException("supportDays disabled but resulting timecode had a days component: " + timecode.toEncodedString());
        }
        return timecode;
    }
}

