/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import com.peterphi.std.types.ResamplingException;
import org.apache.log4j.Logger;

public class Timebase {
    private static final Logger log = Logger.getLogger(Timebase.class);
    public static final Timebase HZ_25 = new Timebase(1, 25);
    public static final Timebase HZ_30 = new Timebase(1, 30);
    public static final Timebase HZ_50 = new Timebase(1, 50);
    public static final Timebase HZ_44100 = new Timebase(1, 44100);
    public static final Timebase HZ_48000 = new Timebase(1, 48000);
    public static final Timebase HZ_96000 = new Timebase(1, 96000);
    public static final Timebase HZ_192000 = new Timebase(1, 192000);
    private static final double FAST_RESAMPLE_PATH_PRODUCT_LIMIT = Math.sqrt(Double.MAX_VALUE);
    public static final Timebase HZ_1000000 = new Timebase(1, 1000000);
    public static final Timebase HZ_27000000 = new Timebase(1, 27000000);
    public static final Timebase HZ_1000 = new Timebase(1, 1000);
    public static final Timebase HZ_1 = new Timebase(1, 1);
    public static final Timebase NTSC = new Timebase(1001, 30000);
    private final int numerator;
    private final int denominator;

    public Timebase(int numerator, int denominator) {
        if (numerator == 0) {
            throw new IllegalArgumentException("Numerator cannot be 0!");
        }
        if (denominator == 0) {
            throw new IllegalArgumentException("Denominator cannot be 0!");
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public double getSamplesPerSecond() {
        return (double)this.denominator / (double)this.numerator;
    }

    public int getIntSamplesPerSecond() {
        return (int)this.getSamplesPerSecond();
    }

    public double getSecondsPerSample() {
        return (double)this.numerator / (double)this.denominator;
    }

    public long resample(long samples, Timebase oldRate) {
        try {
            return this.resample(samples, oldRate, false);
        }
        catch (ResamplingException e) {
            throw new RuntimeException(e);
        }
    }

    public long resamplePrecise(long samples, Timebase oldRate) throws ResamplingException {
        return this.resample(samples, oldRate, true);
    }

    public long resample(long samples, Timebase oldRate, boolean failOnPrecisionLoss) throws ResamplingException {
        double rounded;
        double resampled = this.resample((double)samples, oldRate);
        if (resampled != (rounded = (double)Math.round(resampled))) {
            if (failOnPrecisionLoss) {
                throw new ResamplingException("Resample " + samples + " from " + oldRate + " to " + this + " would lose precision by rounding " + resampled);
            }
            log.warn((Object)("Resample operation lost precision: " + samples + " from " + oldRate + " to " + this + " produced " + resampled + " which will be rounded to " + rounded));
        }
        return (long)rounded;
    }

    public double resample(double samples, Timebase oldRate) {
        if (samples == 0.0) {
            return 0.0;
        }
        if (!this.equals(oldRate)) {
            double resampled = Timebase.resample(samples, oldRate, this);
            return resampled;
        }
        return samples;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.denominator;
        result = 31 * result + this.numerator;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Timebase other = (Timebase)obj;
        if (this.denominator != other.denominator) {
            return false;
        }
        return this.numerator == other.numerator;
    }

    public String toString() {
        return "Timebase [" + this.numerator + "/" + this.denominator + "]";
    }

    public String toEncodedString() {
        if (this.numerator != 1) {
            return this.denominator + ":" + this.numerator;
        }
        return Integer.toString(this.denominator);
    }

    static double resample(double samples, Timebase source, Timebase target) {
        if (source.numerator == target.numerator && samples + (double)target.denominator < FAST_RESAMPLE_PATH_PRODUCT_LIMIT) {
            return samples * (double)target.denominator / (double)source.denominator;
        }
        double seconds = samples * source.getSecondsPerSample();
        double resampled = seconds * target.getSamplesPerSecond();
        return resampled;
    }

    public static Timebase getInstance(String rate) {
        int numerator;
        if (rate.equalsIgnoreCase("PAL")) {
            return HZ_25;
        }
        if (rate.equalsIgnoreCase("NTSC")) {
            return NTSC;
        }
        if (rate.equalsIgnoreCase("NTSC30")) {
            return HZ_30;
        }
        String[] parts = rate.split(":");
        if (parts.length == 2) {
            numerator = Integer.parseInt(parts[1]);
        } else if (parts.length == 1) {
            numerator = 1;
        } else {
            throw new IllegalArgumentException("Cannot parse encoded timebase: " + rate);
        }
        int denominator = Integer.parseInt(parts[0]);
        return new Timebase(numerator, denominator);
    }
}

