/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.io;

import java.io.Serializable;

public class TabLevel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TABSIZE_IN_SPACES = 4;
    private static final char[] tabs = new char[10];
    private static final char[] spaces = new char[10];
    private static final int CHARS_TO_BUFFER = 10;
    private final boolean useSpaces;
    private int level;

    public TabLevel() {
        this(false);
    }

    public TabLevel(boolean useSpaces) {
        this(0, useSpaces);
    }

    public TabLevel(int level) {
        this(level, false);
    }

    public TabLevel(int level, boolean useSpaces) {
        this.level = level;
        this.useSpaces = useSpaces;
    }

    public void add() {
        ++this.level;
    }

    public void sub() {
        if (this.level == 0) {
            throw new IllegalStateException("sub called but level is already 0! Mismatched add() and sub() ?");
        }
        --this.level;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        if (this.level == 0) {
            return "";
        }
        return this.toStringBuilder().toString();
    }

    private StringBuilder toStringBuilder() {
        return this.appendTo(null);
    }

    private StringBuilder appendTo(StringBuilder sb) {
        char[] buffer;
        int chars = TabLevel.getChars(this.useSpaces, this.level);
        char[] cArray = buffer = !this.useSpaces ? tabs : spaces;
        if (sb == null) {
            sb = new StringBuilder(chars);
        } else {
            sb.ensureCapacity(sb.length() + chars);
        }
        TabLevel.appendTo(sb, chars, buffer);
        return sb;
    }

    private static int getChars(boolean useSpaces, int level) {
        int chars = !useSpaces ? level : level * 4;
        return chars;
    }

    private static void appendTo(StringBuilder sb, int quantity, char[] buffer) {
        if (quantity == 0) {
            return;
        }
        int bufferSize = buffer.length;
        if (quantity <= bufferSize) {
            sb.append(buffer, 0, quantity);
        } else {
            int toCopy;
            for (int remaining = quantity; remaining > 0; remaining -= toCopy) {
                toCopy = Math.min(bufferSize, remaining);
                sb.append(buffer, 0, toCopy);
            }
        }
    }

    public StringBuilder newLine(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder(TabLevel.getChars(this.useSpaces, this.level) + 1);
        }
        sb.append("\n");
        this.appendTo(sb);
        return sb;
    }

    public String newLine() {
        return this.newLine(null).toString();
    }

    static {
        for (int i = 0; i < tabs.length; ++i) {
            TabLevel.tabs[i] = 9;
            TabLevel.spaces[i] = 32;
        }
    }
}

