/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keygen.ca;

import com.peterphi.std.crypto.DNReformatter;
import com.peterphi.std.crypto.keygen.CaHelper;
import com.peterphi.std.io.FileHelper;
import com.peterphi.std.util.ListUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;

public class CertificateAuthority {
    private static final transient Logger log = Logger.getLogger(CertificateAuthority.class);
    public static final boolean ENABLE_PEM_PROLOGUE = true;
    public static final Provider PROVIDER;
    private final File p12;
    private final File pemCert;
    private final char[] capass;
    private X509Certificate cacert;
    private PrivateKey caSigningKey;

    public CertificateAuthority(File p12, char[] pass, File pemCert, BigInteger defaultSerial, String subject) throws Exception {
        this.p12 = p12;
        this.capass = Arrays.copyOf(pass, pass.length);
        this.pemCert = pemCert;
        if (p12.exists() && pemCert.exists()) {
            this.loadCA();
        } else {
            this.generateCA(subject, defaultSerial);
        }
    }

    public X509Certificate getCACertificate() {
        return this.cacert;
    }

    protected void loadCA() throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12", PROVIDER);
        ks.load(new FileInputStream(this.p12), this.capass);
        for (String alias : ListUtility.iterate(ks.aliases())) {
            boolean hasKey;
            if (alias == null || !(hasKey = ks.isKeyEntry(alias))) continue;
            this.cacert = (X509Certificate)ks.getCertificate(alias);
            this.caSigningKey = (PrivateKey)ks.getKey(alias, new char[0]);
        }
        this.init();
        this.save();
    }

    public void saveHash(File f) throws IOException {
        FileHelper.write(f, this.getHash());
    }

    protected void saveP12(File p12) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12", PROVIDER);
        ks.load(null);
        ks.setKeyEntry("ca", this.caSigningKey, new char[0], new Certificate[]{this.cacert});
        ks.store(new FileOutputStream(p12), new char[0]);
    }

    protected void saveJKS(File jks) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        ks.setKeyEntry("ca", this.caSigningKey, new char[0], new Certificate[]{this.cacert});
        ks.store(new FileOutputStream(jks), new char[0]);
    }

    public void savePrivatePEM(File caKeyPem) throws Exception {
        PEMWriter p = new PEMWriter((Writer)new FileWriter(caKeyPem));
        p.writeObject((Object)this.caSigningKey);
        p.close();
    }

    public void savePublicPEM(File pem) throws Exception {
        PEMWriter p = new PEMWriter((Writer)new FileWriter(pem));
        p.write("CA Certificate: " + this.cacert.getSubjectDN().getName() + "\n");
        p.write("\tIssuer:" + this.cacert.getIssuerDN().getName() + "\n");
        p.write("\tSerial number:" + this.cacert.getSerialNumber().toString(16) + "\n");
        p.write("\tNot Before:" + this.cacert.getNotBefore() + "\n");
        p.write("\tNot After:" + this.cacert.getNotAfter() + "\n");
        p.write("\tOpenSSL Hash:" + this.getHash() + "\n");
        p.write("\tNot After:" + this.cacert.getNotAfter() + "\n");
        p.write("\tFile written: " + new Date() + "\n");
        p.writeObject((Object)this.cacert);
        p.close();
    }

    public void savePublicJKS(File jks) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        ks.setCertificateEntry("ca", this.cacert);
        ks.store(new FileOutputStream(jks), new char[0]);
    }

    protected void save() throws Exception {
        this.saveP12(this.p12);
        this.savePublicPEM(this.pemCert);
    }

    public String getHash() {
        return CaHelper.opensslHash(this.cacert);
    }

    protected void generateCA(String subject, BigInteger serial) throws Exception {
        KeyPair cakeys = CaHelper.generateKeyPair(2048);
        this.caSigningKey = cakeys.getPrivate();
        this.cacert = CaHelper.generateCaCertificate(subject, cakeys, serial, CertificateAuthority.toX509Name(subject));
        this.init();
        this.save();
    }

    protected void init() {
        if (this.cacert == null || this.caSigningKey == null) {
            throw new IllegalStateException("Cannot initialise CA without both the CA Cert and the CA Signing Key");
        }
    }

    public X509Name getIssuer() {
        return CertificateAuthority.toX509Name(this.cacert.getSubjectX500Principal());
    }

    public X509Certificate issueUser(PublicKey user, String subject) throws Exception {
        return CaHelper.generateClientCertificate(user, this.caSigningKey, this.getIssuer(), CertificateAuthority.toX509Name(subject));
    }

    public X509Certificate issueServer(PublicKey user, String subject) throws Exception {
        X509Name ca = this.getIssuer();
        X509Name usr = CertificateAuthority.toX509Name(subject);
        return CaHelper.generateServerCertificate(user, this.caSigningKey, ca, usr);
    }

    private static X509Name toX509Name(String subject) {
        return DNReformatter.DEFAULT.reformat(new X509Name(subject));
    }

    private static X509Name toX509Name(X500Principal subject) {
        return CertificateAuthority.toX509Name(subject.getName());
    }

    static {
        if (Security.getProvider("BC") == null) {
            log.info((Object)"[CaHelper] Loading Bouncy Castle Provider");
            PROVIDER = new BouncyCastleProvider();
            Security.addProvider(PROVIDER);
            log.debug((Object)"[CaHelper] Bouncy Castle Provider loaded");
        } else {
            PROVIDER = Security.getProvider("BC");
        }
    }
}

