/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

public class Both<L, R> {
    private final L left;
    private final R right;

    public Both(L left, R right) {
        if (left == null) {
            throw new IllegalArgumentException("Must provide non-null left!");
        }
        if (right == null) {
            throw new IllegalArgumentException("Must provide non-null right!");
        }
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        assert (this.left != null);
        return this.left;
    }

    public R getRight() {
        assert (this.right != null);
        return this.right;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Both other = (Both)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    public String toString() {
        return "[Both left=" + this.left + ", right=" + this.right + "]";
    }
}

