/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.io;

import com.ice.tar.TarArchive;
import com.peterphi.std.io.ActionOnConflict;
import com.peterphi.std.io.FileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ArchiveHelper {
    private static Logger log = Logger.getLogger(ArchiveHelper.class);

    private static InputStream getInputStream(File f) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(f);
        try {
            return new GZIPInputStream(is);
        }
        catch (IOException e) {
            return new FileInputStream(f);
        }
    }

    private static TarArchive getArchive(File tarFile) throws FileNotFoundException {
        InputStream is = ArchiveHelper.getInputStream(tarFile);
        return new TarArchive(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractArchive(File tarFile, File extractTo) {
        try {
            TarArchive ta = ArchiveHelper.getArchive(tarFile);
            try {
                if (!extractTo.exists() && !extractTo.mkdir()) {
                    throw new RuntimeException("Could not create extract dir: " + extractTo);
                }
                ta.extractContents(extractTo);
            }
            finally {
                ta.closeArchive();
            }
            return true;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File not found exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Exception while extracting archive: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addFilesToExistingJar(File jarFile, String basePathWithinJar, Map<String, File> files, ActionOnConflict action) throws IOException {
        File tempFile = FileHelper.createTempFile(jarFile.getName(), null);
        boolean renamed = jarFile.renameTo(tempFile);
        if (!renamed) {
            throw new RuntimeException("[ArchiveHelper] {addFilesToExistingJar} Could not rename the file " + jarFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        ZipInputStream jarInput = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream jarOutput = new ZipOutputStream(new FileOutputStream(jarFile));
        try {
            switch (action) {
                case OVERWRITE: {
                    ArchiveHelper.overwriteFiles(jarInput, jarOutput, basePathWithinJar, files);
                    return true;
                }
                case CONFLICT: {
                    ArchiveHelper.conflictFiles(jarInput, jarOutput, basePathWithinJar, files);
                    return true;
                }
                default: {
                    throw new IOException("An invalid ActionOnConflict action was received");
                }
            }
        }
        finally {
            if (!tempFile.delete()) {
                log.warn((Object)("Could not delete temp file " + tempFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void overwriteFiles(ZipInputStream jarInput, ZipOutputStream jarOutput, String basePathWithinJar, Map<String, File> files) throws IOException {
        byte[] buf = new byte[4096];
        ZipEntry entry = jarInput.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            boolean addFile = true;
            for (String f : files.keySet()) {
                String filename = basePathWithinJar + f;
                if (filename.compareTo(name) != 0) continue;
                addFile = false;
                break;
            }
            if (addFile) {
                int len;
                jarOutput.putNextEntry(new ZipEntry(name));
                while ((len = jarInput.read(buf)) > 0) {
                    jarOutput.write(buf, 0, len);
                }
                jarOutput.closeEntry();
            }
            entry = jarInput.getNextEntry();
        }
        jarInput.close();
        for (String fname : files.keySet()) {
            try (FileInputStream input = new FileInputStream(files.get(fname));){
                int length;
                jarOutput.putNextEntry(new ZipEntry(basePathWithinJar + fname));
                while ((length = ((InputStream)input).read(buf)) > 0) {
                    jarOutput.write(buf, 0, length);
                }
                jarOutput.closeEntry();
            }
        }
        jarOutput.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void conflictFiles(ZipInputStream jarInput, ZipOutputStream jarOutput, String basePathWithinJar, Map<String, File> files) throws IOException {
        ZipEntry entry = jarInput.getNextEntry();
        byte[] buf = new byte[4096];
        while (entry != null) {
            String name = entry.getName();
            for (String f : files.keySet()) {
                int len;
                String filename = basePathWithinJar + f;
                if (filename.compareTo(name) == 0) {
                    jarInput.close();
                    jarOutput.close();
                    throw new IOException("File already exists in jar - Action set to conflict");
                }
                jarOutput.putNextEntry(new ZipEntry(name));
                while ((len = jarInput.read(buf)) > 0) {
                    jarOutput.write(buf, 0, len);
                }
                jarOutput.closeEntry();
            }
            entry = jarInput.getNextEntry();
        }
        for (String fname : files.keySet()) {
            try (FileInputStream input = new FileInputStream(files.get(fname));){
                int length;
                jarOutput.putNextEntry(new ZipEntry(basePathWithinJar + fname));
                while ((length = ((InputStream)input).read(buf)) > 0) {
                    jarOutput.write(buf, 0, length);
                }
                jarOutput.closeEntry();
            }
        }
        jarOutput.close();
    }
}

