/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keystore;

import com.peterphi.std.crypto.keystore.StaticPasswordFinder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;

public class PKCS8Util {
    public static KeyPair toKeyPair(File file) throws IOException {
        return PKCS8Util.toKeyPair(file, null);
    }

    public static KeyPair toKeyPair(File file, char[] password) throws IOException {
        return PKCS8Util.toKeyPair(new FileInputStream(file), password);
    }

    public static KeyPair toKeyPair(byte[] bytes) throws IOException {
        return PKCS8Util.toKeyPair(new ByteArrayInputStream(bytes));
    }

    public static KeyPair toKeyPair(InputStream is) throws IOException {
        return PKCS8Util.toKeyPair(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toWriter(KeyPair keypair, Writer w) throws IOException {
        try {
            PEMWriter writer = new PEMWriter(w);
            writer.writeObject((Object)keypair);
            writer.close();
        }
        finally {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(KeyPair keypair, File file) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            PEMWriter writer = new PEMWriter((Writer)fw);
            writer.writeObject((Object)keypair);
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(PublicKey key, File file) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            PEMWriter writer = new PEMWriter((Writer)fw);
            writer.writeObject((Object)key);
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(PrivateKey key, File file) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            PEMWriter writer = new PEMWriter((Writer)fw);
            writer.writeObject((Object)key);
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toStream(KeyPair keypair, OutputStream os) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(os);){
            PKCS8Util.toWriter(keypair, w);
        }
    }

    public static byte[] toBytes(KeyPair keypair) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        PKCS8Util.toStream(keypair, bos);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair toKeyPair(InputStream is, char[] password) throws IOException {
        StaticPasswordFinder passwordFinder = password != null ? new StaticPasswordFinder(password) : null;
        KeyPair kp = null;
        try {
            try (PEMReader pem = new PEMReader((Reader)new InputStreamReader(is), (PasswordFinder)passwordFinder);){
                do {
                    Object o;
                    if ((o = pem.readObject()) == null) {
                        break;
                    }
                    if (!(o instanceof KeyPair)) continue;
                    kp = (KeyPair)o;
                } while (kp == null);
            }
            catch (Exception e) {
                throw new IOException("Error reading PEM stream: " + e.getMessage(), e);
            }
        }
        finally {
            is.close();
        }
        if (kp != null) {
            return kp;
        }
        throw new IOException("Stream " + is + " did not contain a PKCS8 KeyPair");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] toCertificateList(InputStream is) throws IOException {
        PasswordFinder passwordFinder = null;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        Object o = null;
        try {
            try (PEMReader pem = new PEMReader((Reader)new InputStreamReader(is), passwordFinder);){
                do {
                    if ((o = pem.readObject()) == null || !(o instanceof X509Certificate)) continue;
                    certs.add((X509Certificate)o);
                } while (o != null);
            }
            catch (Exception e) {
                throw new IOException("Error reading PEM stream: " + e.getMessage(), e);
            }
        }
        finally {
            is.close();
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

