package com.peterphi.std.auth.yubikey;

// YubicoClient.java
//
// Yubico Java client class that calls Yubico authentication server to
// validate an OTP (One-Time Password) generated by a Yubikey.
// For specification see <http://yubico.com/developers/api/>.

// Copyright (c) 2008, Yubico AB. All rights reserved.

// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:

// * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.

// * Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following
// disclaimer in the documentation and/or other materials provided
// with the distribution.

// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
// CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
// BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
// ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.

// Written by Paul Chen <paul@yubico.com>, March 2008.

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

/**
 * Your app instantiate an object of this class, then call verify(OTP) to validate the one-time password (OTP) generated by
 * Yubikey
 */

public class YubicoClient
{

	static final String YUBICO_AUTH_SRV_URL = "http://api.yubico.com/wsapi/verify?id=";

	private int _clientId;

	private static transient YubicoClient client;


	public static YubicoClient getInstance()
	{
		if (client == null)
			client = new YubicoClient();

		return client;
	}


	/**
	 * Initializes the Yubico object.
	 *
	 * @param initId
	 * 		The Client ID you wish to verify against or operate within.
	 */
	public YubicoClient()
	{
		this(2349); // default client id
	}


	/**
	 * Initializes the Yubico object.
	 *
	 * @param initId
	 * 		The Client ID you wish to verify against or operate within.
	 */
	public YubicoClient(int initId)
	{
		_clientId = initId;
	}


	/**
	 * Returns the ID passed to the initialized Yubico object.
	 *
	 * @return id The Client ID passed to the initializing class.
	 */
	public int getId()
	{
		return _clientId;
	}


	public boolean verify(String otp)
	{
		boolean result = false;

		try
		{
			URL srv = new URL(YUBICO_AUTH_SRV_URL + _clientId + "&otp=" + otp);
			URLConnection conn = srv.openConnection();
			BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String inputLine;
			while ((inputLine = in.readLine()) != null)
			{
				if (inputLine.startsWith("status="))
				{
					if (inputLine.equals("status=OK"))
					{
						result = true;
					}
				}
			}
			in.close();
		}
		catch (Exception e)
		{
			System.err.println("Error! " + e.getMessage());
		}

		return result;

	} // End of verify
} // End of class
