/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util;

import com.peterphi.std.types.HybridIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListUtility {
    public static <T> List<T> list(T[] items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    public static <T> List<T> list(List<T> items) {
        return new ArrayList<T>(items);
    }

    public static <T> List<T> list(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static <T> T[] array(Iterable<T> itbl, T[] array) {
        Iterator<T> it = itbl.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = it.next();
        }
        return array;
    }

    public static <T> List<T> last(List<T> src, int count) {
        if (count >= src.size()) {
            return new ArrayList<T>(src);
        }
        ArrayList<T> dest = new ArrayList<T>(count);
        int size = src.size();
        for (int i = size - count; i < size; ++i) {
            dest.add(src.get(i));
        }
        return dest;
    }

    public static <T> T head(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> List<T> tail(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.subList(1, list.size());
    }

    public static <T> T[] flip(T[] src, T[] dest, int start, int length) {
        if (dest == null || dest.length < length) {
            dest = (Object[])Array.newInstance(src.getClass().getComponentType(), length);
        }
        int srcIndex = start + length;
        for (int i = 0; i < length; ++i) {
            dest[i] = src[--srcIndex];
        }
        return dest;
    }

    public static <T> T[] flip(T[] src) {
        int length = src.length;
        return ListUtility.flip(src, (Object[])Array.newInstance(src.getClass().getComponentType(), length), 0, length);
    }

    public static <T> List<T> flip(List<T> src, List<T> dest, int start, int length) {
        int last;
        if (dest == null) {
            dest = new ArrayList<T>();
        } else if (!dest.isEmpty()) {
            dest.clear();
        }
        for (int i = last = start + length - 1; i >= start; --i) {
            dest.add(src.get(i));
        }
        return dest;
    }

    public static <T> List<T> flip(List<T> src) {
        int length = src.size();
        ArrayList dest = new ArrayList(length);
        return ListUtility.flip(src, dest, 0, length);
    }

    public static int[] flip(int[] src, int[] dest, int start, int length) {
        if (dest == null || dest.length < length) {
            dest = new int[length];
        }
        int srcIndex = start + length;
        for (int i = 0; i < length; ++i) {
            dest[i] = src[--srcIndex];
        }
        return dest;
    }

    public static char[] flip(char[] src, char[] dest, int start, int length) {
        if (dest == null || dest.length < length) {
            dest = new char[length];
        }
        int srcIndex = start + length;
        for (int i = 0; i < length; ++i) {
            dest[i] = src[--srcIndex];
        }
        return dest;
    }

    public static <T> HybridIterator<T> iterate(Iterator<T> items) {
        return new HybridIterator<T>(items);
    }

    public static <T> HybridIterator<T> iterate(Enumeration<T> items) {
        return new HybridIterator<T>(items);
    }

    public static <T> int size(T[] items) {
        return items.length;
    }

    public static <T> int size(Collection<T> items) {
        return items.size();
    }

    public static <T> int length(T[] items) {
        return ListUtility.size(items);
    }

    public static <T> int length(Collection<T> items) {
        return ListUtility.size(items);
    }

    public static boolean empty(Map<?, ?> m) {
        return m == null || m.size() == 0;
    }

    public static <T> boolean empty(Collection<T> c) {
        return c == null || c.size() == 0;
    }

    public static <T> boolean contains(Collection<T> c, T o) {
        return c != null && c.contains(o);
    }

    public static boolean contains(String[] haystack, String needle) {
        if (haystack != null && haystack.length != 0) {
            for (String straw : haystack) {
                if (!needle.equals(straw)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static <T> List<T> concat(Collection<? extends T> ... lists) {
        ArrayList<? extends T> al = new ArrayList<T>();
        for (Collection<T> collection : lists) {
            if (collection == null) continue;
            al.addAll(collection);
        }
        return al;
    }

    public static <T> Set<T> union(Collection<? extends T> ... lists) {
        HashSet<? extends T> s = new HashSet<T>();
        for (Collection<T> collection : lists) {
            if (collection == null) continue;
            s.addAll(collection);
        }
        return s;
    }

    public static <T> List<T> join(Iterable<T> ... items) {
        ArrayList<T> list = new ArrayList<T>();
        for (Iterable<T> item : items) {
            if (item == null) continue;
            for (T o : item) {
                list.add(o);
            }
        }
        return list;
    }
}

