/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import com.peterphi.std.types.Timecode;
import java.util.Comparator;

public class TimecodeComparator
implements Comparator<Timecode> {
    private static final TimecodeComparator INSTANCE = new TimecodeComparator();

    public static TimecodeComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Timecode a, Timecode b) {
        return TimecodeComparator.cmp(a, b);
    }

    public static int cmp(Timecode a, Timecode b) {
        long[] aFields = TimecodeComparator.getFields(a);
        long[] bFields = TimecodeComparator.getFields(b);
        for (int i = 0; i < aFields.length; ++i) {
            int result = TimecodeComparator.compare(aFields[i], bFields[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private static long[] getFields(Timecode tc) {
        int negativiser = tc.isNegative() ? -1 : 1;
        return new long[]{(long)negativiser * tc.getDaysPart(), (long)negativiser * tc.getHoursPart(), (long)negativiser * tc.getMinutesPart(), (long)negativiser * tc.getSecondsPart(), (long)negativiser * tc.getFramesPartAsMicroseconds()};
    }

    private static int compare(long a, long b) {
        if (a < b) {
            return -1;
        }
        if (a == b) {
            return 0;
        }
        return 1;
    }

    public static boolean between(Timecode test, Timecode start, Timecode end) {
        return test.ge(start) && test.le(end);
    }

    public static boolean eq(Timecode a, Timecode b) {
        return TimecodeComparator.cmp(a, b) == 0;
    }

    public static boolean gt(Timecode a, Timecode b) {
        return TimecodeComparator.cmp(a, b) > 0;
    }

    public static boolean lt(Timecode a, Timecode b) {
        return TimecodeComparator.cmp(a, b) < 0;
    }

    public static boolean ge(Timecode a, Timecode b) {
        return TimecodeComparator.cmp(a, b) >= 0;
    }

    public static boolean le(Timecode a, Timecode b) {
        return TimecodeComparator.cmp(a, b) <= 0;
    }

    public static Timecode max(Timecode ... timecodes) {
        Timecode max = null;
        for (Timecode timecode : timecodes) {
            if (max != null && !TimecodeComparator.lt(max, timecode)) continue;
            max = timecode;
        }
        return max;
    }

    public static Timecode min(Timecode ... timecodes) {
        Timecode min = null;
        for (Timecode timecode : timecodes) {
            if (min != null && !TimecodeComparator.ge(min, timecode)) continue;
            min = timecode;
        }
        return min;
    }
}

