/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import com.peterphi.std.types.StorageUnit;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class StorageSize
implements Comparable<StorageSize>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final StorageSize ZERO = new StorageSize(0L, StorageUnit.BYTES);
    private final BigInteger _bits;
    private final StorageUnit _unit;
    private transient BigInteger _amount;

    public StorageSize(BigInteger amount, StorageUnit unit) {
        if (amount == null || unit == null) {
            throw new IllegalArgumentException("Must supply an amount and a unit!");
        }
        this._bits = StorageUnit.BITS.convert(amount, unit);
        this._unit = unit;
        this._amount = amount;
    }

    public StorageSize(BigDecimal amount, StorageUnit unit) {
        if (unit == StorageUnit.BITS) {
            BigInteger bits;
            this._bits = bits = amount.toBigInteger();
            this._unit = unit;
        } else {
            BigInteger bits;
            long bytesPerUnit = unit.toBytes(1L);
            BigDecimal accurateBits = amount.multiply(BigDecimal.valueOf(bytesPerUnit)).multiply(BigDecimal.valueOf(8L));
            this._bits = bits = accurateBits.toBigInteger();
            this._unit = unit;
        }
    }

    protected StorageSize(StorageUnit unit, BigInteger bits) {
        if (bits == null || unit == null) {
            throw new IllegalArgumentException("Must supply a size in bits and a unit!");
        }
        this._bits = bits;
        this._unit = unit;
    }

    public StorageSize(long amount, StorageUnit unit) {
        this(BigInteger.valueOf(amount), unit);
    }

    public BigInteger getBytes() {
        return this.getAmount(StorageUnit.BYTES);
    }

    public BigInteger getBits() {
        return this._bits;
    }

    public StorageUnit getUnit() {
        return this._unit;
    }

    public BigDecimal getDecimalAmount() {
        return this.getDecimalAmount(this.getUnit());
    }

    public BigDecimal getDecimalAmount(StorageUnit unit) {
        BigDecimal bits = new BigDecimal(this._bits);
        return unit.convert(bits, StorageUnit.BITS);
    }

    @Deprecated
    public BigInteger getAmount() {
        if (this._amount == null) {
            this._amount = this.getUnit().convert(this.getBits(), StorageUnit.BITS);
        }
        return this._amount;
    }

    public BigInteger getAmount(StorageUnit unit) {
        BigDecimal amount = this.getDecimalAmount(unit);
        return amount.toBigInteger();
    }

    public boolean isZero() {
        return this.getBits().equals(BigInteger.ZERO);
    }

    public String toString() {
        return "[StorageSize " + this.toPlainString(this.getUnit()) + "]";
    }

    public String toPlainString() {
        return this.toPlainString(this.getUnit());
    }

    public String toPlainString(StorageUnit unit) {
        return unit.toString(this.getDecimalAmount(unit));
    }

    public String toShortString() {
        return this.toShortString(this.getUnit());
    }

    public String toShortString(StorageUnit unit) {
        return unit.toString(this.getDecimalAmount(unit), true);
    }

    public int hashCode() {
        return this.getBits().hashCode() ^ this.getUnit().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass().equals(StorageSize.class)) {
            StorageSize that = (StorageSize)o;
            return this.getUnit() == that.getUnit() && this.getBits().equals(that.getBits());
        }
        return false;
    }

    public StorageSize convert(StorageUnit toUnit) {
        return new StorageSize(toUnit, this.getBits());
    }

    public StorageSize add(StorageSize that) {
        StorageUnit smallestUnit = StorageUnit.smallest(this.getUnit(), that.getUnit());
        BigInteger a = this.getBits();
        BigInteger b = that.getBits();
        BigInteger result = a.add(b);
        return new StorageSize(smallestUnit, result);
    }

    public StorageSize multiply(BigInteger by) {
        BigInteger result = this.getBits().multiply(by);
        return new StorageSize(this.getUnit(), result);
    }

    public StorageSize subtract(StorageSize that) {
        StorageUnit smallestUnit = StorageUnit.smallest(this.getUnit(), that.getUnit());
        BigInteger a = this.getBits();
        BigInteger b = that.getBits();
        BigInteger result = a.subtract(b);
        return new StorageSize(smallestUnit, result);
    }

    @Override
    public int compareTo(StorageSize that) {
        if (that == null) {
            throw new NullPointerException("Cannot compareTo a null value!");
        }
        return this.getBits().compareTo(that.getBits());
    }

    public int compareTo(long amount, StorageUnit unit) {
        return this.compareTo(new StorageSize(amount, unit));
    }
}

