/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

public class Either<L, R> {
    protected final L left;
    protected final R right;

    public Either(L left, R right) {
        if (left != null && right != null) {
            throw new IllegalArgumentException("Must provide left or right but not both!");
        }
        if (left != null) {
            this.left = left;
            this.right = null;
        } else if (right != null) {
            this.left = null;
            this.right = right;
        } else {
            throw new IllegalArgumentException("Must provide left or right!");
        }
    }

    public L getLeft() {
        return this.left;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return !this.isLeft();
    }

    public R getRight() {
        return this.right;
    }

    private final Object getObject() {
        if (this.isLeft()) {
            return this.getLeft();
        }
        return this.getRight();
    }

    public int hashCode() {
        return this.getObject().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass().equals(this.getClass())) {
            Either that = (Either)o;
            if (this.isLeft() == that.isLeft()) {
                assert (this.getObject() != null);
                assert (that.getObject() != null);
                return this.getObject().equals(that.getObject());
            }
            return false;
        }
        return false;
    }

    public String toString() {
        if (this.isLeft()) {
            return "[" + this.getClass().getSimpleName() + " left=" + this.getObject() + "]";
        }
        return "[" + this.getClass().getSimpleName() + " right=" + this.getObject() + "]";
    }
}

