/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.threading;

import com.peterphi.std.threading.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class RunnableCallableFuture<T>
extends SettableFuture<T>
implements Runnable,
RunnableFuture<T> {
    private final Callable<T> callable;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public RunnableCallableFuture(Callable<T> callable) {
        if (callable == null) {
            throw new IllegalArgumentException("Must supply a non-null Callable!");
        }
        this.callable = callable;
    }

    @Override
    public void run() {
        if (this.started.compareAndSet(false, true)) {
            T value;
            try {
                value = this.callable.call();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.set(value);
        }
    }

    public Future<T> asyncRun() {
        Thread t = new Thread(this);
        t.setName("AsyncRun for " + this);
        t.setDaemon(true);
        t.start();
        return this;
    }

    public Future<T> asyncRun(Executor executor) {
        executor.execute(this);
        return this;
    }

    public String toString() {
        return "[RunnableCallableFuture callable=" + this.callable + "]";
    }

    public static <T> Future<T> asyncRun(Callable<T> callable) {
        RunnableCallableFuture<T> future = new RunnableCallableFuture<T>(callable);
        future.asyncRun();
        return future;
    }
}

