/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.xstream;

import com.peterphi.std.types.BooleanMessage;
import com.peterphi.std.types.Version;
import com.peterphi.std.xstream.serialisers.InetAddressConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.ToStringConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class XSHelper
extends XStream {
    private static final Logger log;
    public boolean hideErrors = true;
    private int currentMode = 1003;
    private boolean prettyprint = true;
    private static final boolean hasXpp3;

    public static boolean hasXPP3() {
        return hasXpp3;
    }

    public static XSHelper create() {
        XSHelper xs = XSHelper.hasXPP3() ? new XSHelper() : new XSHelper((HierarchicalStreamDriver)new DomDriver());
        try {
            xs.registerConverter((SingleValueConverter)new ToStringConverter(Version.class));
            xs.registerConverter((SingleValueConverter)new InetAddressConverter());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return xs;
    }

    public static XSHelper create(HierarchicalStreamDriver drv) {
        return new XSHelper(drv);
    }

    private XSHelper() {
    }

    private XSHelper(HierarchicalStreamDriver drv) {
        super(drv);
    }

    public void parseAnnotations(Class<?> ... classes) {
        super.processAnnotations((Class[])classes);
    }

    public BooleanMessage serialise(OutputStream os, Object o) {
        try {
            this.marshal(o, this.getWriter(os));
            return new BooleanMessage(true);
        }
        catch (Error e) {
            log.error((Object)("[XSHelper] {serialise} Unexpected Error while serialising " + o + ": " + e.getMessage()), (Throwable)e);
            return new BooleanMessage(false, e.getMessage());
        }
    }

    public BooleanMessage serialise(Writer os, Object o) {
        try {
            this.marshal(o, this.getWriter(os));
            return new BooleanMessage(true);
        }
        catch (Error e) {
            log.error((Object)("[XSHelper] {serialise} Unexpected Error while serialising " + o + ": " + e.getMessage()), (Throwable)e);
            return new BooleanMessage(false, e.getMessage());
        }
    }

    private HierarchicalStreamWriter getWriter(Writer w) {
        if (this.prettyprint) {
            return new PrettyPrintWriter(w);
        }
        return new CompactWriter(w);
    }

    private HierarchicalStreamWriter getWriter(OutputStream os) {
        return this.getWriter(new OutputStreamWriter(os));
    }

    private HierarchicalStreamWriter getWriter(File f) throws IOException {
        return this.getWriter(new FileWriter(f));
    }

    public BooleanMessage serialise(File f, Object o) {
        try {
            this.marshal(o, this.getWriter(f));
            return new BooleanMessage(true);
        }
        catch (IOException e) {
            log.error((Object)("[XSHelper] {serialise} Unexpected error while opening file writer: " + e.getMessage()), (Throwable)e);
            return new BooleanMessage(false, e.getMessage());
        }
    }

    public String serialise(Object o) {
        try {
            StringWriter sw = new StringWriter();
            this.marshal(o, this.getWriter(sw));
            return sw.toString();
        }
        catch (Throwable e) {
            log.error((Object)("[XSHelper] {serialise} Error while serialising " + o + " " + e.getMessage()), e);
            if (this.hideErrors) {
                return null;
            }
            throw new Error("Serialisation failed", e);
        }
    }

    public <T> T deserialise(File f) {
        try {
            return (T)this.fromXML(new FileReader(f));
        }
        catch (Exception e) {
            log.error((Object)("[XSHelper] {deserialise} Error while deserialising " + f + ": " + e.getMessage()), (Throwable)e);
            if (this.hideErrors) {
                return null;
            }
            throw new Error("Deserialisation failed", e);
        }
    }

    public <T> T deserialise(String xml) {
        try {
            return (T)this.fromXML(xml);
        }
        catch (Exception e) {
            log.error((Object)("[XSHelper] {deserialise} Error while deserialising a String: " + e.getMessage()), (Throwable)e);
            if (this.hideErrors) {
                return null;
            }
            throw new Error("Deserialisation failed", e);
        }
    }

    public <T> T deserialise(InputStream stream) {
        try {
            return (T)this.fromXML(stream);
        }
        catch (Exception e) {
            log.error((Object)("[XSHelper] {deserialise} Error while deserialising " + stream + ": " + e.getMessage()), (Throwable)e);
            if (this.hideErrors) {
                return null;
            }
            throw new Error("Deserialisation failed", e);
        }
    }

    public <T> T deserialise(Reader stream) {
        try {
            return (T)this.fromXML(stream);
        }
        catch (Exception e) {
            log.error((Object)("[XSHelper] {deserialise} Error while deserialising " + stream + ": " + e.getMessage()), (Throwable)e);
            if (this.hideErrors) {
                return null;
            }
            throw new Error("Deserialisation failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T clone(T obj) {
        int mode = this.getMode();
        boolean oldprettyprint = this.getPrettyPrint();
        try {
            this.setMode(1002);
            this.setPrettyPrint(false);
            T t = this.deserialise(this.serialise(obj));
            return t;
        }
        finally {
            this.setMode(mode);
            this.setPrettyPrint(oldprettyprint);
        }
    }

    public void setNoObjectGraph(boolean disable) {
        if (disable) {
            this.disableGraph();
        } else {
            this.enableGraph();
        }
    }

    public XSHelper enableGraph() {
        this.setMode(1003);
        return this;
    }

    public XSHelper disableGraph() {
        this.setMode(1001);
        return this;
    }

    public void setMode(int mode) {
        this.currentMode = mode;
        super.setMode(mode);
    }

    public boolean getPrettyPrint() {
        return this.prettyprint;
    }

    public XSHelper setPrettyPrint(boolean value) {
        this.prettyprint = value;
        return this;
    }

    public int getMode() {
        return this.currentMode;
    }

    static {
        boolean discovered;
        log = Logger.getLogger(XSHelper.class);
        String XPP3_CLASS = "org.xmlpull.v1.XmlPullParser";
        try {
            Class.forName("org.xmlpull.v1.XmlPullParser");
            discovered = true;
        }
        catch (Throwable t) {
            log.info((Object)"[XSHelper] {hasXPP3} This installation does not appear to have XPP3 class org.xmlpull.v1.XmlPullParser");
            discovered = false;
        }
        hasXpp3 = discovered;
    }
}

