/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import com.peterphi.std.types.SampleCount;
import com.peterphi.std.types.Timecode;
import com.peterphi.std.types.TimecodeComparator;

public class TimecodeRange {
    private final Timecode start;
    private final Timecode end;

    public TimecodeRange(Timecode start, Timecode end) {
        if (start == null) {
            throw new IllegalArgumentException("Start timecode may not be null!");
        }
        if (end == null) {
            throw new IllegalArgumentException("End timecode may not be null!");
        }
        if (end.lt(start)) {
            throw new IllegalArgumentException("End of range " + end + " is before start " + start + "!");
        }
        this.start = start;
        this.end = end;
    }

    public TimecodeRange(Timecode start, SampleCount duration) {
        this(start, start.add(duration));
    }

    public Timecode getStart() {
        return this.start;
    }

    public Timecode getEnd() {
        return this.end;
    }

    public SampleCount getDuration() {
        return this.end.getSampleCount(this.start);
    }

    public TimecodeRange toOffset(Timecode reference) {
        if (reference.gt(this.start)) {
            throw new IllegalArgumentException("Reference timecode " + reference + " is before start " + this.start + "!");
        }
        SampleCount samples = reference.getSampleCount();
        return this.subtract(samples);
    }

    public TimecodeRange subtract(SampleCount samples) {
        Timecode newStart = this.start.subtract(samples);
        Timecode newEnd = this.end.subtract(samples);
        return new TimecodeRange(newStart, newEnd);
    }

    public TimecodeRange add(SampleCount samples) {
        Timecode newStart = this.start.add(samples);
        Timecode newEnd = this.end.add(samples);
        return new TimecodeRange(newStart, newEnd);
    }

    public boolean within(Timecode test) {
        return TimecodeComparator.between(test, this.start, this.end);
    }

    public boolean overlaps(TimecodeRange that) {
        if (this.within(that.getStart()) || this.within(that.getEnd())) {
            return true;
        }
        return that.within(this.getStart()) || that.within(this.getEnd());
    }

    public static TimecodeRange merge(TimecodeRange a, TimecodeRange b) {
        Timecode start = TimecodeComparator.min(a.getStart(), b.getStart());
        Timecode end = TimecodeComparator.max(a.getEnd(), b.getEnd());
        return new TimecodeRange(start, end);
    }

    public String toString() {
        return "[" + this.start + " -> " + this.end + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimecodeRange other = (TimecodeRange)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }
}

