/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;

public final class KeystoreHelper {
    private static final transient Logger log = Logger.getLogger(KeystoreHelper.class);

    private KeystoreHelper() {
    }

    public static KeyStore parseKeyPEM(File file) throws GeneralSecurityException {
        return KeystoreHelper.parsePEM(file, false);
    }

    public static KeyStore parseTrustPEM(File file) throws GeneralSecurityException {
        return KeystoreHelper.parsePEM(file, true);
    }

    public static KeyStore parseKeyPEM(Reader reader) throws GeneralSecurityException {
        return KeystoreHelper.loadPEM(reader, false);
    }

    public static KeyStore parseTrustPEM(Reader reader) throws GeneralSecurityException {
        return KeystoreHelper.loadPEM(reader, true);
    }

    public static KeyStore parseKeyJKS(File file) throws GeneralSecurityException {
        return KeystoreHelper.parseJKS(file);
    }

    public static KeyStore parseTrustJKS(File file) throws GeneralSecurityException {
        return KeystoreHelper.parseJKS(file);
    }

    public static KeyStore parseKeyJKS(InputStream file) throws GeneralSecurityException {
        return KeystoreHelper.parseJKS(file);
    }

    public static KeyStore parseTrustJKS(InputStream file) throws GeneralSecurityException {
        return KeystoreHelper.parseJKS(file);
    }

    public static KeyStore parseKeyP12(File file) throws GeneralSecurityException {
        return KeystoreHelper.parseP12(file);
    }

    public static KeyStore parseTrustP12(File file) throws GeneralSecurityException {
        return KeystoreHelper.parseP12(file);
    }

    public static KeyStore parseKeyP12(InputStream file) throws GeneralSecurityException {
        return KeystoreHelper.parseP12(file);
    }

    public static KeyStore parseTrustP12(InputStream file) throws GeneralSecurityException {
        return KeystoreHelper.parseP12(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore parsePEM(File file, boolean trust) throws GeneralSecurityException {
        KeyStore keyStore;
        FileReader reader = new FileReader(file);
        try {
            keyStore = KeystoreHelper.parsePEM(reader, trust);
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new KeyStoreException("Error reading from store file " + file + ": " + e.getMessage(), e);
            }
        }
        ((Reader)reader).close();
        return keyStore;
    }

    private static KeyStore parsePEM(Reader reader, boolean trust) throws GeneralSecurityException {
        return KeystoreHelper.loadPEM(reader, trust);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore parseJKS(File file) throws GeneralSecurityException {
        KeyStore keyStore;
        FileInputStream stream = new FileInputStream(file);
        try {
            keyStore = KeystoreHelper.parseJKS(stream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new KeyStoreException("Error reading from JKS store file " + file + ": " + e.getMessage(), e);
            }
        }
        ((InputStream)stream).close();
        return keyStore;
    }

    private static KeyStore parseJKS(InputStream is) throws GeneralSecurityException {
        char[] password = new char[]{};
        return KeystoreHelper.loadJKS(is, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore parseP12(File file) throws GeneralSecurityException {
        KeyStore keyStore;
        FileInputStream stream = new FileInputStream(file);
        try {
            keyStore = KeystoreHelper.parseP12(stream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new KeyStoreException("Error reading from P12 store file " + file + ": " + e.getMessage(), e);
            }
        }
        ((InputStream)stream).close();
        return keyStore;
    }

    private static KeyStore parseP12(InputStream file) throws GeneralSecurityException {
        char[] password = new char[]{};
        return KeystoreHelper.loadP12(file, password);
    }

    private static KeyStore loadJKS(InputStream stream, char[] password) throws GeneralSecurityException {
        try {
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(stream, password);
            return store;
        }
        catch (IOException e) {
            throw new KeyStoreException("Error loading JKS from stream " + stream + ": " + e.getMessage(), e);
        }
    }

    private static KeyStore loadP12(InputStream stream, char[] password) throws GeneralSecurityException {
        try {
            KeyStore store = KeyStore.getInstance("PKCS12", BouncyCastleProvider.PROVIDER_NAME);
            store.load(stream, password);
            return store;
        }
        catch (IOException e) {
            throw new KeyStoreException("Error loading P12 from stream " + stream + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadPEM(Reader pem, boolean trust) throws GeneralSecurityException {
        try {
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(null, new char[0]);
            PEMReader reader = new PEMReader(pem);
            try {
                Object obj;
                ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
                ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
                do {
                    if ((obj = reader.readObject()) == null) continue;
                    if (obj instanceof X509Certificate) {
                        certs.add((X509Certificate)obj);
                        continue;
                    }
                    if (obj instanceof KeyPair) {
                        keys.add((KeyPair)obj);
                        continue;
                    }
                    log.warn((Object)("{loadStore} Unknown object in PEM: " + obj.getClass() + ". " + obj.toString() + ". Ignoring."));
                } while (obj != null);
                if (keys.isEmpty() && !trust) {
                    throw new IllegalArgumentException("Loading key PEM but there were no KeyPairs found in the PEM!");
                }
                if (certs.isEmpty()) {
                    throw new IllegalArgumentException("No certificates found!");
                }
                if (!trust) {
                    ArrayList<X509Certificate> added = new ArrayList<X509Certificate>();
                    for (KeyPair key : keys) {
                        for (X509Certificate cert : certs) {
                            if (!KeystoreHelper.equals(cert.getPublicKey(), key.getPublic())) continue;
                            String alias = KeystoreHelper.getAlias(cert);
                            Certificate[] chain = new Certificate[]{cert};
                            store.setCertificateEntry(alias, cert);
                            store.setKeyEntry(alias, key.getPrivate(), new char[0], chain);
                            added.add(cert);
                        }
                        certs.removeAll(added);
                    }
                }
                for (X509Certificate cert : certs) {
                    String alias = KeystoreHelper.getAlias(cert);
                    store.setCertificateEntry(alias, cert);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return store;
        }
        catch (IOException e) {
            throw new KeyStoreException("Error reading PEM from Reader " + pem + ": " + e.getMessage(), e);
        }
    }

    private static String getAlias(X509Certificate cert) {
        String hexSerial = cert.getSerialNumber().toString(16);
        String certType = cert.getType();
        String alias = certType + "_" + hexSerial;
        return alias;
    }

    private static boolean equals(PublicKey a, PublicKey b) {
        return Arrays.equals(a.getEncoded(), b.getEncoded());
    }

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            log.debug((Object)"Initialising BouncyCastle JSSE Provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

