/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.threading.retry.backoff;

import com.peterphi.std.threading.Timeout;
import com.peterphi.std.threading.retry.backoff.BackoffStrategy;

public class ExponentialBackoff
implements BackoffStrategy {
    private final long initial;
    private final double exponent;
    private final long maximum;

    public ExponentialBackoff(Timeout initial, double exponent) {
        this(initial, exponent, Timeout.MAX_VALUE);
    }

    public ExponentialBackoff(Timeout initial, double exponent, Timeout maximum) {
        this.initial = initial.getMilliseconds();
        this.exponent = exponent;
        this.maximum = maximum.getMilliseconds();
    }

    @Override
    public long getBackoff(int attempt) {
        double computed = (double)this.initial * Math.pow(this.exponent, attempt - 1);
        return Math.min(Math.round(computed), this.maximum);
    }
}

