/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.threading;

import com.peterphi.std.threading.Deadline;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public final class Timeout
implements Comparable<Timeout>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Timeout ZERO = new Timeout(0L, TimeUnit.MILLISECONDS);
    public static final Timeout ONE_QUARTER_SECOND = new Timeout(250L, TimeUnit.MILLISECONDS);
    public static final Timeout ONE_SECOND = new Timeout(1L, TimeUnit.SECONDS);
    public static final Timeout TEN_SECONDS = new Timeout(10L, TimeUnit.SECONDS);
    public static final Timeout THIRTY_SECONDS = new Timeout(30L, TimeUnit.SECONDS);
    public static final Timeout ONE_MINUTE = new Timeout(1L, TimeUnit.MINUTES);
    public static final Timeout FIVE_MINUTES = new Timeout(5L, TimeUnit.MINUTES);
    public static final Timeout MAX_VALUE = new Timeout(Long.MAX_VALUE);
    private final long period;
    private final TimeUnit unit;

    public Timeout(long milliseconds) {
        this(milliseconds, TimeUnit.MILLISECONDS);
    }

    public Timeout(long period, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Must supply a unit");
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Timeouts must be positive!");
        }
        this.period = period;
        this.unit = unit;
    }

    public Deadline start() {
        return new Deadline(this);
    }

    public Deadline start(Deadline max) {
        return Deadline.soonest(max, this.start());
    }

    public long getMilliseconds() {
        return this.unit.toMillis(this.period);
    }

    public long get(TimeUnit toUnit) {
        if (this.unit == toUnit) {
            return this.period;
        }
        return toUnit.convert(this.period, this.unit);
    }

    public int hashCode() {
        return (int)(this.period ^ this.period >>> 32) ^ this.unit.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(Timeout.class)) {
            Timeout that = (Timeout)o;
            return this.getMilliseconds() == that.getMilliseconds();
        }
        return false;
    }

    public Timeout multiply(long by) {
        return new Timeout(this.period * by, this.unit);
    }

    public Timeout multiply(double by) {
        double newMillis = (double)this.getMilliseconds() * by;
        long rounded = Math.round(newMillis);
        return new Timeout(rounded, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "[Timeout: " + Long.toString(this.period) + " " + this.unit.toString().toLowerCase() + "]";
    }

    @Override
    public int compareTo(Timeout that) {
        Long thisPeriod = new Long(this.period);
        long thatPeriod = that.get(this.unit);
        return thisPeriod.compareTo(thatPeriod);
    }

    public void sleep() {
        try {
            Thread.sleep(this.getMilliseconds());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Timeout max(Timeout ... timeouts) {
        Timeout max = null;
        for (Timeout timeout : timeouts) {
            if (timeout == null || max != null && max.getMilliseconds() >= timeout.getMilliseconds()) continue;
            max = timeout;
        }
        if (max != null) {
            return max;
        }
        throw new IllegalArgumentException("Must specify at least one non-null timeout!");
    }

    public static Timeout min(Timeout ... timeouts) {
        Timeout min = null;
        for (Timeout timeout : timeouts) {
            if (timeout == null || min != null && min.getMilliseconds() <= timeout.getMilliseconds()) continue;
            min = timeout;
        }
        if (min != null) {
            return min;
        }
        throw new IllegalArgumentException("Must specify at least one non-null timeout!");
    }

    public static Timeout sum(Timeout ... timeouts) {
        long sum = 0L;
        for (Timeout timeout : timeouts) {
            if (timeout == null) continue;
            sum += timeout.getMilliseconds();
        }
        if (sum != 0L) {
            return new Timeout(sum);
        }
        return ZERO;
    }
}

