/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.system.exec;

import com.peterphi.std.io.StreamUtil;
import com.peterphi.std.system.exec.Exec;
import com.peterphi.std.threading.Deadline;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class BaseExeced {
    public final Object monitor = new Object();
    protected final List<String> cmd;
    protected final Process process;
    protected final boolean combinedOutput;
    protected boolean finished = false;
    protected int exitCode = Integer.MIN_VALUE;

    protected BaseExeced(List<String> cmd, Process p, boolean combinedOutput) {
        this.cmd = cmd;
        this.process = p;
        this.combinedOutput = combinedOutput;
    }

    public void kill() {
        this.process.destroy();
    }

    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        try {
            int code = this.exitCode();
            this.finished(code);
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public int exitCode() throws IllegalThreadStateException {
        if (this.finished) {
            return this.exitCode;
        }
        return this.process.exitValue();
    }

    public int waitForExit(int expected) {
        return this.waitForExit(Deadline.MAX_VALUE, expected);
    }

    public int waitForExit(Deadline deadline, int expected) {
        int code = this.waitForExit(deadline);
        if (code == Integer.MIN_VALUE) {
            throw new RuntimeException("Unexpected timeout while waiting for exit and expecting code " + expected, new TimeoutException("waitForExit timed out"));
        }
        if (code != expected) {
            throw new RuntimeException("Unexpected code: wanted " + expected + " but got " + code);
        }
        return code;
    }

    public int waitForExit() {
        return this.waitForExit(Deadline.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForExit(Deadline deadline) {
        int intervalMax = 4500;
        int interval = 5;
        while (!this.isFinished() && deadline.isValid()) {
            Object object = this.monitor;
            synchronized (object) {
                try {
                    if (interval != 4500) {
                        interval = Math.min(interval * 3, 4500);
                    }
                    this.monitor.wait(Math.min(deadline.getTimeLeft(), (long)interval));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (deadline.isExpired()) {
            return Integer.MIN_VALUE;
        }
        return this.exitCode();
    }

    public InputStream getStandardOutputStream() {
        return this.process.getInputStream();
    }

    public InputStream getStandardErrorStream() {
        return this.process.getErrorStream();
    }

    public OutputStream getStandardInputStream() {
        return this.process.getOutputStream();
    }

    public void discardOutput() {
        this.discard(this.getStandardOutputStream());
        this.discard(this.getStandardErrorStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finished(int exitCode) {
        Object object = this.monitor;
        synchronized (object) {
            this.finished = true;
            this.exitCode = exitCode;
            this.monitor.notifyAll();
        }
    }

    protected void unexpectedFailure(IOException e) {
        if (this.finished) {
            return;
        }
        if (!this.isFinished()) {
            this.finished(Integer.MIN_VALUE);
        }
    }

    protected Thread copy(final InputStream in, final Writer out) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    StreamUtil.streamCopy(in, out);
                }
                catch (IOException e) {
                    try {
                        out.flush();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    BaseExeced.this.unexpectedFailure(e);
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        return t;
    }

    protected Thread discard(final InputStream in) {
        if (in == null) {
            return null;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                StreamUtil.eatInputStream(in);
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static BaseExeced spawn(Exec e) throws IOException {
        ProcessBuilder pb = e.getProcessBuilder();
        pb.start();
        return new BaseExeced(e.cmd, pb.start(), pb.redirectErrorStream());
    }
}

