/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.auth;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.matcher.Matchers;
import com.peterphi.std.guice.common.auth.AuthConstraintMethodInterceptor;
import com.peterphi.std.guice.common.auth.DefaultAuthConstraintMethodInterceptor;
import com.peterphi.std.guice.common.auth.annotations.AuthConstraint;
import com.peterphi.std.guice.common.auth.iface.CurrentUser;
import org.aopalliance.intercept.MethodInterceptor;

public class AuthConstraintInterceptorModule
extends AbstractModule {
    private final boolean useDenyImplementation;
    private final Meter calls;
    private final Meter granted;
    private final Meter denied;
    private final Meter authenticatedDenied;

    public AuthConstraintInterceptorModule(MetricRegistry metrics, boolean useDenyImplementation) {
        this.calls = metrics.meter("feature.AuthConstraint.calls");
        this.granted = metrics.meter("feature.AuthConstraint.allow");
        this.denied = metrics.meter("feature.AuthConstraint.deny");
        this.authenticatedDenied = metrics.meter("feature.AuthConstraint.authenticated-deny");
        this.useDenyImplementation = useDenyImplementation;
    }

    protected void configure() {
        Object interceptor = this.useDenyImplementation ? new DefaultAuthConstraintMethodInterceptor() : new AuthConstraintMethodInterceptor((Provider<CurrentUser>)this.getProvider(CurrentUser.class), this.calls, this.granted, this.denied, this.authenticatedDenied);
        this.bindInterceptor(Matchers.annotatedWith(AuthConstraint.class), Matchers.any(), new MethodInterceptor[]{interceptor});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(AuthConstraint.class), new MethodInterceptor[]{interceptor});
    }
}

