/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.serviceprops;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.peterphi.std.guice.common.serviceprops.ConfigRef;
import com.peterphi.std.threading.Timeout;
import com.peterphi.std.types.Timebase;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.Period;

public class ServicePropertiesModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(ServicePropertiesModule.class);
    protected final CompositeConfiguration configuration;
    protected final PropertiesConfiguration overrides;

    public ServicePropertiesModule(CompositeConfiguration configuration, PropertiesConfiguration overrides) {
        this.configuration = configuration;
        this.overrides = overrides;
    }

    protected void configure() {
        Iterator it = this.configuration.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object currentValue = this.configuration.getProperty(key);
            ConfigRef prop = new ConfigRef((Configuration)this.configuration, key);
            Named name = Names.named((String)key);
            this.bind(ConfigRef.class).annotatedWith((Annotation)name).toInstance((Object)prop);
            if (currentValue instanceof String) {
                this.bind(String.class).annotatedWith((Annotation)name).toProvider((Provider)prop);
                for (Class clazz : new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Timeout.class, Timebase.class, File.class, InetAddress.class, URI.class, URL.class, DateTime.class, DateTimeZone.class, LocalDate.class, LocalTime.class, Period.class, Duration.class, Interval.class}) {
                    this.bind(clazz).annotatedWith((Annotation)name).toProvider(prop.as(clazz));
                }
                continue;
            }
            log.warn((Object)("Non-string property value for " + key + " will only be bound as named ConfigRef type with value: " + currentValue));
        }
    }

    @Provides
    @Singleton
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Provides
    @Singleton
    @Named(value="overrides")
    public PropertiesConfiguration getOverrideConfiguration() {
        return this.overrides;
    }
}

