/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.serviceprops;

import com.peterphi.std.guice.common.serviceprops.ConfigurationPropertyBindingSite;
import com.peterphi.std.guice.common.serviceprops.ConfigurationPropertyRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConfigurationProperty {
    private static final Logger log = Logger.getLogger(ConfigurationProperty.class);
    private final ConfigurationPropertyRegistry registry;
    private final Configuration configuration;
    private final Configuration writeConfiguration;
    private final CopyOnWriteArrayList<ConfigurationPropertyBindingSite> bindings = new CopyOnWriteArrayList();
    private final String name;

    public ConfigurationProperty(ConfigurationPropertyRegistry registry, Configuration configuration, Configuration writeConfiguration, String name) {
        this.registry = registry;
        this.configuration = configuration;
        this.writeConfiguration = writeConfiguration;
        this.name = name;
    }

    public void add(ConfigurationPropertyBindingSite site) {
        this.bindings.add(site);
    }

    public String getName() {
        return this.name;
    }

    public boolean isReconfigurable() {
        for (ConfigurationPropertyBindingSite binding : this.bindings) {
            if (binding.isReconfigurable()) continue;
            return false;
        }
        return true;
    }

    public Class<?> getType() {
        Iterator<ConfigurationPropertyBindingSite> i$ = this.bindings.iterator();
        if (i$.hasNext()) {
            ConfigurationPropertyBindingSite binding = i$.next();
            return binding.getType();
        }
        return null;
    }

    public List<ConfigurationPropertyBindingSite> getBindings() {
        return this.bindings;
    }

    public boolean isDeprecated() {
        for (ConfigurationPropertyBindingSite binding : this.bindings) {
            if (!binding.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    public String getDocumentation() {
        for (ConfigurationPropertyBindingSite binding : this.bindings) {
            String description = binding.getDescription();
            if (StringUtils.isEmpty((String)description)) continue;
            return description;
        }
        return null;
    }

    public Collection<String> getHrefs() {
        TreeSet<String> allHrefs = new TreeSet<String>();
        for (ConfigurationPropertyBindingSite binding : this.bindings) {
            String[] hrefs = binding.getHrefs();
            if (hrefs == null) continue;
            allHrefs.addAll(Arrays.asList(hrefs));
        }
        return allHrefs;
    }

    public void set(String value) {
        log.info((Object)("Attempting to change config property " + this.name + " from current \"" + this.configuration.getString(this.name) + "\" to \"" + value + "\"."));
        this.validate(value);
        this.writeConfiguration.setProperty(this.name, (Object)value);
        if (this.isReconfigurable()) {
            log.info((Object)("All binding sites for property " + this.name + " are reconfigurable; reinjecting..."));
            for (ConfigurationPropertyBindingSite binding : this.bindings) {
                binding.reinject(this.registry.getInstances(binding.getOwner()));
            }
        } else {
            log.info((Object)("Not all binding sites for property " + this.name + " are reconfigurable. Restart will be required to apply this change."));
        }
    }

    public void validate(String value) {
        for (ConfigurationPropertyBindingSite binding : this.bindings) {
            binding.validate(value);
        }
    }
}

