/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.retry.module;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.peterphi.std.guice.common.retry.annotation.Retry;
import com.peterphi.std.guice.common.retry.module.InvocationRetryable;
import com.peterphi.std.guice.common.retry.retry.RetryManager;
import com.peterphi.std.guice.common.retry.retry.backoff.ExponentialBackoff;
import com.peterphi.std.threading.Timeout;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

final class RetryMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = Logger.getLogger(RetryMethodInterceptor.class);
    private final Timer calls;
    private final Timer attempts;
    private final Meter attemptFailures;
    private final Meter totalFailures;

    public RetryMethodInterceptor(MetricRegistry registry) {
        this.calls = registry.timer("feature.auto-retry.calls");
        this.attempts = registry.timer("feature.auto-retry.attempts");
        this.attemptFailures = registry.meter("feature.auto-retry.attempt-failures");
        this.totalFailures = registry.meter("feature.auto-retry.failures");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Timer.Context timer = this.calls.time();
        try {
            Retry options = invocation.getMethod().getAnnotation(Retry.class);
            RetryManager mgr = this.buildRetryManager(options);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Attempting retryable invoke of " + invocation.getMethod().toGenericString() + " on " + invocation.getThis() + " with " + Arrays.asList(invocation.getArguments())));
            }
            Object object = mgr.run(new InvocationRetryable(invocation, options.on(), options.exceptOn(), options.exceptOnCore()));
            return object;
        }
        catch (Throwable t) {
            this.totalFailures.mark();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Retrying invoke of " + invocation.getMethod().toGenericString() + " on " + invocation.getThis() + " with " + Arrays.asList(invocation.getArguments()) + " failed."), t);
            }
            throw t;
        }
        finally {
            timer.stop();
        }
    }

    private RetryManager buildRetryManager(Retry options) {
        Timeout initial = new Timeout(options.backoffTime(), options.backoffUnit());
        ExponentialBackoff backoff = new ExponentialBackoff(initial, options.backoffExponent());
        return new RetryManager(backoff, options.maxAttempts(), this.attempts, this.attemptFailures);
    }
}

