/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.daemon;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.inject.Inject;
import com.peterphi.std.guice.common.daemon.GuiceDaemon;
import com.peterphi.std.guice.common.metrics.GuiceMetricNames;
import com.peterphi.std.threading.Timeout;
import org.apache.log4j.Logger;

public abstract class GuiceRecurringDaemon
extends GuiceDaemon {
    private static final Logger log = Logger.getLogger(GuiceRecurringDaemon.class);
    @Inject
    MetricRegistry metrics;
    private Timer calls;
    private Meter exceptions;
    protected Timeout sleepTime;

    protected GuiceRecurringDaemon(Timeout sleepTime) {
        this(true, sleepTime);
    }

    protected GuiceRecurringDaemon(boolean daemonThread, Timeout sleepTime) {
        super(daemonThread);
        if (sleepTime == null || sleepTime.getMilliseconds() < 0L) {
            throw new IllegalArgumentException("Cannot provide a negative sleep time!");
        }
        this.sleepTime = sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning()) {
            Timer.Context timer = this.calls != null ? this.calls.time() : null;
            try {
                this.execute();
            }
            catch (Throwable t) {
                if (this.exceptions != null) {
                    this.exceptions.mark();
                }
                log.error((Object)"Ignoring exception in GuiceRecurringDaemon call", t);
            }
            finally {
                if (timer != null) {
                    timer.stop();
                }
            }
            this.sleep(this.sleepTime);
        }
    }

    protected void executeException(Throwable t) {
        log.error((Object)"Ignoring exception in GuiceRecurringDaemon call", t);
    }

    protected abstract void execute() throws Exception;

    @Override
    public void postConstruct() {
        this.calls = this.metrics.timer(GuiceMetricNames.name(this.getClass(), "calls"));
        this.exceptions = this.metrics.meter(GuiceMetricNames.name(this.getClass(), "exceptions"));
        super.postConstruct();
    }
}

