/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.daemon;

import com.google.inject.Inject;
import com.peterphi.std.guice.common.lifecycle.GuiceLifecycleListener;
import com.peterphi.std.guice.common.shutdown.iface.ShutdownManager;
import com.peterphi.std.guice.common.shutdown.iface.StoppableService;
import com.peterphi.std.threading.Daemon;
import com.peterphi.std.threading.Timeout;

public abstract class GuiceDaemon
extends Daemon
implements StoppableService,
GuiceLifecycleListener {
    private boolean daemonThread;
    @Inject
    ShutdownManager shutdownManager;

    public GuiceDaemon() {
        this(true);
    }

    public GuiceDaemon(boolean daemonThread) {
        this.daemonThread = daemonThread;
    }

    protected boolean shouldStartAsDaemon() {
        return this.daemonThread;
    }

    @Override
    public void postConstruct() {
        this.startThread();
        this.shutdownManager.register(this);
    }

    @Override
    public void shutdown() {
        this.stopThread();
    }

    protected void sleep(long millis) {
        if (!this.isRunning() || millis <= 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void sleep(Timeout timeout) {
        if (!this.isRunning() || timeout.getMilliseconds() <= 0L) {
            return;
        }
        this.sleep(timeout.getMilliseconds());
    }
}

