/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.PrefixFilter;

public class ClassScanner {
    private static final Logger log = Logger.getLogger(ClassScanner.class);
    private final AnnotationFinder finder;
    private final long constructionTime;
    private final AtomicLong searchTime = new AtomicLong(0L);

    private ClassScanner(AnnotationFinder finder, long constructionTime) {
        this.finder = finder;
        this.constructionTime = constructionTime;
    }

    public long getConstructionTime() {
        return this.constructionTime;
    }

    public long getSearchTime() {
        return this.searchTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getClasses(String pkg, boolean recursive, Predicate<Class<?>> predicate) {
        long started = System.currentTimeMillis();
        try {
            List<Class<?>> list = this.filter(this.finder.findClassesInPackage(pkg, recursive), predicate);
            return list;
        }
        finally {
            long finished = System.currentTimeMillis();
            this.searchTime.addAndGet(finished - started);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getClasses " + pkg + " with predicate=" + predicate + " returned in " + (finished - started) + " ms"));
            }
        }
    }

    public List<Class<?>> getClasses(String pkg, boolean recursive) {
        return this.getClasses(pkg, recursive, null);
    }

    public List<Class<?>> getSiblingClasses(Class<?> clazz, boolean recursive, Predicate<Class<?>> predicate) {
        return this.getClasses(ClassScanner.getPackages(clazz)[0], recursive, predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation, Predicate<Class<?>> predicate) {
        long started = System.currentTimeMillis();
        try {
            List<Class<?>> list = this.filter(this.finder.findAnnotatedClasses(annotation), predicate);
            return list;
        }
        finally {
            long finished = System.currentTimeMillis();
            this.searchTime.addAndGet(finished - started);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getAnnotatedClasses " + annotation + " with predicate=" + predicate + " returned in " + (finished - started) + " ms"));
            }
        }
    }

    public List<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
        return this.getAnnotatedClasses(annotation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<?>> getInheritedAnnotatedClasses(Class<? extends Annotation> annotation, Predicate<Class<?>> predicate) {
        long started = System.currentTimeMillis();
        try {
            List<Class<?>> list = this.filter(this.finder.findInheritedAnnotatedClasses(annotation), predicate);
            return list;
        }
        finally {
            long finished = System.currentTimeMillis();
            this.searchTime.addAndGet(finished - started);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getInheritedAnnotatedClasses " + annotation + " with predicate=" + predicate + " returned in " + (finished - started) + " ms"));
            }
        }
    }

    public List<Class<?>> getInheritedAnnotatedClasses(Class<? extends Annotation> annotation) {
        return this.getInheritedAnnotatedClasses(annotation, null);
    }

    public <T> List<Class<? extends T>> getExtendingClasses(Class<T> clazz) {
        return this.getExtendingClasses(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<Class<? extends T>> getExtendingClasses(Class<T> clazz, Predicate<Class<? extends T>> predicate) {
        long started = System.currentTimeMillis();
        try {
            List<Class<? extends T>> list = this.filter(this.finder.findImplementations(clazz), predicate);
            return list;
        }
        finally {
            long finished = System.currentTimeMillis();
            this.searchTime.addAndGet(finished - started);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getExtendingClasses " + clazz + " with predicate=" + predicate + " returned in " + (finished - started) + " ms"));
            }
        }
    }

    private <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        if (predicate != null) {
            Iterator<T> it = list.iterator();
            while (it.hasNext()) {
                if (predicate.apply(it.next())) continue;
                it.remove();
            }
        }
        return list;
    }

    public static ClassScanner forPackages(String ... packages) {
        return ClassScanner.forPackages(Thread.currentThread().getContextClassLoader(), packages);
    }

    public static ClassScanner forPackages(Class<?> ... classes) {
        return ClassScanner.forPackages(ClassScanner.getPackages(classes));
    }

    public static ClassScanner forPackages(ClassLoader classloader, String ... packages) {
        long started = System.currentTimeMillis();
        CompositeArchive archive = ClassScanner.getArchivesForPackage(classloader, packages);
        AnnotationFinder finder = new AnnotationFinder((Archive)archive, true);
        long finished = System.currentTimeMillis();
        return new ClassScanner(finder, finished - started);
    }

    private static String[] getPackages(Class<?> ... classes) {
        HashSet<String> set = new HashSet<String>(classes.length);
        for (Class<?> clazz : classes) {
            set.add(clazz.getPackage().getName());
        }
        return set.toArray(new String[set.size()]);
    }

    private static CompositeArchive getArchivesForPackage(ClassLoader classloader, String ... packages) {
        try {
            ArrayList<Object> archives = new ArrayList<Object>();
            for (String pkg : packages) {
                if (!pkg.endsWith(".")) {
                    pkg = pkg + ".";
                }
                String baseFolder = pkg.replace('.', '/');
                Enumeration<URL> urls = classloader.getResources(baseFolder);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    log.info((Object)("Found source: " + url));
                    if (url.getProtocol() != null && (url.getProtocol().equals("zip") || url.getProtocol().equals("jar"))) {
                        archives.add(new FilteredArchive((Archive)new JarArchive(classloader, url), (Filter)new PrefixFilter(pkg)));
                        continue;
                    }
                    archives.add(new FileArchive(classloader, url, pkg));
                }
            }
            return new CompositeArchive(archives);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error loading archives for packages: " + Arrays.asList(packages), e);
        }
    }

    public static Predicate<Class<?>> annotatedWith(final Class<? extends Annotation> annotation) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isAnnotationPresent(annotation);
            }
        };
    }

    public static Predicate<Class<?>> packagePredicate(final Predicate<String> packagePredicate) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return packagePredicate.apply((Object)input.getPackage().getName());
            }
        };
    }

    public static Predicate<Class<?>> interfaceClass() {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isInterface();
            }
        };
    }
}

