/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.daemon;

import com.peterphi.std.guice.common.daemon.GuiceDaemon;
import com.peterphi.std.threading.Timeout;
import org.apache.log4j.Logger;

public abstract class GuiceRecurringDaemon
extends GuiceDaemon {
    private static final Logger log = Logger.getLogger(GuiceRecurringDaemon.class);
    protected Timeout sleepTime;

    protected GuiceRecurringDaemon(Timeout sleepTime) {
        this(true, sleepTime);
    }

    protected GuiceRecurringDaemon(boolean daemonThread, Timeout sleepTime) {
        super(daemonThread);
        if (sleepTime == null || sleepTime.getMilliseconds() < 0L) {
            throw new IllegalArgumentException("Cannot provide a negative sleep time!");
        }
        this.sleepTime = sleepTime;
    }

    public void run() {
        while (this.isRunning()) {
            try {
                this.execute();
            }
            catch (Throwable t) {
                log.error((Object)"Ignoring exception in GuiceRecurringDaemon call", t);
            }
            this.sleep(this.sleepTime);
        }
    }

    protected void executeException(Throwable t) {
        log.error((Object)"Ignoring exception in GuiceRecurringDaemon call", t);
    }

    protected abstract void execute() throws Exception;
}

