/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IFix;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Fix;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.FixJobsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IFixDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class FixDelegator
extends BaseDelegator
implements IFixDelegator {
    public FixDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFix> fixJobs(List<String> jobIds, int changeListId, String status, boolean delete) throws ConnectionException, RequestException, AccessException {
        try {
            FixJobsOptions fixJobsOptions = new FixJobsOptions().setDelete(delete).setStatus(status);
            return this.fixJobs(jobIds, changeListId, fixJobsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFix> fixJobs(@Nonnull List<String> jobIds, int changeListId, FixJobsOptions opts) throws P4JavaException {
        Validate.notNull(jobIds);
        String actualChangeId = "default";
        if (changeListId != 0) {
            actualChangeId = String.valueOf(changeListId);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-c" + actualChangeId);
        args.addAll(jobIds);
        ArrayList<IFix> fixList = new ArrayList<IFix>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.FIX, Parameters.processParameters((Options)opts, null, args.toArray(new String[args.size()]), (IServer)this.server), null);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                ResultMapParser.throwRequestExceptionIfErrorMessageFound(map);
                fixList.add(new Fix(map));
            }
        }
        return fixList;
    }
}

