/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.ILabelMapping;
import com.perforce.p4java.core.ILabelSummary;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.LabelSummary;
import com.perforce.p4java.impl.generic.core.MapEntry;
import com.perforce.p4java.server.IServer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Label
extends LabelSummary
implements ILabel {
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    protected ViewMap<ILabelMapping> viewMapping = null;
    public static final String DEFAULT_DESCRIPTION = "New label created by P4Java";
    public static final String DEFAULT_MAPPING = "//depot/...";

    public static Label newLabel(IServer server, String name, String description, String[] mapping) {
        ViewMap<ILabelMapping> viewMapping = new ViewMap<ILabelMapping>();
        if (server == null) {
            throw new NullPointerError("null server in Label,newLabel()");
        }
        if (name == null) {
            throw new NullPointerError("null label name in Label.newLabel()");
        }
        if (mapping == null) {
            mapping = new String[]{DEFAULT_MAPPING};
        }
        int i = 0;
        for (String map : mapping) {
            if (map == null) {
                throw new NullPointerError("null mapping element in Label.newLabel()");
            }
            LabelMapping entry = new LabelMapping(i, map);
            viewMapping.addEntry(entry);
            ++i;
        }
        Label label = new Label(name, server.getUserName(), null, null, description == null ? DEFAULT_DESCRIPTION : description, null, false, viewMapping);
        label.setServer(server);
        return label;
    }

    public Label() {
        super(false);
    }

    public Label(String name, String ownerName, Date lastAccess, Date lastUpdate, String description, String revisionSpec, boolean locked, ViewMap<ILabelMapping> viewMapping) {
        super(false);
        this.name = name;
        this.ownerName = ownerName;
        this.lastAccess = lastAccess;
        this.lastUpdate = lastUpdate;
        this.description = description;
        this.revisionSpec = revisionSpec;
        this.locked = locked;
        this.viewMapping = viewMapping;
    }

    public Label(Map<String, Object> map, IServer server) {
        super(false);
        this.server = server;
        try {
            String[] optParts;
            this.name = (String)map.get("Label");
            this.description = (String)map.get("Description");
            if (this.description != null) {
                this.description = this.description.trim();
            }
            this.ownerName = (String)map.get("Owner");
            this.revisionSpec = (String)map.get("Revision");
            try {
                if (map.containsKey("Update")) {
                    this.lastUpdate = new SimpleDateFormat(DATE_FORMAT).parse((String)map.get("Update"));
                }
                if (map.containsKey("Access")) {
                    this.lastAccess = new SimpleDateFormat(DATE_FORMAT).parse((String)map.get("Access"));
                }
            }
            catch (ParseException pe) {
                Log.error("Date parse error in Label constructor: " + pe.getLocalizedMessage(), new Object[0]);
                Log.exception(pe);
            }
            String optStr = (String)map.get("Options");
            if (optStr != null && (optParts = optStr.split("\\s+")) != null && optParts.length > 0) {
                for (String optPart : optParts) {
                    if (optPart.equalsIgnoreCase("locked")) {
                        this.locked = true;
                        continue;
                    }
                    if (optPart.equalsIgnoreCase("unlocked")) {
                        this.locked = false;
                        continue;
                    }
                    if (optPart.equalsIgnoreCase("autoreload")) {
                        this.autoreload = true;
                        continue;
                    }
                    if (!optPart.equalsIgnoreCase("noautoreload")) continue;
                    this.autoreload = false;
                }
            }
            this.viewMapping = new ViewMap();
            int i = 0;
            while (true) {
                String mappingStr = (String)map.get("View" + i);
                String commentStr = (String)map.get("ViewComment" + i);
                if (mappingStr != null || commentStr != null) {
                    String[] parts = MapEntry.parseViewMappingString(mappingStr);
                    LabelMapping mapping = new LabelMapping(i, parts[0]);
                    mapping.setComment(MapEntry.parseComments(commentStr));
                    this.viewMapping.getEntryList().add(mapping);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception in Label constructor: " + thr.getLocalizedMessage(), new Object[0]);
            Log.exception(thr);
        }
    }

    public Label(ILabelSummary labelSummary) throws ConnectionException, RequestException, AccessException {
        super(false);
        this.viewMapping = new ViewMap();
        if (labelSummary != null) {
            this.name = labelSummary.getName();
            this.ownerName = labelSummary.getOwnerName();
            this.lastAccess = labelSummary.getLastAccess();
            this.lastUpdate = labelSummary.getLastUpdate();
            this.description = labelSummary.getDescription();
            this.revisionSpec = labelSummary.getRevisionSpec();
            this.locked = labelSummary.isLocked();
            if (this.name != null) {
                this.refresh();
            }
        }
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        ILabel refreshedLabel;
        IServer refreshServer = this.server;
        String refreshName = this.name;
        if (refreshServer != null && refreshName != null && (refreshedLabel = refreshServer.getLabel(refreshName)) != null) {
            this.description = refreshedLabel.getDescription();
            this.ownerName = refreshedLabel.getOwnerName();
            this.revisionSpec = refreshedLabel.getRevisionSpec();
            this.lastUpdate = refreshedLabel.getLastUpdate();
            this.lastAccess = refreshedLabel.getLastAccess();
            this.locked = refreshedLabel.isLocked();
            this.viewMapping = refreshedLabel.getViewMapping();
        }
    }

    @Override
    @Deprecated
    public String updateOnServer() throws ConnectionException, RequestException, AccessException {
        if (this.server == null) {
            throw new RequestException("label not associated with any Perforce server");
        }
        return this.server.updateLabel(this);
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        this.server.updateLabel(this);
    }

    @Override
    public void setViewMapping(ViewMap<ILabelMapping> viewMapping) {
        this.viewMapping = viewMapping;
    }

    @Override
    public ViewMap<ILabelMapping> getViewMapping() {
        return this.viewMapping;
    }

    @Override
    public IServer getServer() {
        return this.server;
    }

    @Override
    public void setServer(IServer server) {
        this.server = server;
    }

    public static class LabelMapping
    extends MapEntry
    implements ILabelMapping {
        public LabelMapping() {
        }

        public LabelMapping(int order, String labelMapping) {
            super(order, labelMapping);
        }

        @Override
        public String getViewMapping() {
            return this.left;
        }

        @Override
        public void setViewMapping(String entry) {
            this.left = entry;
        }
    }
}

