/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.mapapi;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.mapapi.MapFlag;
import com.perforce.p4java.mapapi.MapTable;
import java.util.List;

public class MapTableBuilder {
    public static MapTable buildMapTable(IClient client) {
        List clientMappings = client.getClientView().getEntryList();
        MapTable mt = new MapTable();
        for (IClientViewMapping clientmapping : clientMappings) {
            IMapEntry.EntryType type = clientmapping.getType();
            MapFlag mapFlag = MapTableBuilder.convertType(type);
            mt.insert(clientmapping.getLeft(), clientmapping.getRight(), mapFlag);
        }
        return mt;
    }

    private static MapFlag convertType(IMapEntry.EntryType type) {
        switch (type) {
            case INCLUDE: {
                return MapFlag.MfMap;
            }
            case OVERLAY: {
                return MapFlag.MfRemap;
            }
            case EXCLUDE: {
                return MapFlag.MfUnmap;
            }
            case DITTO: {
                return MapFlag.MfAndmap;
            }
        }
        return MapFlag.MfMap;
    }
}

