/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.ILicense;
import com.perforce.p4java.core.ILicenseLimits;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.License;
import com.perforce.p4java.impl.generic.core.LicenseLimits;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.ILicenseDelegator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class LicenseDelegator
extends BaseDelegator
implements ILicenseDelegator {
    public LicenseDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public ILicenseLimits getLimits() throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LICENSE, new String[]{"-u"}, null);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                ResultMapParser.handleErrorStr(map);
                if (ResultMapParser.isInfoMessage(map)) continue;
                return new LicenseLimits(map);
            }
        }
        return null;
    }

    @Override
    public ILicense getLicense() throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LICENSE, new String[]{"-o"}, null);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                ResultMapParser.handleErrorStr(map);
                if (ResultMapParser.isInfoMessage(map)) continue;
                return new License(map);
            }
        }
        return null;
    }

    @Override
    public String updateLicense(ILicense license) throws P4JavaException {
        Validate.notNull((Object)license);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.LICENSE, new String[]{"-i"}, InputMapper.map(license));
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }
}

