/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.io.apple.AppleFileData;
import com.perforce.p4java.io.apple.AppleFileDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AppleFileHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFile(RpcPerforceFile file) {
        if (file.getFileType() == RpcPerforceFileType.FST_APPLEFILE) {
            FileOutputStream fosData = null;
            FileOutputStream fosResource = null;
            try {
                byte[] data = AppleFileHelper.getBytesFromFile(file);
                AppleFileData fileData = new AppleFileData(data);
                AppleFileDecoder appleFile = new AppleFileDecoder(fileData);
                appleFile.extract();
                fosData = new FileOutputStream(file);
                AppleFileData forkData = appleFile.getDataFork();
                if (forkData != AppleFileData.EMPTY_FILE_DATA) {
                    fosData.write(forkData.getBytes());
                }
                String resourceFilePath = file.getParent() + File.separator + "%" + file.getName();
                RpcPerforceFile targetResourceFile = new RpcPerforceFile(resourceFilePath, file.getFileType());
                fosResource = new FileOutputStream(targetResourceFile);
                AppleFileData forkResource = appleFile.getResourceFork();
                if (forkResource != AppleFileData.EMPTY_FILE_DATA) {
                    fosResource.write(forkResource.getBytes());
                }
            }
            catch (IOException e) {
                Log.error("Problem handling the Apple file: " + file.getName(), new Object[0]);
            }
            catch (FileDecoderException e) {
                Log.error("Problem decoding the Apple file: " + file.getName(), new Object[0]);
            }
            finally {
                if (fosData != null) {
                    try {
                        fosData.close();
                    }
                    catch (Exception e) {}
                }
                if (fosResource != null) {
                    try {
                        fosResource.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Apple file too large for decoding.");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        try {
            int offset;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read the Apple file " + file.getName());
            }
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytes;
    }
}

