/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.InvalidUrlException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.exception.UnimplementedError;
import com.perforce.p4java.impl.generic.core.DefaultParallelSync;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.Mangle;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MapUnmapper;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.callback.IParallelCallback;
import com.perforce.p4java.server.callback.ISSOCallback;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ClientUserInteraction {
    public static final String TRACE_PREFIX = "ClientUserInteraction";
    protected static final int RESP_LENGTH = 32;
    protected static final int TRUNCATE_LENGTH = 16;
    private Properties props = null;
    private RpcServer server = null;

    protected ClientUserInteraction(Properties props, RpcServer server) {
        this.props = props;
        this.server = server;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientPrompt(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientPrompt().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientPrompt().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientPrompt().");
        }
        String data2 = null;
        String digest = null;
        String func2 = null;
        String state = null;
        String userName = null;
        String host = null;
        String confirm = null;
        String mangle = null;
        boolean truncate = false;
        boolean noecho = false;
        MD5Digester digester = null;
        String passwd = null;
        String resp = null;
        try {
            Map<String, Object> inMap;
            data2 = (String)resultsMap.get("data2");
            digest = (String)resultsMap.get("digest");
            truncate = resultsMap.containsKey("truncate");
            func2 = (String)resultsMap.get("func2");
            userName = (String)resultsMap.get("user");
            host = (String)resultsMap.get("host");
            state = (String)resultsMap.get("state");
            confirm = (String)resultsMap.get("confirm");
            noecho = resultsMap.containsKey("noecho");
            mangle = (String)resultsMap.get("mangle");
            boolean noprompt = resultsMap.containsKey("noprompt");
            if (confirm == null) {
                throw new ProtocolError("No confirm server function in clientPrompt.");
            }
            RpcFunctionSpec funcSpec = RpcFunctionSpec.decode(confirm);
            if (funcSpec == RpcFunctionSpec.NONE) {
                throw new ProtocolError("Unable to decode confirm server function '" + confirm + "' in clientPrompt.");
            }
            if (noprompt) {
                passwd = this.server.getPBuf(userName);
            }
            if ((inMap = cmdEnv.getCmdSpec().getInMap()) == null) {
                throw new NullPointerError("No input map passed to client prompt.");
            }
            if (passwd == null) {
                String promptText = null;
                if (resultsMap.containsKey("data")) {
                    promptText = new String((byte[])resultsMap.get("data"), CharsetDefs.UTF8);
                }
                if (promptText == null && !noprompt && resultsMap.containsKey("fmt0")) {
                    promptText = RpcMessage.interpolateArgs((String)resultsMap.get("fmt0"), resultsMap);
                }
                if (promptText != null) {
                    if (promptText.contains("Enter password") && inMap.containsKey("password")) {
                        passwd = ((String)inMap.get("password")).replace("\n", "").replace("\r", "");
                    } else if (promptText.contains("Enter old password") && inMap.containsKey("oldPassword")) {
                        passwd = ((String)inMap.remove("oldPassword")).replace("\n", "").replace("\r", "");
                    } else if (promptText.contains("Enter new password") && inMap.containsKey("newPassword")) {
                        passwd = ((String)inMap.remove("newPassword")).replace("\n", "").replace("\r", "");
                    } else if (promptText.contains("Re-enter new password") && inMap.containsKey("newPassword2")) {
                        passwd = ((String)inMap.remove("newPassword2")).replace("\n", "").replace("\r", "");
                    }
                }
            }
            if (passwd == null) {
                switch (funcSpec) {
                    case SERVER_DM_LOGIN: 
                    case SERVER_DM_LOGIN2: {
                        if (inMap.get("password") == null) break;
                        passwd = ((String)inMap.get("password")).replace("\n", "").replace("\r", "");
                        break;
                    }
                    case SERVER_DM_PASSWD: {
                        if (inMap.get("oldPassword") != null) {
                            passwd = ((String)inMap.remove("oldPassword")).replace("\n", "").replace("\r", "");
                            break;
                        }
                        if (inMap.get("newPassword") != null) {
                            passwd = ((String)inMap.remove("newPassword")).replace("\n", "").replace("\r", "");
                            break;
                        }
                        if (inMap.get("newPassword2") == null) break;
                        passwd = ((String)inMap.remove("newPassword2")).replace("\n", "").replace("\r", "");
                        break;
                    }
                    default: {
                        throw new UnimplementedError("Unimplemented confirmation to server function '" + funcSpec.getEncoding() + "' in clientPrompt.");
                    }
                }
            }
            if (passwd == null) {
                throw new NullPointerError("No password passed to clientPrompt.");
            }
            this.server.setPbuf(userName, passwd);
            if (truncate && passwd.length() > 16) {
                passwd = passwd.substring(0, 16);
            }
            if (digest != null) {
                String daddr;
                digester = new MD5Digester();
                digester.update(passwd.getBytes(CharsetDefs.UTF8.name()));
                resp = digester.digestAs32ByteHex();
                if (cmdEnv.getServerProtocolLevel() >= 20) {
                    this.server.setSecretKey(userName, resp);
                }
                if (digest.length() > 0) {
                    digester.reset();
                    digester.update(resp.getBytes(CharsetDefs.UTF8.name()));
                    digester.update(digest.getBytes(CharsetDefs.UTF8.name()));
                    resp = digester.digestAs32ByteHex();
                }
                if ((daddr = rpcConnection.getServerIpPort()).equals("0")) {
                    daddr = null;
                }
                if (daddr != null) {
                    resultsMap.put("daddr", daddr);
                    if (cmdEnv.getServerProtocolLevel() >= 29) {
                        digester.reset();
                        digester.update(resp.getBytes(CharsetDefs.UTF8.name()));
                        digester.update(daddr.getBytes(CharsetDefs.UTF8.name()));
                        resp = digester.digestAs32ByteHex();
                    }
                }
            } else if (mangle != null) {
                MD5Digester mangleDigester = new MD5Digester();
                mangleDigester.update(mangle);
                mangleDigester.update(userName);
                if (cmdEnv.getServerProtocolLevel() >= 20) {
                    String skey = this.server.getSecretKey(userName);
                    if (skey != null && skey.length() > 0) {
                        mangleDigester.update(skey);
                    }
                    if (data2 != null) {
                        this.server.setSecretKey(userName, null);
                    }
                }
                Mangle jMangle = new Mangle();
                String toMangle = resp;
                if (toMangle == null) {
                    toMangle = passwd;
                }
                String digestedMangle = mangleDigester.digestAs32ByteHex();
                resp = jMangle.encrypt(toMangle, digestedMangle);
            }
            resultsMap.put("data", resp);
            return rpcConnection.clientConfirm(confirm, resultsMap);
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new P4JavaError("Unexpected exception in ClientUserInteraction.clientPrompt:" + exc.getLocalizedMessage(), exc);
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientSetPassword(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientSetPassword().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientSetPassword().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientSetPassword().");
        }
        if (this.server != null) {
            boolean sameUser;
            String data2 = (String)resultsMap.get("data2");
            String userName = (String)resultsMap.get("user");
            String serverId = (String)resultsMap.get("serverAddress");
            String ticket = null;
            boolean bl = sameUser = userName == null || userName.equals(this.server.getUserName()) || resultsMap.containsKey("userChanged");
            if (serverId != null) {
                this.server.setServerId(serverId);
            }
            if (userName == null) {
                userName = this.server.getUserName();
            }
            String serverAddress = serverId != null ? serverId : this.server.getServerAddress();
            String key = serverAddress + "=" + userName;
            if (CmdSpec.LOGOUT.toString().equals(data2)) {
                cmdEnv.getCmdSpec().setCmdTicket(null);
                if (this.server.getAuthCounter().decrementAndGet(key) <= 0) {
                    this.server.setAuthTicket(userName, serverId, null);
                }
                try {
                    this.server.saveTicket(userName, serverId, null);
                }
                catch (ConfigException e) {
                    throw new ConnectionException(e);
                }
            } else if (CmdSpec.LOGIN.toString().equals(data2)) {
                byte[] data = (byte[])resultsMap.get("data");
                String digest = (String)resultsMap.get("digest");
                if (digest != null) {
                    String secretKey;
                    if (digest.length() != 32) {
                        throw new P4JavaError("bad digest size");
                    }
                    String string = secretKey = sameUser ? this.server.getSecretKey(userName) : null;
                    if (secretKey == null) {
                        secretKey = this.server.getAuthTicket(userName, serverId);
                    }
                    if (secretKey == null && !(secretKey = this.server.getAuthTicket()).matches("^[0-9A-F]{32}$")) {
                        MD5Digester md5 = new MD5Digester();
                        md5.update(secretKey);
                        secretKey = md5.digestAs32ByteHex();
                    }
                    ticket = new String(data);
                    Mangle mangler = new Mangle();
                    String token2 = mangler.mangle(digest, secretKey, true);
                    ticket = mangler.xor32(ticket, token2);
                }
                if (data != null) {
                    if (ticket == null) {
                        ticket = new String(data);
                    }
                    this.server.setAuthTicket(userName, serverId, ticket);
                    if (!cmdEnv.isDontWriteTicket() || !resultsMap.containsKey("output")) {
                        try {
                            this.server.saveTicket(userName, serverId, ticket);
                        }
                        catch (ConfigException e) {
                            throw new ConnectionException(e);
                        }
                    } else {
                        HashMap<String, Object> respMap = new HashMap<String, Object>();
                        respMap.put("ticket", ticket);
                        cmdEnv.handleResult(respMap);
                    }
                    this.server.getAuthCounter().incrementAndGet(key);
                }
            }
            this.server.setSecretKey(userName, null);
            if (resultsMap.containsKey("noprompt")) {
                this.server.setPbuf(userName, null);
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientSingleSignon(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientSingleSignon().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientSingleSignon().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientSingleSignon().");
        }
        String confirm = (String)resultsMap.get("confirm");
        ISSOCallback.Status status = null;
        StringBuffer credBuf = new StringBuffer();
        if (this.server != null) {
            ISSOCallback ssoCallback = this.server.getSSOCallback();
            if (ssoCallback != null) {
                status = ssoCallback.getSSOCredentials(credBuf, this.server.getSSOKey(), this.server.getUserName());
            }
        } else {
            Log.error("null server object in ClientUserInteraction.clientSingleSignon method", new Object[0]);
        }
        if (status == null) {
            status = ISSOCallback.Status.UNSET;
        }
        resultsMap.put("status", status.toString().toLowerCase());
        String sso = null;
        if (status != ISSOCallback.Status.UNSET) {
            sso = credBuf != null && credBuf.length() > 131072 ? credBuf.substring(0, 131072) : credBuf.toString();
        }
        resultsMap.put("sso", sso);
        rpcConnection.clientConfirm(confirm, resultsMap);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientReceiveFiles(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientReceiveFiles().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientReceiveFiles().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientReceiveFiles().");
        }
        String token = (String)resultsMap.get("token");
        String threads = (String)resultsMap.get("peer");
        String blockCount = (String)resultsMap.get("blockCount");
        String blockSize = (String)resultsMap.get("scanSize");
        String proxyload = (String)resultsMap.get("proxyload");
        String proxyverbose = (String)resultsMap.get("proxyverbose");
        String applicense = (String)resultsMap.get("app");
        String clientSend = (String)resultsMap.get("clientSend");
        String confirm = (String)resultsMap.get("confirm");
        if (token == null || threads == null) {
            throw new NullPointerError("Null token or threads in clientReceiveFiles().");
        }
        int nThreads = 0;
        try {
            nThreads = Integer.parseInt(threads);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
        IParallelCallback callback = cmdEnv.getParallelCallback();
        if (callback == null) {
            callback = new DefaultParallelSync();
        }
        HashMap<String, String> flags = new HashMap<String, String>();
        if (proxyload != null) {
            flags.put("proxyload", "");
        }
        if (proxyverbose != null) {
            flags.put("proxyverbose", "");
        }
        if (applicense != null) {
            flags.put("app", applicense);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-t" + token);
        if (blockCount != null) {
            args.add("-b" + blockCount);
        }
        if (blockSize != null) {
            args.add("-s" + blockSize);
        }
        if (clientSend != null) {
            args.add("-r");
        }
        if (!callback.transmit(cmdEnv, nThreads, flags, args)) {
            rpcConnection.clientConfirm(confirm, resultsMap);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientAck(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientAck().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientAck().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientAck().");
        }
        String confirm = (String)resultsMap.get("confirm");
        String decline = (String)resultsMap.get("decline");
        String handle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        if (handler != null) {
            if (handler.isError()) {
                confirm = decline;
            }
        } else if (cmdEnv.getSyncTime() != 0L) {
            resultsMap.put("syncTime", cmdEnv.getSyncTime());
        }
        cmdEnv.setSyncTime(0L);
        rpcConnection.clientConfirm(confirm, resultsMap);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientCrypto(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientCrypto().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientCrypto().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientCrypto().");
        }
        String ticketStr = null;
        String ticketStr2 = cmdEnv.getCmdSpec().getCmdTicket();
        String svcTicketStr = null;
        MD5Digester digester = new MD5Digester();
        String resp = null;
        String confirm = (String)resultsMap.get("confirm");
        String token = (String)resultsMap.get("token");
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        boolean proxy = this.props.containsKey("ipaddr") && this.props.containsKey("svrname") && this.props.containsKey("port");
        String svcUser = this.props.getProperty("svrname");
        try {
            String daddr;
            String serverId = (String)resultsMap.get("serverAddress");
            if (serverId != null) {
                this.server.setServerId(serverId);
            }
            if (proxy) {
                svcTicketStr = this.getTicketStr(svcUser, serverId);
            } else {
                ticketStr = this.getTicketStr(this.server.getUserName(), serverId);
            }
            if (ticketStr == null) {
                ticketStr = ticketStr2;
                ticketStr2 = null;
            }
            if (ticketStr == null) {
                ticketStr = "";
            }
            if ((daddr = rpcConnection.getServerIpPort()).equals("0")) {
                daddr = null;
            }
            String daddr0 = null;
            if (proxy) {
                daddr0 = daddr;
                daddr = this.props.getProperty("port");
            }
            digester.reset();
            digester.update(token.getBytes(CharsetDefs.UTF8.name()));
            digester.update(ticketStr.getBytes());
            resp = digester.digestAs32ByteHex();
            if (cmdEnv.getServerProtocolLevel() >= 29 && daddr != null) {
                digester.reset();
                digester.update(resp.getBytes());
                digester.update(daddr.getBytes());
                resp = digester.digestAs32ByteHex();
                respMap.put("daddr", daddr);
            }
            respMap.put("token", resp);
            if (ticketStr2 != null) {
                digester.reset();
                digester.update(token.getBytes(CharsetDefs.UTF8.name()));
                digester.update(ticketStr2.getBytes());
                resp = digester.digestAs32ByteHex();
                if (cmdEnv.getServerProtocolLevel() >= 29 && daddr != null) {
                    digester.reset();
                    digester.update(resp.getBytes());
                    digester.update(daddr.getBytes());
                    resp = digester.digestAs32ByteHex();
                }
                respMap.put("token2", resp);
            }
            if (proxy) {
                respMap.put("caddr", this.props.getProperty("ipaddr"));
            }
            if (daddr0 != null) {
                digester.reset();
                digester.update(svcUser.getBytes());
                if (svcTicketStr != null) {
                    digester.update(svcTicketStr.getBytes());
                }
                digester.update(token.getBytes(CharsetDefs.UTF8.name()));
                digester.update(daddr0.getBytes());
                resp = digester.digestAs32ByteHex();
                respMap.put("svrname0", svcUser);
                respMap.put("daddr0", daddr0);
                respMap.put("dhash0", resp);
            }
            RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
            rpcConnection.putRpcPacket(respPacket);
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new P4JavaError("Unexpected exception in ClientUserInteraction.clientCrypto:" + exc.getLocalizedMessage(), exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private String getTicketStr(String user, String serverId) {
        String ticketStr = this.server.getAuthTicket(user, serverId);
        if ((ticketStr == null || ticketStr.isEmpty()) && (ticketStr = this.server.loadTicket(serverId, user)) != null) {
            this.server.setAuthTicket(user, serverId, ticketStr);
        }
        if (ticketStr != null && ticketStr.isEmpty()) {
            return null;
        }
        return ticketStr;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientOpenURL(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientOpenURL).");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientOpenURL().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientOpenURL().");
        }
        String urlString = (String)resultsMap.get("url");
        if (!urlString.contains("https://") && !urlString.contains("http://")) {
            throw new InvalidUrlException();
        }
        try {
            this.server.getBrowserCallback().launchBrowser(urlString);
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientInputData(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientInputData().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientInputData().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientInputData().");
        }
        cmdEnv.newHandler();
        String confirm = (String)resultsMap.get("confirm");
        Map<String, Object> inMap = cmdEnv.getCmdSpec().getInMap();
        String inString = cmdEnv.getCmdSpec().getInString();
        if (inString == null) {
            StringBuffer strBuf = new StringBuffer();
            byte[] bytes = null;
            String cmdName = cmdEnv.getCmdSpec().getCmdName();
            if (cmdName == null) {
                throw new NullPointerError("null command name");
            }
            CmdSpec cmdSpec = CmdSpec.getValidP4JCmdSpec(cmdName);
            if (cmdSpec != null) {
                switch (cmdSpec) {
                    case JOB: {
                        MapUnmapper.unmapJobMap(inMap, strBuf);
                        break;
                    }
                    case CHANGE: 
                    case SUBMIT: 
                    case SHELVE: {
                        MapUnmapper.unmapChangelistMap(inMap, strBuf);
                        break;
                    }
                    case LABEL: {
                        MapUnmapper.unmapLabelMap(inMap, strBuf);
                        break;
                    }
                    case CLIENT: {
                        MapUnmapper.unmapClientMap(inMap, strBuf);
                        break;
                    }
                    case BRANCH: {
                        MapUnmapper.unmapBranchMap(inMap, strBuf);
                        break;
                    }
                    case USER: {
                        MapUnmapper.unmapUserMap(inMap, strBuf);
                        break;
                    }
                    case GROUP: {
                        MapUnmapper.unmapUserGroupMap(inMap, strBuf);
                        break;
                    }
                    case DEPOT: {
                        MapUnmapper.unmapDepotMap(inMap, strBuf);
                        break;
                    }
                    case PROTECT: {
                        MapUnmapper.unmapProtectionEntriesMap(inMap, strBuf);
                        break;
                    }
                    case STREAM: {
                        MapUnmapper.unmapStreamMap(inMap, strBuf);
                        break;
                    }
                    case ATTRIBUTE: {
                        InputStream inStream = (InputStream)inMap.get("attributeInstream");
                        if (inStream == null) {
                            throw new NullPointerError("null input stream in getStreamBytes.inMap");
                        }
                        bytes = this.getStreamBytes(cmdName, inStream);
                        break;
                    }
                    case TRIGGERS: {
                        MapUnmapper.unmapTriggerEntriesMap(inMap, strBuf);
                        break;
                    }
                    case SPEC: {
                        MapUnmapper.unmapSpecMap(inMap, strBuf);
                        break;
                    }
                    case LICENSE: {
                        MapUnmapper.unmapLicenseMap(inMap, strBuf);
                        break;
                    }
                    case EXTENSION: {
                        MapUnmapper.unmapExtensionMap(inMap, strBuf);
                        break;
                    }
                }
            }
            if (bytes != null) {
                resultsMap.put("data", bytes);
            } else {
                resultsMap.put("data", strBuf);
            }
        } else {
            resultsMap.put("data", inString);
        }
        rpcConnection.clientConfirm(confirm, resultsMap);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected byte[] getStreamBytes(String cmdName, InputStream inStream) {
        if (inStream != null) {
            try {
                byte[] bytes = new byte[8192];
                int bytesRead = 0;
                int bytePos = 0;
                while ((bytesRead = inStream.read(bytes, bytePos, bytes.length - bytePos)) > 0) {
                    if ((bytePos += bytesRead) < bytes.length) continue;
                    byte[] newBytes = new byte[bytes.length * 4];
                    System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                    bytes = newBytes;
                }
                byte[] retBytes = new byte[bytePos];
                System.arraycopy(bytes, 0, retBytes, 0, bytePos);
                return retBytes;
            }
            catch (Throwable thr) {
                Log.warn("problem reading input stream for user input for " + cmdName + " operation", new Object[0]);
                Log.exception(thr);
            }
        }
        return null;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientPing(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientPing().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientPing().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientPing().");
        }
        String secsBuf = (String)resultsMap.get("token");
        String acksBuf = (String)resultsMap.get("blockCount");
        String payloadSize = (String)resultsMap.get("fileSize");
        String timer = (String)resultsMap.get("time");
        String serverMessageBuf = (String)resultsMap.get("value");
        String taggedFlag = (String)resultsMap.get("tag");
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        if (payloadSize != null) {
            try {
                int size = Integer.parseInt(payloadSize);
                if (size > 1000000) {
                    size = 1000000;
                }
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    sbuf.append('b');
                }
                respMap.put("desc", sbuf.toString());
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException(nfe);
            }
        }
        respMap.put("fileSize", payloadSize);
        respMap.put("value", serverMessageBuf);
        respMap.put("blockCount", acksBuf);
        respMap.put("token", secsBuf);
        respMap.put("tag", taggedFlag);
        if (timer != null) {
            respMap.put("time", timer);
        }
        RpcPacket respPacket = RpcPacket.constructRpcPacket("dm-Ping", respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientErrorPause(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientPing().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientPing().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientPing().");
        }
        cmdEnv.resetPartialResult();
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientHandleError(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientPing().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientPing().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientPing().");
        }
        cmdEnv.resetPartialResult();
        this.server.setSecretKey(this.server.getUserName(), null);
        this.server.setPbuf(this.server.getUserName(), null);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientActionResolve(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientPing().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientPing().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientPing().");
        }
        String actionType = (String)resultsMap.get("rActionType");
        String autoResult = (String)resultsMap.get("rAutoResult");
        if (actionType == null || autoResult == null) {
            throw new NullPointerException("Missing either rActionType or rAutoResult");
        }
        String preview = (String)resultsMap.get("preview");
        String confirm = (String)resultsMap.get("confirm");
        String decline = (String)resultsMap.get("decline");
        if (preview == null && (confirm == null || decline == null)) {
            throw new NullPointerException("Missing either confirm ordecline");
        }
        String actionMerge = (String)resultsMap.get("rActionMerge");
        String actionTheirs = (String)resultsMap.get("rActionTheirs");
        String actionYours = (String)resultsMap.get("rActionYours");
        String optAuto = (String)resultsMap.get("rOptAuto");
        String optHelp = (String)resultsMap.get("rOptHelp");
        String optMerge = (String)resultsMap.get("rOptMerge");
        String optSkip = (String)resultsMap.get("rOptSkip");
        String optTheirs = (String)resultsMap.get("rOptTheirs");
        String optYours = (String)resultsMap.get("rOptYours");
        String promptMerge = (String)resultsMap.get("rPromptMerge");
        String promptTheirs = (String)resultsMap.get("rPromptTheirs");
        String promptYours = (String)resultsMap.get("rPromptYours");
        String promptType = (String)resultsMap.get("rPromptType");
        String userError = (String)resultsMap.get("rUserError");
        String userHelp = (String)resultsMap.get("rUserHelp");
        String userPrompt = (String)resultsMap.get("rUserPrompt");
        rpcConnection.clientConfirm(confirm, resultsMap);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult clientEditData(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in clientPing().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in clientPing().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in clientPing().");
        }
        String spec = (String)resultsMap.get("data");
        String confirm = (String)resultsMap.get("confirm");
        String decline = (String)resultsMap.get("decline");
        String compare = (String)resultsMap.get("compare");
        if (spec == null) {
            throw new NullPointerException("No data value");
        }
        String newSpec = "";
        if (confirm != null) {
            if (compare != null) {
                resultsMap.put("compare", newSpec.equals(spec) ? "same" : "diff");
            }
            resultsMap.put("data", newSpec);
            rpcConnection.clientConfirm(confirm, resultsMap);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }
}

