/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.UserGroup;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.UpdateUserGroupOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IGroupDelegator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class GroupDelegator
extends BaseDelegator
implements IGroupDelegator {
    public GroupDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public IUserGroup getUserGroup(@Nonnull String name) throws ConnectionException, RequestException, AccessException {
        Map<String, Object> firstResultMap;
        Validate.notBlank((CharSequence)name, (String)"Group name shouldn't use null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GROUP, new String[]{"-o", name}, null);
        UserGroup ugImpl = null;
        if (Objects.nonNull(resultMaps) && Objects.nonNull(firstResultMap = resultMaps.get(0))) {
            ResultMapParser.handleErrorStr(firstResultMap);
            ugImpl = new UserGroup(firstResultMap);
        }
        return ugImpl;
    }

    @Override
    public String deleteUserGroup(@Nonnull IUserGroup group, @Nullable UpdateUserGroupOptions opts) throws P4JavaException {
        Validate.notNull((Object)group);
        Validate.notBlank((CharSequence)group.getName(), (String)"Group name shouldn't a null or empty.", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GROUP, Parameters.processParameters((Options)opts, null, new String[]{"-d", group.getName()}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }

    @Override
    public String createUserGroup(@Nonnull IUserGroup group, @Nullable UpdateUserGroupOptions opts) throws P4JavaException {
        return this.updateUserGroup(group, opts);
    }

    @Override
    public String updateUserGroup(@Nonnull IUserGroup group, @Nullable UpdateUserGroupOptions opts) throws P4JavaException {
        Validate.notNull((Object)group);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GROUP, Parameters.processParameters((Options)opts, null, "-i", (IServer)this.server), InputMapper.map(group));
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }

    public String createUserGroup(@Nonnull IUserGroup group) throws ConnectionException, RequestException, AccessException {
        Validate.notNull((Object)group);
        return this.updateUserGroup(group, false);
    }

    public String updateUserGroup(@Nonnull IUserGroup group, boolean updateIfOwner) throws ConnectionException, RequestException, AccessException {
        try {
            return this.updateUserGroup(group, new UpdateUserGroupOptions().setUpdateIfOwner(updateIfOwner));
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    public String deleteUserGroup(@Nonnull IUserGroup group) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteUserGroup(group, new UpdateUserGroupOptions());
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }
}

