/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server.callback;

import com.perforce.p4java.exception.InvalidUrlException;
import com.perforce.p4java.server.callback.IBrowserCallback;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class DefaultBrowserCallback
implements IBrowserCallback {
    private Desktop desktop = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) ? Desktop.getDesktop() : null;

    @Override
    public void launchBrowser(String urlString) throws Exception {
        URI uri;
        if (this.desktop == null) {
            throw new InvalidUrlException("Client browser not supported");
        }
        if (!urlString.contains("https://") && !urlString.contains("http://")) {
            throw new InvalidUrlException();
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new InvalidUrlException(e);
        }
        try {
            this.desktop.browse(uri);
        }
        catch (IOException e) {
            throw new InvalidUrlException(e);
        }
    }
}

