/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.charset.PerforceCharsetProvider;
import com.perforce.p4java.server.PerforceCharsets;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class P4Charset {
    private String charsetName;
    private Charset charset;
    private boolean clientBOM;

    public P4Charset(String charsetName) {
        this.charsetName = charsetName;
        this.setCharsetName(charsetName);
    }

    public static P4Charset getUTF8() {
        return new P4Charset("utf8");
    }

    public static P4Charset getDefault() {
        return new P4Charset(CharsetDefs.DEFAULT, false);
    }

    private P4Charset(Charset charset, boolean clientBOM) {
        this.charset = charset;
        this.clientBOM = clientBOM;
        this.charsetName = null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isClientBOM() {
        return this.clientBOM;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public static boolean isUnicodeServer(P4Charset p4Charset) {
        if (p4Charset == null) {
            return false;
        }
        return p4Charset.getCharset() != null;
    }

    private void setCharsetName(String charsetName) throws UnsupportedCharsetException {
        if (StringUtils.isNotBlank((CharSequence)charsetName) && !"none".equals(charsetName) && !"auto".equals(charsetName)) {
            if (!PerforceCharsets.isSupported(charsetName)) {
                throw new UnsupportedCharsetException(charsetName);
            }
            String javaCharsetName = PerforceCharsets.getJavaCharsetName(charsetName);
            if (StringUtils.isNotBlank((CharSequence)javaCharsetName)) {
                try {
                    this.charset = Charset.forName(javaCharsetName);
                    this.clientBOM = PerforceCharsets.hasClientBOM(charsetName);
                }
                catch (UnsupportedCharsetException uce) {
                    PerforceCharsetProvider p4CharsetProvider = new PerforceCharsetProvider();
                    this.charset = p4CharsetProvider.charsetForName(javaCharsetName);
                    this.clientBOM = false;
                    if (Objects.isNull(this.charset)) {
                        throw uce;
                    }
                }
                catch (IllegalCharsetNameException icne) {
                    throw new UnsupportedCharsetException(icne.getLocalizedMessage());
                }
                this.charsetName = charsetName;
            }
        } else {
            this.charsetName = null;
            this.charset = null;
            this.clientBOM = false;
        }
    }
}

