/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.BranchSpecSummary;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.GetBranchSpecsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IBranchesDelegator;
import java.util.List;
import java.util.Map;

public class BranchesDelegator
extends BaseDelegator
implements IBranchesDelegator {
    public BranchesDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(GetBranchSpecsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCHES, Parameters.processParameters(opts, this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, new Function<Map, IBranchSpecSummary>(){

            @Override
            public IBranchSpecSummary apply(Map map) {
                return new BranchSpecSummary(map, true);
            }
        });
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(String userName, String nameFilter, int maxReturns) throws ConnectionException, RequestException, AccessException {
        this.checkMinSupportedPerforceVersion(userName, maxReturns, nameFilter, "branch");
        try {
            GetBranchSpecsOptions getBranchSpecsOptions = new GetBranchSpecsOptions().setMaxResults(maxReturns).setNameFilter(nameFilter).setUserName(userName);
            return this.getBranchSpecs(getBranchSpecsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }
}

