/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class BranchSpecSummary
extends ServerResource
implements IBranchSpecSummary {
    protected Date accessed = null;
    protected Date updated = null;
    protected String name = null;
    protected String ownerName = null;
    protected String description = null;
    protected boolean locked = false;

    public BranchSpecSummary() {
    }

    public BranchSpecSummary(boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
    }

    public BranchSpecSummary(boolean summaryOnly, Date accessed, Date updated, String name, String ownerName, String description, boolean locked) {
        super(!summaryOnly, !summaryOnly);
        this.accessed = accessed;
        this.updated = updated;
        this.name = name;
        this.ownerName = ownerName;
        this.description = description;
        this.locked = locked;
    }

    public BranchSpecSummary(Map<String, Object> map, boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
        if (map != null) {
            if (summaryOnly) {
                this.name = (String)map.get("branch");
                this.accessed = new Date(Long.parseLong((String)map.get("Access")) * 1000L);
                this.updated = new Date(Long.parseLong((String)map.get("Update")) * 1000L);
            } else {
                try {
                    String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
                    this.name = (String)map.get("Branch");
                    if (map.containsKey("Update")) {
                        this.updated = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Update"));
                    }
                    if (map.containsKey("Access")) {
                        this.accessed = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Access"));
                    }
                }
                catch (Throwable thr) {
                    Log.warn("Unexpected exception in BranchSpecSummary constructor: " + thr.getMessage(), new Object[0]);
                    Log.exception(thr);
                }
            }
            this.description = (String)map.get("Description");
            this.ownerName = (String)map.get("Owner");
            String opts = (String)map.get("Options");
            if (opts != null && opts.equalsIgnoreCase("locked")) {
                this.locked = true;
            }
        }
    }

    @Override
    public Date getAccessed() {
        return this.accessed;
    }

    @Override
    public void setAccessed(Date accessed) {
        this.accessed = accessed;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }
}

