/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.common.function.FunctionWithException;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.CounterOptions;
import com.perforce.p4java.option.server.GetCountersOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.ICountersDelegator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class CountersDelegator
extends BaseDelegator
implements ICountersDelegator {
    private FunctionWithException<Map<String, Object>, Boolean> uncheckExceptionFunction = new FunctionWithException<Map<String, Object>, Boolean>(){

        @Override
        public Boolean apply(Map<String, Object> map) throws P4JavaException {
            return ResultMapParser.handleErrorOrInfoStr(map);
        }
    };

    public CountersDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public Map<String, String> getCounters() throws ConnectionException, RequestException, AccessException {
        try {
            return this.getCounters(new GetCountersOptions());
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public Map<String, String> getCounters(CounterOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.COUNTERS, Parameters.processParameters(opts, this.server), null);
        return this.parseCounterCommandResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(this.uncheckExceptionFunction));
    }

    @Override
    public Map<String, String> getCounters(GetCountersOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.COUNTERS, Parameters.processParameters(opts, this.server), null);
        return this.parseCounterCommandResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(this.uncheckExceptionFunction));
    }

    private Map<String, String> parseCounterCommandResultMaps(List<Map<String, Object>> resultMaps, @Nonnull Function<Map<String, Object>, Boolean> errorOrInfoStringCheckFunc) throws AccessException, RequestException {
        HashMap<String, String> counterMap = new HashMap<String, String>();
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (errorOrInfoStringCheckFunc.apply(map).booleanValue()) continue;
                counterMap.put(P4ResultMapUtils.parseString(map, "counter"), P4ResultMapUtils.parseString(map, "value"));
            }
        }
        return counterMap;
    }
}

