/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java;

import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.server.callback.ILogCallback;

public class Log {
    private static ILogCallback logCallback = null;

    public static ILogCallback getLogCallback() {
        return logCallback;
    }

    public static ILogCallback setLogCallback(ILogCallback logCallback) {
        ILogCallback oldCallback = Log.logCallback;
        Log.logCallback = logCallback;
        return oldCallback;
    }

    public static void error(String errorString, Object ... args) {
        if (ObjectUtils.nonNull(logCallback)) {
            String errorMessage = errorString;
            if (ObjectUtils.nonNull(args)) {
                errorMessage = StringHelper.format(errorString, args);
            }
            logCallback.internalError(errorMessage);
        }
    }

    public static void warn(String warnString, Object ... args) {
        if (ObjectUtils.nonNull(logCallback)) {
            String warningMessage = warnString;
            if (ObjectUtils.nonNull(args)) {
                warningMessage = StringHelper.format(warnString, args);
            }
            logCallback.internalWarn(warningMessage);
        }
    }

    public static void info(String infoString, Object ... args) {
        if (ObjectUtils.nonNull(logCallback)) {
            String infoMessage = infoString;
            if (ObjectUtils.nonNull(args)) {
                infoMessage = StringHelper.format(infoString, args);
            }
            logCallback.internalInfo(infoMessage);
        }
    }

    public static void stats(String statsString, Object ... args) {
        if (ObjectUtils.nonNull(logCallback)) {
            String statsMessage = statsString;
            if (ObjectUtils.nonNull(args)) {
                statsMessage = StringHelper.format(statsString, args);
            }
            logCallback.internalStats(statsMessage);
        }
    }

    public static void exception(Throwable thr) {
        if (ObjectUtils.nonNull(logCallback) && ObjectUtils.nonNull(thr)) {
            logCallback.internalException(thr);
        }
    }

    public static void trace(ILogCallback.LogTraceLevel traceLevel, String traceMessage) {
        if (ObjectUtils.nonNull(logCallback) && ObjectUtils.nonNull((Object)traceLevel) && ObjectUtils.nonNull(traceMessage) && Log.isTracingAtLevel(traceLevel)) {
            logCallback.internalTrace(traceLevel, traceMessage);
        }
    }

    public static boolean isTracingAtLevel(ILogCallback.LogTraceLevel traceLevel) {
        return ObjectUtils.nonNull(logCallback) && ObjectUtils.nonNull((Object)logCallback.getTraceLevel()) && traceLevel.compareTo(logCallback.getTraceLevel()) <= 0;
    }
}

