/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class ResultMapParser {
    private static final int INITIAL_STRING_BUILDER = 100;
    protected static final String CORE_AUTH_FAIL_STRING_1 = "Perforce password (P4PASSWD)";
    protected static final String CORE_AUTH_FAIL_STRING_2 = "Access for user";
    protected static final String CORE_AUTH_FAIL_STRING_3 = "Your session has expired";
    private static final String AUTH_FAIL_STRING_1 = "Single sign-on on client failed";
    private static final String AUTH_FAIL_STRING_2 = "Password invalid";
    protected static final String CORE_AUTH_FAIL_STRING_4 = "Your session was logged out";
    private static final String[] ACCESS_ERR_MSGS = new String[]{"Perforce password (P4PASSWD)", "Access for user", "Your session has expired", "Your session was logged out", "Single sign-on on client failed", "Password invalid"};

    public static String parseCommandResultMapIfIsInfoMessageAsString(@Nonnull List<Map<String, Object>> resultMaps) throws AccessException, RequestException {
        StringBuilder retVal = new StringBuilder(100);
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                ResultMapParser.handleErrorStr(map);
                if (!ResultMapParser.isInfoMessage(map)) continue;
                if (retVal.length() != 0) {
                    retVal.append("\n");
                }
                retVal.append(ResultMapParser.getInfoStr(map));
            }
        }
        return retVal.toString();
    }

    public static boolean isInfoMessage(Map<String, Object> map) {
        return ObjectUtils.nonNull(map) && RpcMessage.getSeverity(P4ResultMapUtils.parseCode0ErrorString(map)) == 1;
    }

    public static boolean handleErrorStr(Map<String, Object> map) throws RequestException, AccessException {
        String errStr = ResultMapParser.getErrorStr(map);
        if (StringUtils.isNotBlank((CharSequence)errStr)) {
            if (ResultMapParser.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            throw new RequestException(errStr, P4ResultMapUtils.parseCode0ErrorString(map));
        }
        return false;
    }

    public static String getErrorStr(Map<String, Object> map) {
        return ResultMapParser.getString(map, 3);
    }

    public static boolean isAuthFail(String errStr) {
        if (StringUtils.isNotBlank((CharSequence)errStr)) {
            for (String str : ACCESS_ERR_MSGS) {
                if (!StringUtils.contains((CharSequence)errStr, (CharSequence)str)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getInfoStr(Map<String, Object> map) {
        String code0;
        int severity;
        if (ObjectUtils.nonNull(map) && (severity = RpcMessage.getSeverity(code0 = P4ResultMapUtils.parseCode0ErrorString(map))) == 1) {
            String fmtStr = P4ResultMapUtils.parseString(map, "fmt0");
            if (StringUtils.isBlank((CharSequence)fmtStr)) {
                return "";
            }
            if (!StringUtils.contains((CharSequence)fmtStr, (CharSequence)"%")) {
                return fmtStr;
            }
            return RpcMessage.interpolateArgs(fmtStr, map);
        }
        return null;
    }

    private static String getString(Map<String, Object> map, int minimumCode) {
        if (ObjectUtils.nonNull(map)) {
            int index = 0;
            String code = (String)map.get("code" + index);
            if (StringUtils.isBlank((CharSequence)code)) {
                return null;
            }
            boolean foundCode = false;
            StringBuilder codeString = new StringBuilder(100);
            while (StringUtils.isNotBlank((CharSequence)code)) {
                int severity = RpcMessage.getSeverity(code);
                if (severity >= minimumCode) {
                    foundCode = true;
                    String fmtStr = P4ResultMapUtils.parseString(map, "fmt" + index);
                    if (StringUtils.isNotBlank((CharSequence)fmtStr)) {
                        if (StringUtils.indexOf((CharSequence)fmtStr, (int)37) != -1) {
                            fmtStr = RpcMessage.interpolateArgs(fmtStr, map);
                        }
                        codeString.insert(0, fmtStr);
                        codeString.insert(fmtStr.length(), '\n');
                    }
                }
                code = P4ResultMapUtils.parseString(map, "code" + ++index);
            }
            if (foundCode) {
                return codeString.toString();
            }
        }
        return null;
    }

    public static String getErrorOrInfoStr(Map<String, Object> map) {
        return ResultMapParser.getString(map, 1);
    }

    public static void throwRequestExceptionIfErrorMessageFound(Map<String, Object> map) throws RequestException {
        String errStr = ResultMapParser.getErrorStr(map);
        if (StringUtils.isNotBlank((CharSequence)errStr)) {
            throw new RequestException(errStr, P4ResultMapUtils.parseCode0ErrorString(map));
        }
    }

    public static boolean handleErrorOrInfoStr(Map<String, Object> map) throws RequestException, AccessException {
        String errStr = ResultMapParser.getErrorOrInfoStr(map);
        if (StringUtils.isNotBlank((CharSequence)errStr)) {
            if (ResultMapParser.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            throw new RequestException(errStr, P4ResultMapUtils.parseCode0ErrorString(map));
        }
        return false;
    }

    public static String parseCommandResultMapAsString(@Nonnull List<Map<String, Object>> resultMaps) throws AccessException, RequestException {
        StringBuilder retVal = new StringBuilder();
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                ResultMapParser.handleErrorStr(map);
                if (retVal.length() != 0) {
                    retVal.append("\n");
                }
                retVal.append(ResultMapParser.getInfoStr(map));
            }
        } else {
            Log.warn("Null map array is returned when execute Helix command", new Object[0]);
        }
        return retVal.toString();
    }

    public static List<IFileSpec> parseCommandResultMapAsFileSpecs(int id, IServer server, List<Map<String, Object>> resultMaps) {
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (ObjectUtils.nonNull(resultMaps) && !resultMaps.isEmpty() && ObjectUtils.nonNull(resultMaps.get(0))) {
            Map<String, Object> map = resultMaps.get(0);
            int i = 0;
            while (ObjectUtils.nonNull(map.get("rev" + i))) {
                FileSpec fSpec = new FileSpec(map, server, i);
                fSpec.setChangelistId(id);
                fileList.add(fSpec);
                ++i;
            }
        }
        return fileList;
    }

    public static List<IFileSpec> parseGraphCommandResultMapAsFileSpecs(IServer server, List<Map<String, Object>> resultMaps) {
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (ObjectUtils.nonNull(resultMaps) && !resultMaps.isEmpty() && ObjectUtils.nonNull(resultMaps.get(0))) {
            Map<String, Object> map = resultMaps.get(0);
            int i = 0;
            while (ObjectUtils.nonNull(map.get("depotFile" + i))) {
                FileSpec fSpec = new FileSpec(map, server, i);
                fSpec.setCommitSha(P4ResultMapUtils.parseString(map, "commit"));
                fSpec.setTreeSha(P4ResultMapUtils.parseString(map, "tree"));
                fileList.add(fSpec);
                ++i;
            }
        }
        return fileList;
    }

    public static String handleFileErrorStr(Map<String, Object> map) throws ConnectionException, AccessException {
        String errStr = ResultMapParser.getErrorOrInfoStr(map);
        if (StringUtils.isNotBlank((CharSequence)errStr)) {
            if (ResultMapParser.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            return errStr.trim();
        }
        return null;
    }

    public static boolean isExistClientOrLabelOrUser(Map<String, Object> map) {
        Validate.notNull(map);
        return map.containsKey("Update") || map.containsKey("Access");
    }

    public static boolean isNonExistClientOrLabelOrUser(Map<String, Object> map) {
        Validate.notNull(map);
        return !ResultMapParser.isExistClientOrLabelOrUser(map);
    }
}

