/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.ILookahead;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcLineEndFilterInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSendFile {
    public static final String TRACE_PREFIX = "ClientSendFile";
    public static final int DEFAULT_SENDBUF_SIZE = 1024;
    private Properties props = null;
    private ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();
    private String filePath = null;
    private long fileSize = 0L;
    private long currentSize = 0L;

    protected ClientSendFile(Properties props) {
        this.props = props;
    }

    private long sendRaw(InputStream stream, RpcConnection connection, String handle, String write, MD5Digester digester, CommandEnv cmdEnv) throws ConnectionException, IOException {
        long fileLength = 0L;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        byte[] bytes = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = stream.read(bytes)) > 0) {
            byte[] readBytes = new byte[bytesRead];
            System.arraycopy(bytes, 0, readBytes, 0, bytesRead);
            fileLength += (long)bytesRead;
            sendMap.clear();
            sendMap.put("data", readBytes);
            sendMap.put("handle", handle);
            RpcPacket sendPacket = RpcPacket.constructRpcPacket(write, sendMap, null);
            connection.putRpcPacket(sendPacket);
            digester.update(readBytes);
            if (!cmdEnv.getProtocolSpecs().isEnableProgress() || this.fileSize <= 0L || bytesRead <= 0) continue;
            this.currentSize += (long)bytesRead;
            HashMap<String, Object> dataSizeMap = new HashMap<String, Object>();
            dataSizeMap.put("path", this.filePath);
            dataSizeMap.put("fileSize", this.fileSize);
            dataSizeMap.put("currentSize", this.currentSize);
            cmdEnv.handleResult(dataSizeMap);
        }
        return fileLength;
    }

    private ILookahead createLookahead(final InputStream stream, Charset charset) {
        CharsetConverter newlineConverter = new CharsetConverter(CharsetDefs.DEFAULT, charset, true);
        ByteBuffer newlineBuffer = newlineConverter.convert(CharBuffer.wrap(new char[]{'\n'}));
        final int lookaheadLength = newlineBuffer.limit();
        ILookahead lookahead = new ILookahead(){

            public byte[] bytesToAdd(char lastDecodedChar) {
                byte[] add = null;
                if (lastDecodedChar == '\r') {
                    add = new byte[lookaheadLength];
                    try {
                        int read = stream.read(add);
                        if (read != add.length) {
                            byte[] realAdd = new byte[read];
                            System.arraycopy(add, 0, realAdd, 0, read);
                            add = realAdd;
                        }
                    }
                    catch (IOException e) {
                        add = null;
                    }
                }
                return add;
            }
        };
        return lookahead;
    }

    private long sendConverted(Charset charset, InputStream stream, RpcConnection connection, String handle, String write, MD5Digester digester, CommandEnv cmdEnv) throws ConnectionException, IOException {
        long fileLength = 0L;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        byte[] bytes = new byte[1024];
        int bytesRead = 0;
        ILookahead lookahead = null;
        if (ClientLineEnding.CONVERT_TEXT) {
            lookahead = this.createLookahead(stream, charset);
        }
        CharsetConverter converter = new CharsetConverter(charset, CharsetDefs.UTF8);
        while ((bytesRead = stream.read(bytes)) > 0) {
            ByteBuffer inBuffer = ByteBuffer.wrap(bytes, 0, bytesRead);
            ByteBuffer converted = converter.convert(inBuffer, lookahead);
            byte[] sendBytes = converted.array();
            bytesRead = converted.limit();
            int start = converted.position();
            if (bytesRead <= 0) continue;
            if (ClientLineEnding.CONVERT_TEXT) {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(sendBytes, 0, bytesRead);
                RpcLineEndFilterInputStream lineEndStream = new RpcLineEndFilterInputStream(byteStream, null);
                bytesRead = lineEndStream.read(sendBytes, 0, bytesRead);
                lineEndStream.close();
            }
            byte[] dataBytes = new byte[bytesRead];
            System.arraycopy(sendBytes, start, dataBytes, 0, bytesRead);
            fileLength += (long)bytesRead;
            sendMap.clear();
            sendMap.put("data", dataBytes);
            sendMap.put("handle", handle);
            RpcPacket sendPacket = RpcPacket.constructRpcPacket(write, sendMap, null);
            connection.putRpcPacket(sendPacket);
            digester.update(dataBytes);
            if (!cmdEnv.getProtocolSpecs().isEnableProgress() || this.fileSize <= 0L || bytesRead <= 0) continue;
            this.currentSize += (long)bytesRead;
            HashMap<String, Object> dataSizeMap = new HashMap<String, Object>();
            dataSizeMap.put("path", this.filePath);
            dataSizeMap.put("fileSize", this.fileSize);
            dataSizeMap.put("currentSize", this.currentSize);
            cmdEnv.handleResult(dataSizeMap);
        }
        return fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult sendFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        block31: {
            block29: {
                block32: {
                    cmdEnv.newHandler();
                    clientPath = (String)resultsMap.get("path");
                    type = (String)resultsMap.get("type");
                    perms = (String)resultsMap.get("perms");
                    handle = (String)resultsMap.get("handle");
                    open = (String)resultsMap.get("open");
                    write = (String)resultsMap.get("write");
                    confirm = (String)resultsMap.get("confirm");
                    decline = (String)resultsMap.get("decline");
                    serverDigest = (String)resultsMap.get("serverDigest");
                    revertUnchanged = (String)resultsMap.get("revertUnchanged");
                    reopen = (String)resultsMap.get("reopen");
                    fileType = RpcPerforceFileType.decodeFromServerString(type);
                    handler = cmdEnv.getHandler(handle);
                    if (handler == null) {
                        v0 = cmdEnv;
                        v0.getClass();
                        handler = v0.new CommandEnv.RpcHandler(handle, false, null);
                        cmdEnv.addHandler(handler);
                    }
                    file = null;
                    inStream = null;
                    digester = null;
                    fileLength = 0L;
                    modTime = 0L;
                    file = new RpcPerforceFile(clientPath, fileType);
                    modTime = file.lastModified();
                    if (fileType == RpcPerforceFileType.FST_SYMLINK && (modTime = SymbolicLinkHelper.getLastModifiedTime(clientPath)) == 0L) {
                        modTime = System.currentTimeMillis();
                    }
                    this.filePath = clientPath != null ? clientPath : null;
                    this.fileSize = file.length();
                    this.currentSize = 0L;
                    if (handler.isError()) ** GOTO lbl91
                    respMap = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                        if (entry.getKey() == null || entry.getKey().equalsIgnoreCase("func")) continue;
                        respMap.put(entry.getKey(), entry.getValue());
                    }
                    respPacket = RpcPacket.constructRpcPacket(open, respMap, null);
                    rpcConnection.putRpcPacket(respPacket);
                    if (file.exists() || fileType == RpcPerforceFileType.FST_SYMLINK) break block32;
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.OS_FILE_READ_ERROR, 1, 34, new String[]{"open for read", clientPath + ": No such file or directory"}).toMap());
                    ** GOTO lbl91
                }
                symbolicLinkTarget = null;
                if (fileType != RpcPerforceFileType.FST_SYMLINK) break block29;
                if (SymbolicLinkHelper.isSymbolicLinkCapable() && (symbolicLinkTarget = SymbolicLinkHelper.readSymbolicLink(clientPath)) != null) {
                    symbolicLinkTarget = symbolicLinkTarget + "\n";
                }
                if (symbolicLinkTarget != null) break block29;
                handler.setError(true);
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_SEND_ERROR, 3, 34, new String[]{"symlink", clientPath}).toMap());
                var27_26 = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                var29_28 = null;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException exc) {
                    Log.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc.getLocalizedMessage());
                }
                return var27_26;
            }
            digester = new MD5Digester();
            charset = null;
            if (RpcPerforceFileType.FST_UTF16 == fileType) {
                charset = CharsetDefs.UTF16;
            } else if (RpcPerforceFileType.FST_UNICODE == fileType) {
                charset = rpcConnection.getClientCharset();
            }
            if (!rpcConnection.isUnicodeServer() && charset != CharsetDefs.UTF16 || charset == null || charset.equals(CharsetDefs.UTF8)) {
                inStream = symbolicLinkTarget != null ? new ByteArrayInputStream(symbolicLinkTarget.getBytes()) : new RpcInputStream(file);
                fileLength = this.sendRaw(inStream, rpcConnection, handle, write, digester, cmdEnv);
            } else {
                inStream = symbolicLinkTarget != null ? new ByteArrayInputStream(symbolicLinkTarget.getBytes()) : new FileInputStream(file);
                fileLength = this.sendConverted(charset, inStream, rpcConnection, handle, write, digester, cmdEnv);
            }
            if (!handler.isError() && perms != null && reopen == null) {
                if (perms.equalsIgnoreCase("rw")) {
                    this.fileCommands.setWritable(clientPath, true);
                } else {
                    this.fileCommands.setWritable(clientPath, false);
                }
            }
lbl91:
            // 6 sources

            finalise = handler.isError() != false ? decline : confirm;
            finaliseMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                if (entry.getKey() == null || entry.getKey().equalsIgnoreCase("func")) continue;
                finaliseMap.put(entry.getKey(), entry.getValue());
            }
            if (digester != null) {
                finaliseMap.put("digest", digester.digestAs32ByteHex());
                finaliseMap.put("fileSize", "" + fileLength);
                if (modTime != 0L) {
                    finaliseMap.put("time", "" + modTime / 1000L);
                }
            }
            finalisePacket = RpcPacket.constructRpcPacket(finalise, finaliseMap, null);
            rpcConnection.putRpcPacket(finalisePacket);
            handler.setError(false);
            this.filePath = null;
            this.fileSize = 0L;
            this.currentSize = 0L;
            var29_29 = null;
            try {
                if (inStream != null) {
                    inStream.close();
                }
                break block31;
            }
            catch (IOException exc) {
                Log.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc.getLocalizedMessage());
            }
            break block31;
            {
                catch (Exception exc) {
                    Log.exception(exc);
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_SEND_ERROR, 3, 34, new String[]{clientPath, exc.getLocalizedMessage()}).toMap());
                    var29_30 = null;
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                        break block31;
                    }
                    catch (IOException exc) {
                        Log.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable var28_36) {
                var29_31 = null;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException exc) {
                    Log.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc.getLocalizedMessage());
                }
                throw var28_36;
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }
}

