/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.ConnectionNotConnectedException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.core.TempFileInputStream;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.ExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcCmdSpec;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.ProtocolCommand;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketPool;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcStreamConnection;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IServerAddress;
import com.perforce.p4java.server.ServerStatus;
import com.perforce.p4java.server.callback.IFilterCallback;
import com.perforce.p4java.server.callback.IStreamingCallback;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneShotServerImpl
extends RpcServer {
    public static final String SCREEN_NAME = "Native RPC";
    public static final String IMPL_COMMENTS = "Java-native RPC standalone P4Java implementation. Requires JDK 6 or later and full Java NIO support.";
    public static final String PROTOCOL_NAME = IServerAddress.Protocol.P4JRPC.toString();
    public static final String SSL_PROTOCOL_NAME = IServerAddress.Protocol.P4JRPCSSL.toString();
    public static final boolean DEFAULT_STATUS = false;
    public static final int MINIMUM_SUPPORTED_SERVER_LEVEL = 20052;
    public static final String TRACE_PREFIX = "OneShotServerImpl";
    protected RpcSocketPool socketPool = null;

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts, boolean secure, String rsh) throws ConfigException, ConnectionException {
        super.init(host, port, props, opts, secure);
        this.minumumSupportedServerVersion = 20052;
        this.rsh = rsh;
        int poolSize = RpcPropertyDefs.getPropertyAsInt(this.props, "socketPoolSize", 0);
        if (poolSize > 0) {
            RpcSocketPool.ShutdownHandler handler = new RpcSocketPool.ShutdownHandler(){

                public void shutdown(Socket socket) {
                    try {
                        RpcPacketDispatcher dispatcher = new RpcPacketDispatcher(OneShotServerImpl.this.props, OneShotServerImpl.this);
                        RpcStreamConnection rpcConnection = new RpcStreamConnection(OneShotServerImpl.this.serverHost, OneShotServerImpl.this.serverPort, OneShotServerImpl.this.props, OneShotServerImpl.this.serverStats, OneShotServerImpl.this.charset, socket, null, OneShotServerImpl.this.secure, OneShotServerImpl.this.rsh);
                        dispatcher.shutdown(rpcConnection);
                    }
                    catch (ConnectionException e) {
                        Log.exception(e);
                    }
                }
            };
            this.socketPool = new RpcSocketPool(poolSize, this.serverHost, this.serverPort, this.props, handler, this.secure);
        }
        return this.status;
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts) throws ConfigException, ConnectionException {
        return this.init(host, port, props, opts, false);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        return this.init(host, port, props, null);
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.serverStats.clear();
        super.connect();
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        if (this.socketPool != null) {
            this.socketPool.disconnect();
        }
        super.disconnect();
    }

    @Override
    public Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException, RequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, null, false, null, 0);
    }

    @Override
    public List<Map<String, Object>> execMapCmdList(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JavaException {
        return this.execMapCmdList(cmdName, cmdArgs, inMap, null, false, null, 0, null);
    }

    @Override
    public List<Map<String, Object>> execMapCmdList(String cmdName, String[] cmdArgs, Map<String, Object> inMap, IFilterCallback filterCallback) throws P4JavaException {
        return this.execMapCmdList(cmdName, cmdArgs, inMap, null, false, null, 0, filterCallback);
    }

    @Override
    public Map<String, Object>[] execQuietMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, RequestException, AccessException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, null, true, null, 0);
    }

    @Override
    public List<Map<String, Object>> execQuietMapCmdList(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JavaException {
        return this.execMapCmdList(cmdName, cmdArgs, inMap, null, true, null, 0, null);
    }

    @Override
    public Map<String, Object>[] execInputStringMapCmd(String cmdName, String[] cmdArgs, String inString) throws P4JavaException {
        return this.execMapCmd(cmdName, cmdArgs, null, inString, true, null, 0);
    }

    @Override
    public List<Map<String, Object>> execInputStringMapCmdList(String cmdName, String[] cmdArgs, String inString) throws P4JavaException {
        return this.execMapCmdList(cmdName, cmdArgs, null, inString, true, null, 0, null);
    }

    @Override
    public List<Map<String, Object>> execInputStringMapCmdList(String cmdName, String[] cmdArgs, String inString, IFilterCallback filterCallback) throws P4JavaException {
        return this.execMapCmdList(cmdName, cmdArgs, null, inString, true, null, 0, filterCallback);
    }

    @Override
    @Deprecated
    public void execInputStringStreamingMapComd(String cmdName, String[] cmdArgs, String inString, IStreamingCallback callback, int key) throws P4JavaException {
        this.execMapCmd(cmdName, cmdArgs, null, inString, false, callback, key);
    }

    @Override
    public void execInputStringStreamingMapCmd(String cmdName, String[] cmdArgs, String inString, IStreamingCallback callback, int key) throws P4JavaException {
        this.execMapCmd(cmdName, cmdArgs, null, inString, false, callback, key);
    }

    protected Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, String inString, boolean ignoreCallbacks, IStreamingCallback callback, int callbackKey) throws ConnectionException, AccessException, RequestException {
        List<Map<String, Object>> results = this.execMapCmdList(cmdName, cmdArgs, inMap, inString, ignoreCallbacks, callback, callbackKey, null);
        if (results != null) {
            return results.toArray(new HashMap[results.size()]);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Map<String, Object>> execMapCmdList(String cmdName, String[] cmdArgs, Map<String, Object> inMap, String inString, boolean ignoreCallbacks, IStreamingCallback callback, int callbackKey, IFilterCallback filterCallback) throws ConnectionException, AccessException, RequestException {
        List<Map<String, Object>> list;
        block19: {
            RpcPacketDispatcher dispatcher = null;
            RpcConnection rpcConnection = null;
            if (cmdName == null) {
                throw new NullPointerError("Null command name passed to execMapCmd");
            }
            if (!this.connected) {
                throw new ConnectionNotConnectedException("Not currently connected to a Perforce server");
            }
            try {
                RpcOutputStream outStream;
                int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                long startTime = System.currentTimeMillis();
                dispatcher = new RpcPacketDispatcher(this.props, this);
                rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, null, this.socketPool, this.secure, this.rsh);
                ProtocolCommand protocolSpecs = new ProtocolCommand();
                if (inMap != null && ClientLineEnding.CONVERT_TEXT) {
                    ClientLineEnding.convertMap(inMap);
                }
                ExternalEnv env = this.setupCmd(dispatcher, rpcConnection, protocolSpecs, cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, inMap, ignoreCallbacks, cmdCallBackKey, false);
                CommandEnv cmdEnv = new CommandEnv(new RpcCmdSpec(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, this.getAuthTicket(), inMap, inString, env), rpcConnection, protocolSpecs, this.serverProtocolMap, this.progressCallback, cmdCallBackKey, this.writeInPlace(cmdName), this.isNonCheckedSyncs());
                cmdEnv.setDontWriteTicket(this.isDontWriteTicket(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs));
                cmdEnv.setFieldRule(this.getRpcPacketFieldRule(inMap, CmdSpec.getValidP4JCmdSpec(cmdName)));
                cmdEnv.setStreamingCallback(callback);
                cmdEnv.setStreamingCallbackKey(callbackKey);
                cmdEnv.setFilterCallback(filterCallback);
                if (callback != null) {
                    try {
                        callback.startResults(callbackKey);
                    }
                    catch (P4JavaException exc) {
                        Log.error("streaming callback startResults method threw exception: " + exc.getLocalizedMessage());
                        Log.exception(exc);
                    }
                }
                List<Map<String, Object>> retMapList = dispatcher.dispatch(cmdEnv);
                long endTime = System.currentTimeMillis();
                if (callback != null) {
                    try {
                        callback.endResults(callbackKey);
                    }
                    catch (P4JavaException exc) {
                        Log.error("streaming callback endResults method threw exception: " + exc.getLocalizedMessage());
                        Log.exception(exc);
                    }
                }
                if (this.caseSensitive && cmdEnv.getServerProtocolSpecsMap().containsKey("nocase")) {
                    this.caseSensitive = false;
                }
                if (!ignoreCallbacks && this.commandCallback != null) {
                    this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMapList);
                }
                if ((outStream = (RpcOutputStream)cmdEnv.getStateMap().get("")) != null) {
                    outStream.close();
                }
                list = retMapList;
                if (rpcConnection == null) break block19;
            }
            catch (BufferOverflowException exc) {
                try {
                    Log.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                    throw new P4JavaError("RPC Buffer overflow: " + exc.getLocalizedMessage());
                    catch (ConnectionNotConnectedException cnce) {
                        this.connected = false;
                        this.status = ServerStatus.ERROR;
                        throw cnce;
                    }
                    catch (IOException ioexc) {
                        Log.error("RPC I/O error: " + ioexc.getLocalizedMessage());
                        Log.exception(ioexc);
                        throw new RequestException("I/O error encountered in stream command: " + ioexc.getLocalizedMessage(), ioexc);
                    }
                }
                catch (Throwable throwable) {
                    if (rpcConnection != null) {
                        rpcConnection.disconnect(dispatcher);
                    }
                    throw throwable;
                }
            }
            rpcConnection.disconnect(dispatcher);
        }
        return list;
    }

    @Override
    public void execStreamingMapCommand(String cmdName, String[] cmdArgs, Map<String, Object> inMap, IStreamingCallback callback, int key) throws P4JavaException {
        if (callback == null) {
            throw new NullPointerError("null streaming callback passed to execStreamingMapCommand method");
        }
        this.execMapCmdList(cmdName, cmdArgs, inMap, null, false, callback, key, null);
    }

    @Override
    public InputStream execQuietStreamCmd(String cmdName, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        return this.execStreamCmd(cmdName, cmdArgs, null, null, true);
    }

    @Override
    public InputStream execStreamCmd(String cmdName, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        return this.execStreamCmd(cmdName, cmdArgs, null, null, false);
    }

    @Override
    public InputStream execStreamCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws P4JavaException {
        return this.execStreamCmd(cmdName, cmdArgs, inMap, null, false);
    }

    @Override
    public InputStream execInputStringStreamCmd(String cmdName, String[] cmdArgs, String inString) throws P4JavaException {
        return this.execStreamCmd(cmdName, cmdArgs, null, inString, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream execStreamCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, String inString, boolean ignoreCallbacks) throws ConnectionException, RequestException, AccessException {
        InputStream inputStream;
        block17: {
            RpcConnection rpcConnection;
            RpcPacketDispatcher dispatcher;
            block15: {
                TempFileInputStream tempFileInputStream;
                block16: {
                    TempFileInputStream inStream;
                    RpcOutputStream outStream;
                    dispatcher = null;
                    rpcConnection = null;
                    if (cmdName == null) {
                        throw new NullPointerError("Null command name passed to execStreamCmd");
                    }
                    if (!this.connected) {
                        throw new ConnectionNotConnectedException("Not currently connected to a Perforce server");
                    }
                    int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                    long startTime = System.currentTimeMillis();
                    dispatcher = new RpcPacketDispatcher(this.props, this);
                    rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, null, this.socketPool, this.secure, this.rsh);
                    ProtocolCommand protocolSpecs = new ProtocolCommand();
                    if (inMap != null && ClientLineEnding.CONVERT_TEXT) {
                        ClientLineEnding.convertMap(inMap);
                    }
                    ExternalEnv env = this.setupCmd(dispatcher, rpcConnection, protocolSpecs, cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, inMap, ignoreCallbacks, cmdCallBackKey, true);
                    CommandEnv cmdEnv = new CommandEnv(new RpcCmdSpec(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, this.getAuthTicket(), inMap, inString, env), rpcConnection, protocolSpecs, this.serverProtocolMap, this.progressCallback, cmdCallBackKey, this.writeInPlace(cmdName), this.isNonCheckedSyncs());
                    cmdEnv.setDontWriteTicket(this.isDontWriteTicket(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs));
                    cmdEnv.setFieldRule(this.getRpcPacketFieldRule(inMap, CmdSpec.getValidP4JCmdSpec(cmdName)));
                    cmdEnv.setStreamCmd(true);
                    List<Map<String, Object>> retMapList = dispatcher.dispatch(cmdEnv);
                    long endTime = System.currentTimeMillis();
                    if (!ignoreCallbacks && this.commandCallback != null) {
                        this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMapList);
                    }
                    if (retMapList != null && retMapList.size() != 0) {
                        for (Map<String, Object> map : retMapList) {
                            String errStr;
                            if (map == null || (errStr = this.getErrorStr(map)) == null) continue;
                            if (this.isAuthFail(errStr)) {
                                throw new AccessException(errStr);
                            }
                            throw new RequestException(errStr, (String)map.get("code0"));
                        }
                    }
                    if ((outStream = (RpcOutputStream)cmdEnv.getStateMap().get("")) == null) break block15;
                    outStream.close();
                    tempFileInputStream = inStream = new TempFileInputStream(outStream.getFile());
                    if (rpcConnection == null) break block16;
                    rpcConnection.disconnect(dispatcher);
                }
                return tempFileInputStream;
            }
            try {
                inputStream = null;
                if (rpcConnection == null) break block17;
            }
            catch (BufferOverflowException exc) {
                try {
                    Log.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                    throw new P4JavaError("RPC Buffer overflow: " + exc.getLocalizedMessage());
                    catch (ConnectionNotConnectedException cnce) {
                        this.connected = false;
                        this.status = ServerStatus.ERROR;
                        throw cnce;
                    }
                    catch (IOException ioexc) {
                        Log.error("RPC I/O error: " + ioexc.getLocalizedMessage());
                        Log.exception(ioexc);
                        throw new RequestException("I/O error encountered in stream command: " + ioexc.getLocalizedMessage(), ioexc);
                    }
                }
                catch (Throwable throwable) {
                    if (rpcConnection != null) {
                        rpcConnection.disconnect(dispatcher);
                    }
                    throw throwable;
                }
            }
            rpcConnection.disconnect(dispatcher);
        }
        return inputStream;
    }

    protected ExternalEnv setupCmd(RpcPacketDispatcher dispatcher, RpcConnection rpcConnection, ProtocolCommand protocolSpecs, String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks, int cmdCallBackKey, boolean isStream) throws ConnectionException, AccessException, RequestException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null RPC connection in execMapCmd call");
        }
        if (dispatcher == null) {
            throw new NullPointerError("Null RPC dispatcher in execMapCmd call");
        }
        if (protocolSpecs == null) {
            throw new NullPointerError("Null RPC protocol specs in execMapCmd call");
        }
        if (!this.isRelaxCmdNameValidationChecks() && !CmdSpec.isValidP4JCmdSpec(cmdName)) {
            throw new RequestException("command name '" + cmdName + "' unimplemented or unrecognized by p4java");
        }
        boolean useTags = this.useTags(cmdName, cmdArgs, inMap, isStream);
        this.checkFingerprint(rpcConnection);
        ExternalEnv env = new ExternalEnv(this.getUsageOptions().getProgramName(), this.getUsageOptions().getProgramVersion(), this.getClientNameForEnv(), this.getUsageOptions().getWorkingDirectory(), this.getHostForEnv(), this.getServerHostPort(), this.getUsageOptions().getTextLanguage(), this.getOsTypeForEnv(), this.getUserForEnv(), this.charsetName != null, this.charset);
        if (!ignoreCallbacks && this.commandCallback != null) {
            StringBuilder cmd = new StringBuilder(cmdName);
            for (String argStr : cmdArgs) {
                if (argStr == null) continue;
                cmd.append(" ");
                cmd.append(argStr);
            }
            this.commandCallback.issuingServerCommand(cmdCallBackKey, cmd.toString());
        }
        RpcPacket protPacket = null;
        protocolSpecs.setClientApiLevel(this.clientApiLevel);
        protocolSpecs.setClientCmpFile(false);
        protocolSpecs.setServerApiLevel(this.serverApiLevel);
        protocolSpecs.setApplicationName(this.applicationName);
        protocolSpecs.setSendBufSize(rpcConnection.getSystemSendBufferSize());
        protocolSpecs.setRecvBufSize(rpcConnection.getSystemRecvBufferSize());
        protocolSpecs.setUseTags(useTags);
        protocolSpecs.setEnableStreams(true);
        protocolSpecs.setEnableTracking(this.enableTracking);
        protocolSpecs.setEnableProgress(this.enableProgress);
        protocolSpecs.setQuietMode(this.quietMode);
        protocolSpecs.setHost(env.getHost());
        protocolSpecs.setPort(env.getPort());
        protPacket = RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_PROTOCOL, protocolSpecs.asMap(), null);
        RpcFunctionSpec name = RpcFunctionSpec.decodeFromEndUserCmd(cmdName, this.isRelaxCmdNameValidationChecks());
        RpcPacket cmdPacket = RpcPacket.constructRpcPacket(name, cmdName, cmdArgs, env);
        if (useTags) {
            cmdPacket.setMapArgs(this.cmdMapArgs);
        }
        if (this.enableProgress) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            if (cmdPacket.getMapArgs() != null) {
                valMap.putAll(cmdPacket.getMapArgs());
            }
            valMap.put("progress", "1");
            cmdPacket.setMapArgs(valMap);
        }
        if (protPacket == null) {
            rpcConnection.putRpcPacket(cmdPacket);
        } else {
            rpcConnection.putRpcPackets(new RpcPacket[]{protPacket, cmdPacket});
        }
        return env;
    }
}

