/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.Log;
import com.perforce.p4java.env.PerforceEnvironment;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.exception.TrustException;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientTrust;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.PerformanceMonitor;
import com.perforce.p4java.impl.mapbased.rpc.helper.RpcUserAuthCounter;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.helper.RpcPacketFieldRule;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcStreamConnection;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.option.server.TrustOptions;
import com.perforce.p4java.server.AuthTicketsHelper;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.Fingerprint;
import com.perforce.p4java.server.FingerprintsHelper;
import com.perforce.p4java.server.IServerImplMetadata;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.ServerStatus;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RpcServer
extends Server {
    public static final IServerImplMetadata.ImplType IMPL_TYPE = IServerImplMetadata.ImplType.NATIVE_RPC;
    public static final String DEFAULT_PROG_NAME = "p4jrpc";
    public static final String DEFAULT_PROG_VERSION = "Beta 1.0";
    public static final int DEFAULT_CLIENT_API_LEVEL = 76;
    public static final int DEFAULT_SERVER_API_LEVEL = 99999;
    public static final boolean RPC_TAGS_USED = true;
    public static final boolean RPC_ENABLE_STREAMS = true;
    public static final String RPC_ENV_CWD_KEY = "user.dir";
    public static final String RPC_ENV_OS_NAME_KEY = "os.name";
    public static final String RPC_ENV_WINDOWS_PREFIX = "windows";
    public static final String RPC_ENV_WINDOWS_SPEC = "NT";
    public static final String RPC_ENV_UNIX_SPEC = "UNIX";
    public static final String RPC_ENV_NOCLIENT_SPEC = "unknownclient";
    public static final String RPC_ENV_NOHOST_SPEC = "nohost";
    public static final String RPC_ENV_NOUSER_SPEC = "nouser";
    public static final String TRACE_PREFIX = "RpcServer";
    public static final String RPC_TMP_OUTFILE_STREAM_KEY = "";
    public static final String RPC_TMP_CONVERTER_KEY = "RPC_TMP_CONVERTER_KEY";
    protected String localHostName = null;
    protected int clientApiLevel = 76;
    protected int serverApiLevel = 99999;
    protected String applicationName = null;
    private static final String AUTH_FAIL_STRING_1 = "Single sign-on on client failed";
    private static final String AUTH_FAIL_STRING_2 = "Password invalid";
    private static final String[] accessErrMsgs = new String[]{"Perforce password (P4PASSWD)", "Access for user", "Your session has expired", "Your session was logged out", "Single sign-on on client failed", "Password invalid"};
    private static final String PASSWORD_NOT_SET_STRING = "no password set for this user";
    protected long connectionStart = 0L;
    protected Map<String, Object> serverProtocolMap = new HashMap<String, Object>();
    private PerformanceMonitor perfMonitor = new PerformanceMonitor();
    protected ServerStats serverStats = null;
    protected String serverId = null;
    protected Map<String, String> secretKeys = new HashMap<String, String>();
    protected ClientTrust clientTrust = null;
    protected String ticketsFilePath = null;
    protected String trustFilePath = null;
    protected RpcUserAuthCounter authCounter = new RpcUserAuthCounter();
    protected Map<String, Object> cmdMapArgs = null;
    protected boolean relaxCmdNameValidationChecks = false;

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        return this.init(host, port, props, null);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts) throws ConfigException, ConnectionException {
        return this.init(host, port, props, opts, false);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts, boolean secure) throws ConfigException, ConnectionException {
        super.init(host, port, props, opts, secure);
        try {
            this.cmdMapArgs = new HashMap<String, Object>();
            this.cmdMapArgs.put("tag", RPC_TMP_OUTFILE_STREAM_KEY);
            this.relaxCmdNameValidationChecks = RpcPropertyDefs.getPropertyAsBoolean(props, "relaxCmdNameChecks", false);
            this.applicationName = RpcPropertyDefs.getProperty(props, "applicationName", null);
            this.localHostName = this.getUsageOptions().getHostName() != null ? this.getUsageOptions().getHostName() : InetAddress.getLocalHost().getHostName();
            if (this.localHostName == null) {
                throw new NullPointerError("Null client host name in RPC connection init");
            }
            if (!this.useAuthMemoryStore) {
                this.ticketsFilePath = this.props.getProperty("ticketPath", this.props.getProperty("com.perforce.p4java.ticketPath"));
                if (this.ticketsFilePath == null) {
                    this.ticketsFilePath = PerforceEnvironment.getP4Tickets();
                }
                if (this.ticketsFilePath == null) {
                    this.ticketsFilePath = this.getDefaultP4TicketsFile();
                }
                this.trustFilePath = this.props.getProperty("trustPath", this.props.getProperty("com.perforce.p4java.trustPath"));
                if (this.trustFilePath == null) {
                    this.trustFilePath = PerforceEnvironment.getP4Trust();
                }
                if (this.trustFilePath == null) {
                    this.trustFilePath = this.getDefaultP4TrustFile();
                }
            }
            this.serverStats = new ServerStats();
        }
        catch (UnknownHostException uhe) {
            throw new ConfigException("Unable to determine client host name: " + uhe.getLocalizedMessage());
        }
        this.clientTrust = new ClientTrust(this);
        return this.status;
    }

    protected void checkFingerprint(RpcConnection rpcConnection) throws ConnectionException {
        if (rpcConnection != null && rpcConnection.isSecure() && !rpcConnection.isTrusted()) {
            if (rpcConnection.getFingerprint() == null) {
                throw new ConnectionException("Null fingerprint for this Perforce SSL connection");
            }
            if (!this.clientTrust.fingerprintExists(rpcConnection.getServerIpPort())) {
                throw new TrustException(TrustException.Type.NEW_CONNECTION, this.getServerHostPort(), rpcConnection.getServerIpPort(), rpcConnection.getFingerprint(), this.clientTrust.getMessages().getMessage("client.trust.warning.newconnection", new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()}) + this.clientTrust.getMessages().getMessage("client.trust.exception.newconnection"));
            }
            if (!this.clientTrust.fingerprintMatches(rpcConnection.getServerIpPort(), rpcConnection.getFingerprint())) {
                throw new TrustException(TrustException.Type.NEW_KEY, this.getServerHostPort(), rpcConnection.getServerIpPort(), rpcConnection.getFingerprint(), this.clientTrust.getMessages().getMessage("client.trust.warning.newkey", new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()}) + this.clientTrust.getMessages().getMessage("client.trust.exception.newkey"));
            }
            rpcConnection.setTrusted(true);
        }
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.connectionStart = System.currentTimeMillis();
        super.connect();
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        super.disconnect();
        if (this.connectionStart != 0L) {
            Log.stats("RPC connection connected for " + (System.currentTimeMillis() - this.connectionStart) + " msec elapsed time");
        }
        this.serverStats.logStats();
        this.authCounter.clearCount();
    }

    @Override
    public boolean supportsSmartMove() throws ConnectionException, RequestException, AccessException {
        if (this.serverVersion < 20091) {
            return false;
        }
        IServerInfo info = this.getServerInfo();
        if (info == null) {
            return false;
        }
        return !info.isMoveDisabled();
    }

    @Override
    public String getErrorOrInfoStr(Map<String, Object> map) {
        return this.getString(map, 1);
    }

    @Override
    public boolean isInfoMessage(Map<String, Object> map) {
        if (map != null) {
            return RpcMessage.getSeverity((String)map.get("code0")) == 1;
        }
        return false;
    }

    @Override
    public int getSeverityCode(Map<String, Object> map) {
        if (map != null && map.containsKey("code0")) {
            return RpcMessage.getSeverity((String)map.get("code0"));
        }
        return 0;
    }

    @Override
    protected int getGenericCode(Map<String, Object> map) {
        if (map != null && map.containsKey("code0")) {
            return RpcMessage.getGeneric((String)map.get("code0"));
        }
        return 0;
    }

    private String getString(Map<String, Object> map, int minimumCode) {
        if (map != null) {
            int index = 0;
            String code = (String)map.get("code" + index);
            if (code == null) {
                return null;
            }
            boolean foundCode = false;
            StringBuilder codeString = new StringBuilder();
            while (code != null) {
                int severity = RpcMessage.getSeverity(code);
                if (severity >= minimumCode) {
                    foundCode = true;
                    String fmtStr = (String)map.get("fmt" + index);
                    if (fmtStr != null) {
                        if (fmtStr.indexOf(37) != -1) {
                            fmtStr = RpcMessage.interpolateArgs(fmtStr, map);
                        }
                        codeString.insert(0, fmtStr);
                        codeString.insert(fmtStr.length(), '\n');
                    }
                }
                code = (String)map.get("code" + ++index);
            }
            if (foundCode) {
                return codeString.toString();
            }
        }
        return null;
    }

    @Override
    public String getErrorStr(Map<String, Object> map) {
        return this.getString(map, 3);
    }

    @Override
    public String getInfoStr(Map<String, Object> map) {
        String code0;
        int severity;
        if (map != null && (severity = RpcMessage.getSeverity(code0 = (String)map.get("code0"))) == 1) {
            String fmtStr = (String)map.get("fmt0");
            if (fmtStr == null) {
                return RPC_TMP_OUTFILE_STREAM_KEY;
            }
            if (!fmtStr.contains("%")) {
                return fmtStr;
            }
            return RpcMessage.interpolateArgs(fmtStr, map);
        }
        return null;
    }

    @Override
    public boolean isAuthFail(String errStr) {
        if (errStr != null) {
            for (String str : accessErrMsgs) {
                if (!errStr.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLoginNotRequired(String msgStr) {
        return msgStr != null && msgStr.contains(PASSWORD_NOT_SET_STRING);
    }

    public int getClientApiLevel() {
        return this.clientApiLevel;
    }

    public void setClientApiLevel(int clientApiLevel) {
        this.clientApiLevel = clientApiLevel;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public PerformanceMonitor getPerfMonitor() {
        return this.perfMonitor;
    }

    public void setPerfMonitor(PerformanceMonitor perfMonitor) {
        this.perfMonitor = perfMonitor;
    }

    protected String getOsTypeForEnv() {
        String osName = System.getProperty(RPC_ENV_OS_NAME_KEY);
        if (osName != null && osName.toLowerCase(Locale.ENGLISH).contains(RPC_ENV_WINDOWS_PREFIX)) {
            return RPC_ENV_WINDOWS_SPEC;
        }
        return RPC_ENV_UNIX_SPEC;
    }

    protected String getLanguageForEnv() {
        return this.getUsageOptions().getTextLanguage();
    }

    protected String getClientNameForEnv() {
        if (this.getClientName() != null) {
            return this.getClientName();
        }
        return this.getUsageOptions().getUnsetClientName();
    }

    protected String getHostForEnv() {
        if (this.localHostName != null) {
            return this.localHostName;
        }
        return RPC_ENV_NOHOST_SPEC;
    }

    protected String getUserForEnv() {
        if (this.getUserName() != null) {
            return this.getUserName();
        }
        return this.getUsageOptions().getUnsetUserName();
    }

    protected void processCmdCallbacks(int cmdCallBackKey, long timeTaken, List<Map<String, Object>> resultMaps) {
        this.commandCallback.completedServerCommand(cmdCallBackKey, timeTaken);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                String str = this.getErrorOrInfoStr(map);
                if (str != null) {
                    str = str.trim();
                }
                int severity = this.getSeverityCode(map);
                int generic = this.getGenericCode(map);
                if (severity != 0) {
                    this.commandCallback.receivedServerMessage(cmdCallBackKey, generic, severity, str);
                }
                if (severity == 1) {
                    this.commandCallback.receivedServerInfoLine(cmdCallBackKey, str);
                    continue;
                }
                if (severity < 3) continue;
                this.commandCallback.receivedServerErrorLine(cmdCallBackKey, str);
            }
        }
    }

    public void saveCurrentTicket() throws P4JavaException {
        this.saveTicket(this.getAuthTicket());
    }

    public void saveTicket(String ticketValue) throws ConfigException {
        this.saveTicket(this.getUserName(), ticketValue);
    }

    public void saveTicket(String userName, String ticketValue) throws ConfigException {
        ConfigException exception;
        block13: {
            String serverId;
            exception = null;
            if (!this.isCaseSensitive() && userName != null) {
                userName = userName.toLowerCase();
            }
            if ((serverId = this.getServerId()) != null) {
                try {
                    AuthTicketsHelper.saveTicket(userName, serverId, ticketValue, this.ticketsFilePath);
                }
                catch (IOException e) {
                    exception = new ConfigException(e);
                }
            }
            if (ticketValue == null || serverId == null) {
                String server = null;
                if (this.serverHost != null) {
                    server = this.serverHost;
                    if (this.serverPort != -1) {
                        server = server + ":" + Integer.toString(this.serverPort);
                    }
                } else if (this.serverPort != -1) {
                    server = Integer.toString(this.serverPort);
                }
                if (server != null) {
                    try {
                        AuthTicketsHelper.saveTicket(userName, server, ticketValue, this.ticketsFilePath);
                    }
                    catch (IOException e) {
                        if (exception != null) break block13;
                        exception = new ConfigException(e);
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String loadTicket(String serverId) {
        String ticketValue = null;
        String name = this.getUserName();
        if (name != null) {
            try {
                ticketValue = AuthTicketsHelper.getTicketValue(name, serverId, this.ticketsFilePath);
            }
            catch (IOException e) {
                ticketValue = null;
            }
            if (ticketValue == null) {
                String server = null;
                if (this.serverHost != null) {
                    server = this.serverHost;
                    if (this.serverPort != -1) {
                        server = server + ":" + Integer.toString(this.serverPort);
                    }
                } else if (this.serverPort != -1) {
                    server = Integer.toString(this.serverPort);
                }
                try {
                    ticketValue = AuthTicketsHelper.getTicketValue(name, server, this.ticketsFilePath);
                }
                catch (IOException e) {
                    ticketValue = null;
                }
            }
        }
        return ticketValue;
    }

    public void saveFingerprint(String serverIpPort, String fingerprintValue) throws ConfigException {
        if (serverIpPort == null) {
            return;
        }
        try {
            FingerprintsHelper.saveFingerprint("**++**", serverIpPort, fingerprintValue, this.trustFilePath);
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }

    public Fingerprint loadFingerprint(String serverIpPort) {
        if (serverIpPort == null) {
            return null;
        }
        Fingerprint fingerprint = null;
        try {
            fingerprint = FingerprintsHelper.getFingerprint("**++**", serverIpPort, this.trustFilePath);
        }
        catch (IOException e) {
            fingerprint = null;
        }
        return fingerprint;
    }

    public Fingerprint[] loadFingerprints() {
        Fingerprint[] fingerprints = null;
        try {
            fingerprints = FingerprintsHelper.getFingerprints(this.trustFilePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fingerprints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTrust() throws P4JavaException {
        String string;
        block2: {
            RpcConnection rpcConnection = null;
            try {
                rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, this.secure);
                string = rpcConnection.getFingerprint();
                Object var4_3 = null;
                if (rpcConnection == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (rpcConnection == null) break block3;
                    rpcConnection.disconnect(null);
                }
                throw throwable;
            }
            rpcConnection.disconnect(null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String addTrust(TrustOptions opts) throws P4JavaException {
        String string;
        RpcConnection rpcConnection;
        block12: {
            String string2;
            block11: {
                String string3;
                block10: {
                    String string4;
                    block9: {
                        String string5;
                        block8: {
                            rpcConnection = null;
                            try {
                                rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, this.secure);
                                if (opts == null) {
                                    opts = new TrustOptions();
                                }
                                String newConnectionWarning = this.clientTrust.getMessages().getMessage("client.trust.warning.newconnection", new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()});
                                String newKeyWarning = this.clientTrust.getMessages().getMessage("client.trust.warning.newkey", new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()});
                                boolean fpExist = this.clientTrust.fingerprintExists(rpcConnection.getServerIpPort());
                                boolean fpMatch = this.clientTrust.fingerprintMatches(rpcConnection.getServerIpPort(), rpcConnection.getFingerprint());
                                if (opts.isAutoRefuse()) {
                                    if (!fpExist) {
                                        string5 = newConnectionWarning;
                                        Object var9_12 = null;
                                        if (rpcConnection == null) return string5;
                                        break block8;
                                    }
                                    if (!fpMatch) {
                                        string4 = newKeyWarning;
                                        break block9;
                                    }
                                }
                                if (!fpExist) {
                                    if (!opts.isAutoAccept()) throw new TrustException(TrustException.Type.NEW_CONNECTION, this.getServerHostPort(), rpcConnection.getServerIpPort(), rpcConnection.getFingerprint(), newConnectionWarning + this.clientTrust.getMessages().getMessage("client.trust.add.exception.newconnection"));
                                    this.clientTrust.installFingerprint(rpcConnection.getServerIpPort(), rpcConnection.getFingerprint());
                                    string3 = newConnectionWarning + this.clientTrust.getMessages().getMessage("client.trust.added", new Object[]{this.getServerHostPort(), rpcConnection.getServerIpPort()});
                                    break block10;
                                }
                                if (!fpMatch) {
                                    if (!opts.isForce()) throw new TrustException(TrustException.Type.NEW_KEY, this.getServerHostPort(), rpcConnection.getServerIpPort(), rpcConnection.getFingerprint(), newKeyWarning + this.clientTrust.getMessages().getMessage("client.trust.add.exception.newkey"));
                                    if (!opts.isAutoAccept()) throw new TrustException(TrustException.Type.NEW_KEY, this.getServerHostPort(), rpcConnection.getServerIpPort(), rpcConnection.getFingerprint(), newKeyWarning + this.clientTrust.getMessages().getMessage("client.trust.add.exception.newkey"));
                                    this.clientTrust.installFingerprint(rpcConnection.getServerIpPort(), rpcConnection.getFingerprint());
                                    string2 = newKeyWarning + this.clientTrust.getMessages().getMessage("client.trust.added", new Object[]{this.getServerHostPort(), rpcConnection.getServerIpPort()});
                                    break block11;
                                }
                                string = this.clientTrust.getMessages().getMessage("client.trust.alreadyestablished");
                                break block12;
                            }
                            catch (Throwable throwable) {
                                Object var9_17 = null;
                                if (rpcConnection == null) throw throwable;
                                rpcConnection.disconnect(null);
                                throw throwable;
                            }
                        }
                        rpcConnection.disconnect(null);
                        return string5;
                    }
                    Object var9_13 = null;
                    if (rpcConnection == null) return string4;
                    rpcConnection.disconnect(null);
                    return string4;
                }
                Object var9_14 = null;
                if (rpcConnection == null) return string3;
                rpcConnection.disconnect(null);
                return string3;
            }
            Object var9_15 = null;
            if (rpcConnection == null) return string2;
            rpcConnection.disconnect(null);
            return string2;
        }
        Object var9_16 = null;
        if (rpcConnection == null) return string;
        rpcConnection.disconnect(null);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addTrust(String fingerprintValue) throws P4JavaException {
        String string;
        block6: {
            if (fingerprintValue == null) {
                throw new NullPointerError("null fingerprintValue passed to addTrust");
            }
            RpcConnection rpcConnection = null;
            try {
                rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, this.secure);
                String message = RPC_TMP_OUTFILE_STREAM_KEY;
                if (!this.clientTrust.fingerprintExists(rpcConnection.getServerIpPort())) {
                    message = this.clientTrust.getMessages().getMessage("client.trust.warning.newconnection", new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()});
                } else if (!this.clientTrust.fingerprintMatches(rpcConnection.getServerIpPort(), fingerprintValue)) {
                    message = this.clientTrust.getMessages().getMessage("client.trust.warning.newkey", new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()});
                }
                this.clientTrust.installFingerprint(rpcConnection.getServerIpPort(), fingerprintValue);
                string = message + this.clientTrust.getMessages().getMessage("client.trust.added", new Object[]{this.getServerHostPort(), rpcConnection.getServerIpPort()});
                Object var6_5 = null;
                if (rpcConnection == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_6 = null;
                    if (rpcConnection == null) break block7;
                    rpcConnection.disconnect(null);
                }
                throw throwable;
            }
            rpcConnection.disconnect(null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String removeTrust() throws P4JavaException {
        String string;
        block8: {
            String message;
            RpcConnection rpcConnection;
            block6: {
                String string2;
                block7: {
                    block4: {
                        String string3;
                        block5: {
                            rpcConnection = null;
                            try {
                                rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, this.secure);
                                message = this.clientTrust.getMessages().getMessage("client.trust.removed", new Object[]{this.getServerHostPort(), rpcConnection.getServerIpPort()});
                                this.clientTrust.removeFingerprint(rpcConnection.getServerIpPort());
                                if (this.clientTrust.fingerprintExists(rpcConnection.getServerIpPort())) break block4;
                                string3 = this.clientTrust.getMessages().getMessage("client.trust.warning.newconnection", new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()}) + message;
                                Object var5_6 = null;
                                if (rpcConnection == null) break block5;
                            }
                            catch (Throwable throwable) {
                                block9: {
                                    Object var5_9 = null;
                                    if (rpcConnection == null) break block9;
                                    rpcConnection.disconnect(null);
                                }
                                throw throwable;
                            }
                            rpcConnection.disconnect(null);
                        }
                        return string3;
                    }
                    if (this.clientTrust.fingerprintMatches(rpcConnection.getServerIpPort(), rpcConnection.getFingerprint())) break block6;
                    string2 = this.clientTrust.getMessages().getMessage("client.trust.warning.newkey", new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()}) + message;
                    Object var5_7 = null;
                    if (rpcConnection == null) break block7;
                    rpcConnection.disconnect(null);
                }
                return string2;
            }
            string = message;
            Object var5_8 = null;
            if (rpcConnection == null) break block8;
            rpcConnection.disconnect(null);
        }
        return string;
    }

    @Override
    public List<Fingerprint> getTrusts() throws P4JavaException {
        Fingerprint[] fingerprints = this.loadFingerprints();
        if (fingerprints != null) {
            return Arrays.asList(fingerprints);
        }
        return null;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    protected boolean writeInPlace(String cmdName) {
        return cmdName.equalsIgnoreCase(CmdSpec.SYNC.toString()) && new Boolean(System.getProperty("com.perforce.p4java.writeInPlace", this.props.getProperty("writeInPlace", "false"))) != false;
    }

    public String getSecretKey() {
        return this.getSecretKey(this.userName);
    }

    public void setSecretKey(String secretKey) {
        this.setSecretKey(this.userName, secretKey);
    }

    public String getSecretKey(String userName) {
        if (userName != null) {
            return this.secretKeys.get(userName);
        }
        return null;
    }

    public void setSecretKey(String userName, String secretKey) {
        if (userName != null) {
            if (secretKey == null) {
                this.secretKeys.remove(userName);
            } else {
                this.secretKeys.put(userName, secretKey);
            }
        }
    }

    protected boolean isRelaxCmdNameValidationChecks() {
        return this.relaxCmdNameValidationChecks;
    }

    protected void setRelaxCmdNameValidationChecks(boolean relaxCmdNameValidationChecks) {
        this.relaxCmdNameValidationChecks = relaxCmdNameValidationChecks;
    }

    protected RpcPacketFieldRule getRpcPacketFieldRule(Map<String, Object> inMap, CmdSpec cmdSpec) {
        Map cmdMap;
        if (inMap != null && cmdSpec != null && cmdSpec == CmdSpec.EXPORT && inMap.containsKey(cmdSpec.toString()) && inMap.get(cmdSpec.toString()) instanceof Map && (cmdMap = (Map)inMap.remove(cmdSpec.toString())) != null) {
            return RpcPacketFieldRule.getInstance(cmdMap);
        }
        return null;
    }

    @Override
    public void setAuthTicket(String userName, String authTicket) {
        String serverAddress;
        if (userName == null) {
            throw new IllegalArgumentException("Null userName passed to the setAuthTicket method.");
        }
        if (!this.isCaseSensitive() && userName != null) {
            userName = userName.toLowerCase();
        }
        String string = serverAddress = this.getServerId() != null ? this.getServerId() : this.getServerAddress();
        if (serverAddress == null) {
            throw new IllegalStateException("Null serverAddress in the setAuthTicket method.");
        }
        if (authTicket == null) {
            this.authTickets.remove(this.composeAuthTicketEntryKey(userName, serverAddress));
        } else {
            this.authTickets.put(this.composeAuthTicketEntryKey(userName, serverAddress), authTicket);
        }
    }

    @Override
    public String getAuthTicket(String userName) {
        String serverAddress;
        if (!this.isCaseSensitive() && userName != null) {
            userName = userName.toLowerCase();
        }
        String string = serverAddress = this.getServerId() != null ? this.getServerId() : this.getServerAddress();
        if (userName != null && serverAddress != null) {
            return (String)this.authTickets.get(this.composeAuthTicketEntryKey(userName, serverAddress));
        }
        return null;
    }

    @Override
    public void setTicketsFilePath(String ticketsFilePath) {
        if (ticketsFilePath == null) {
            throw new IllegalArgumentException("Null ticketsFilePath passed to the setTicketsFilePath method.");
        }
        this.ticketsFilePath = ticketsFilePath;
    }

    @Override
    public String getTicketsFilePath() {
        return this.ticketsFilePath;
    }

    @Override
    public void setTrustFilePath(String trustFilePath) {
        if (this.ticketsFilePath == null) {
            throw new IllegalArgumentException("Null trustFilePath passed to the setTrustFilePath method.");
        }
        this.trustFilePath = trustFilePath;
    }

    @Override
    public String getTrustFilePath() {
        return this.trustFilePath;
    }

    protected String composeAuthTicketEntryKey(String userName, String serverAddress) {
        if (userName == null) {
            throw new IllegalArgumentException("Null userName passed to the composeAuthTicketEntryKey method.");
        }
        if (serverAddress == null) {
            throw new IllegalArgumentException("Null serverAddress in the composeAuthTicketEntryKey method.");
        }
        if (serverAddress.indexOf(58) == -1) {
            serverAddress = serverAddress + "localhost:" + serverAddress;
        }
        return serverAddress + "=" + userName;
    }

    public String getServerAddress() {
        String serverAddress = this.serverAddress;
        if (serverAddress == null) {
            if (this.serverHost != null) {
                serverAddress = this.serverHost;
                if (this.serverPort != -1) {
                    serverAddress = serverAddress + ":" + Integer.toString(this.serverPort);
                }
            } else if (this.serverPort != -1) {
                serverAddress = Integer.toString(this.serverPort);
            }
        }
        return serverAddress;
    }

    public String getServerHostPort() {
        String serverHostPort = null;
        if (this.serverHost != null) {
            serverHostPort = this.serverHost;
            if (this.serverPort != -1) {
                serverHostPort = serverHostPort + ":" + Integer.toString(this.serverPort);
            }
        } else if (this.serverPort != -1) {
            serverHostPort = Integer.toString(this.serverPort);
        }
        return serverHostPort;
    }

    protected boolean useTags(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean isStreamCmd) {
        CmdSpec cmdSpec = CmdSpec.getValidP4JCmdSpec(cmdName);
        if (cmdSpec != null) {
            if (cmdSpec == CmdSpec.LOGIN) {
                return false;
            }
            if (isStreamCmd) {
                switch (cmdSpec) {
                    case DESCRIBE: 
                    case DIFF2: 
                    case PRINT: 
                    case PROTECT: {
                        return false;
                    }
                }
            }
            if (inMap != null && inMap.containsKey("useTags")) {
                return new Boolean((String)inMap.remove("useTags"));
            }
        }
        return true;
    }

    public RpcUserAuthCounter getAuthCounter() {
        return this.authCounter;
    }
}

