/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.file.IFileSpec;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathAnnotations {
    public static final String REV_PFX = "#";
    public static final String REV_SEP = ",#";
    public static final String NONREV_PFX = "@";
    protected int startRevision = -1;
    protected int endRevision = -1;
    protected Date date = null;
    protected int changelistId = -1;
    protected String label = null;
    private static Pattern revMetadata = Pattern.compile("((#)(\\d+)$)|(#none$)|(#head$)|(#have$)|(#have,#head$)|((#)(\\d+),#(\\d+)$)|((#)(\\d+),#head$)|((#)(\\d+),#have$)|(#)have,(\\d+)$");
    private static Pattern nonRevMetadata = Pattern.compile("((@)(\\d+)$)|((@)(\\d+\\/\\d+\\/\\d+)$)|((@)(\\d+\\/\\d+\\/\\d+:\\d+:\\d+:\\d+)$)|((@)([^@,%#]+)$)");
    private static Pattern revNumNum = Pattern.compile("(#)(\\d+),#(\\d+)$");
    private static Pattern revNumHead = Pattern.compile("(#)(\\d+),#head$");
    private static Pattern revNumHave = Pattern.compile("(#)(\\d+),#have$");
    private static Pattern revHaveNum = Pattern.compile("#have,#(\\d+)$");
    private static Pattern revNum = Pattern.compile("(#)(\\d+)$");
    private static Pattern revNone = Pattern.compile("#none$");
    private static Pattern revHead = Pattern.compile("#head$");
    private static Pattern revHave = Pattern.compile("#have$");
    private static Pattern revHaveHead = Pattern.compile("#have,#head$");
    private static Pattern nonrevChange = Pattern.compile("(@)(\\d+)$");
    private static Pattern nonrevDateShort = Pattern.compile("(@)(\\d+\\/\\d+\\/\\d+)$");
    private static Pattern nonrevDateFull = Pattern.compile("(@)(\\d+\\/\\d+\\/\\d+:\\d+:\\d+:\\d+)$");
    private static Pattern nonrevLabel = Pattern.compile("(@)([^@,%#]+)$");

    public PathAnnotations() {
    }

    public PathAnnotations(int startRevision, int endRevision, Date date, int changelistId, String label) {
        this.startRevision = startRevision;
        this.endRevision = endRevision;
        this.date = date;
        this.changelistId = changelistId;
        this.label = label;
    }

    public PathAnnotations(IFileSpec fileSpec) {
        if (fileSpec != null) {
            this.startRevision = fileSpec.getStartRevision();
            this.endRevision = fileSpec.getEndRevision();
            this.date = fileSpec.getDate();
            this.changelistId = fileSpec.getChangelistId();
            this.label = fileSpec.getLabel();
        }
    }

    public PathAnnotations(String pathStr) {
        if (pathStr != null) {
            if (PathAnnotations.hasRevisionAnnotations(pathStr) >= 0) {
                PathAnnotations.extractRevisionData(pathStr, this);
            } else if (PathAnnotations.hasNonRevisionAnnotations(pathStr) >= 0) {
                PathAnnotations.extractNonRevisionData(pathStr, this);
            }
        }
    }

    public static String stripAnnotations(String pathStr) {
        if (pathStr != null) {
            int i = -1;
            i = PathAnnotations.hasRevisionAnnotations(pathStr);
            if (i >= 0) {
                return pathStr.substring(0, i);
            }
            i = PathAnnotations.hasNonRevisionAnnotations(pathStr);
            if (i >= 0) {
                return pathStr.substring(0, i);
            }
        }
        return pathStr;
    }

    public static PathAnnotations getAnnotations(String pathStr) {
        if (pathStr != null && PathAnnotations.hasPerforceAnnotations(pathStr)) {
            return new PathAnnotations(pathStr);
        }
        return null;
    }

    public static int hasRevisionAnnotations(String pathStr) {
        Matcher mat;
        if (pathStr != null && pathStr.contains(REV_PFX) && (mat = revMetadata.matcher(pathStr)).find()) {
            return mat.start();
        }
        return -1;
    }

    public static int hasNonRevisionAnnotations(String pathStr) {
        Matcher mat;
        if (pathStr != null && pathStr.contains(NONREV_PFX) && (mat = nonRevMetadata.matcher(pathStr)).find()) {
            return mat.start();
        }
        return -1;
    }

    public static boolean hasPerforceAnnotations(String pathStr) {
        return PathAnnotations.hasRevisionAnnotations(pathStr) >= 0 || PathAnnotations.hasNonRevisionAnnotations(pathStr) >= 0;
    }

    public static boolean extractRevisionData(String pathStr, PathAnnotations pathAnnotations) {
        try {
            if (pathStr != null && pathAnnotations != null) {
                Matcher mat = revNumNum.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = new Integer(mat.group(2));
                    pathAnnotations.endRevision = new Integer(mat.group(3));
                    return true;
                }
                mat = revNumHead.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = new Integer(mat.group(2));
                    pathAnnotations.endRevision = -17;
                    return true;
                }
                mat = revNumHave.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = new Integer(mat.group(2));
                    pathAnnotations.endRevision = -18;
                    return true;
                }
                mat = revHaveNum.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = -18;
                    pathAnnotations.endRevision = new Integer(mat.group(1));
                    return true;
                }
                mat = revHaveHead.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = -18;
                    pathAnnotations.endRevision = -17;
                    return true;
                }
                mat = revNum.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = -1;
                    pathAnnotations.endRevision = new Integer(mat.group(2));
                    return true;
                }
                mat = revHead.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = -1;
                    pathAnnotations.endRevision = -17;
                    return true;
                }
                mat = revHave.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = -1;
                    pathAnnotations.endRevision = -18;
                    return true;
                }
                mat = revNone.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.startRevision = -1;
                    pathAnnotations.endRevision = 0;
                    return true;
                }
            }
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception in PathAnnotations.extractRevisionData; pathStr: " + pathStr + "; message: " + thr.getLocalizedMessage());
            Log.exception(thr);
        }
        return false;
    }

    public static boolean extractNonRevisionData(String pathStr, PathAnnotations pathAnnotations) {
        if (pathStr != null && pathAnnotations != null) {
            try {
                Matcher mat = nonrevChange.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.changelistId = new Integer(mat.group(2));
                    return true;
                }
                mat = nonrevDateShort.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.date = new SimpleDateFormat("yyyy/MM/dd").parse(mat.group(2));
                    return true;
                }
                mat = nonrevDateFull.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.date = new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss").parse(mat.group(2));
                    return true;
                }
                mat = nonrevLabel.matcher(pathStr);
                if (mat.find()) {
                    pathAnnotations.label = mat.group(2);
                    return true;
                }
            }
            catch (Exception exc) {
                Log.error("Unexpected parse exception in PathAnnotations.extractNonRevData: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
        return false;
    }

    public String toString() {
        if (this.startRevision != -1 && this.endRevision != -1) {
            return REV_PFX + PathAnnotations.revString(this.startRevision) + REV_SEP + PathAnnotations.revString(this.endRevision);
        }
        if (this.endRevision != -1) {
            return REV_PFX + PathAnnotations.revString(this.endRevision);
        }
        if (this.getChangelistId() != -1) {
            return NONREV_PFX + this.getChangelistId();
        }
        if (this.getLabel() != null) {
            return NONREV_PFX + this.getLabel();
        }
        if (this.getDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss");
            StringBuffer sBuf = new StringBuffer();
            sdf.format(this.getDate(), sBuf, new FieldPosition(0));
            return NONREV_PFX + sBuf.toString();
        }
        return "";
    }

    public int getStartRevision() {
        return this.startRevision;
    }

    public void setStartRevision(int startRev) {
        this.startRevision = startRev;
    }

    public int getEndRevision() {
        return this.endRevision;
    }

    public void setEndRevision(int endRev) {
        this.endRevision = endRev;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getChangelistId() {
        return this.changelistId;
    }

    public void setChangelistId(int changelistId) {
        this.changelistId = changelistId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private static String revString(int revision) {
        switch (revision) {
            case -1: {
                return "";
            }
            case 0: {
                return "none";
            }
            case -18: {
                return "have";
            }
            case -17: {
                return "head";
            }
        }
        return "" + revision;
    }
}

