/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option;

import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Options {
    protected List<String> optionList = null;
    protected boolean immutable = false;
    protected static final String OPTPFX = "-";

    public Options() {
        this.optionList = null;
    }

    public Options(String ... options) {
        this.optionList = new ArrayList<String>();
        if (options != null) {
            for (String option : options) {
                if (option == null || option.length() <= 0) continue;
                this.optionList.add(option);
            }
        }
        this.setImmutable(true);
    }

    public List<String> getOptions() {
        return this.optionList;
    }

    public Options setOptions(String ... options) {
        if (options != null) {
            this.optionList = new ArrayList<String>();
            for (String option : options) {
                if (option == null) continue;
                this.optionList.add(option);
            }
        } else {
            this.optionList = null;
        }
        return this;
    }

    public abstract List<String> processOptions(IServer var1) throws OptionsException;

    public List<String> processFields(String optsSpecs, Object ... opts) throws OptionsException {
        ArrayList<String> optsList = new ArrayList<String>();
        if (optsSpecs == null) {
            throw new OptionsException("null options spec in options processor");
        }
        if (opts != null) {
            String[] specStrs = optsSpecs.split(" ");
            if (specStrs.length != opts.length) {
                throw new OptionsException("specs vs opts size mismatch in options processor");
            }
            for (int i = 0; i < opts.length; ++i) {
                if (specStrs[i] == null) {
                    throw new OptionsException("null options spec in options processor: " + optsSpecs);
                }
                String[] optSpec = specStrs[i].split(":");
                if (optSpec.length < 2 || optSpec.length > 3) {
                    throw new OptionsException("bad options spec in options processor: " + specStrs[i]);
                }
                try {
                    String optVal = null;
                    if (optSpec[0].equals("i")) {
                        optVal = this.applyRule(optSpec.length >= 3 ? optSpec[2] : null, optSpec[1], (Integer)opts[i]);
                    } else if (optSpec[0].equals("s")) {
                        optVal = this.applyRule(optSpec.length >= 3 ? optSpec[2] : null, optSpec[1], (String)opts[i]);
                    } else if (optSpec[0].equals("b")) {
                        optVal = this.applyRule(optSpec.length >= 3 ? optSpec[2] : null, optSpec[1], (Boolean)opts[i]);
                    }
                    if (optVal == null) continue;
                    optsList.add(optVal);
                    continue;
                }
                catch (Exception exc) {
                    throw new OptionsException("bad conversion encountered in options processor with option string '" + specStrs[i] + "': " + exc.getLocalizedMessage());
                }
            }
        }
        return optsList;
    }

    protected String applyRule(String ruleName, String serverOptStr, int value) throws OptionsException {
        if (serverOptStr == null) {
            throw new OptionsException("Null server options spec");
        }
        if (ruleName == null) {
            return OPTPFX + serverOptStr + value;
        }
        if (ruleName.equals("gtz")) {
            if (value > 0) {
                return OPTPFX + serverOptStr + value;
            }
        } else if (ruleName.equals("cl")) {
            if (value >= 0) {
                return OPTPFX + serverOptStr + (value == 0 ? "default" : Integer.valueOf(value));
            }
        } else if (ruleName.equals("clz")) {
            if (value > 0) {
                return OPTPFX + serverOptStr + value;
            }
        } else if (ruleName.equals("dcn")) {
            if (value > 0) {
                return OPTPFX + serverOptStr + value;
            }
            if (value == 0) {
                return OPTPFX + serverOptStr;
            }
        } else {
            throw new OptionsException("Unrecognized option rule name in options parser: '" + ruleName + "'");
        }
        return null;
    }

    protected String applyRule(String ruleName, String serverOptStr, String value) throws OptionsException {
        if (serverOptStr == null) {
            throw new OptionsException("Null server options spec");
        }
        if (ruleName == null) {
            if (value != null) {
                return OPTPFX + serverOptStr + value;
            }
        } else {
            throw new OptionsException("Unrecognized option rule name in options parser: '" + ruleName + "'");
        }
        return null;
    }

    protected String applyRule(String ruleName, String serverOptStr, boolean value) throws OptionsException {
        if (serverOptStr == null) {
            throw new OptionsException("Null server options spec");
        }
        if (ruleName == null) {
            if (value) {
                return OPTPFX + serverOptStr;
            }
        } else {
            throw new OptionsException("Unrecognized option rule name in options parser: '" + ruleName + "'");
        }
        return null;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public Options setImmutable(boolean immutable) {
        this.immutable = immutable;
        return this;
    }
}

