/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInflaterOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcLineEndFilterOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcOutputStream
extends FileOutputStream {
    private static final int GZIP_MAGIC = 35615;
    private static final int FTEXT = 1;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int TRAILER_SIZE = 8;
    private RpcPerforceFile file = null;
    private RpcPerforceFileType fileType = null;
    private RpcInflaterOutputStream outStream = null;
    private CheckedOutputStream checkedOutStream = null;
    private Inflater inflater = null;
    private CRC32 crc = null;
    private boolean headerRead = false;
    private byte[] footerBytes = null;
    private boolean closed = false;
    private ClientLineEnding lineEnding = null;
    private RpcLineEndFilterOutputStream lineEndStream = null;
    private Charset charset = null;
    private CharsetConverter converter;

    public RpcOutputStream(RpcPerforceFile file) throws IOException {
        this(file, null, false);
    }

    public RpcOutputStream(RpcPerforceFile file, Charset charset, boolean isUnicodeServer) throws IOException {
        super(file);
        if (file == null) {
            throw new NullPointerError("Null RpcPerforceFile passed to RpcOutputStream constructor");
        }
        if (charset != null && !charset.equals(CharsetDefs.UTF8)) {
            this.charset = charset;
        }
        this.closed = false;
        this.file = file;
        this.fileType = file.getFileType();
        this.lineEnding = file.getLineEnding();
        if (this.fileType != null) {
            switch (this.fileType) {
                case FST_UTF16: {
                    this.charset = CharsetDefs.UTF16;
                }
                case FST_UNICODE: {
                    if (this.charset != null && (isUnicodeServer || this.charset == CharsetDefs.UTF16)) {
                        this.converter = new CharsetConverter(CharsetDefs.UTF8, this.charset);
                    }
                }
                case FST_TEXT: 
                case FST_XTEXT: {
                    if (!ClientLineEnding.needsLineEndFiltering(this.lineEnding)) break;
                    this.lineEndStream = new RpcLineEndFilterOutputStream(this, this.lineEnding);
                    break;
                }
                case FST_GUNZIP: 
                case FST_XGUNZIP: {
                    this.inflater = new Inflater(true);
                    this.crc = new CRC32();
                    this.checkedOutStream = new CheckedOutputStream(this, this.crc);
                    this.outStream = new RpcInflaterOutputStream(this.checkedOutStream, this.inflater);
                    this.headerRead = false;
                    this.footerBytes = new byte[8];
                }
            }
        } else {
            this.fileType = RpcPerforceFileType.FST_TEXT;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            switch (this.fileType) {
                case FST_TEXT: 
                case FST_XTEXT: {
                    if (this.lineEndStream == null) break;
                    this.lineEndStream.close();
                    break;
                }
                case FST_GUNZIP: 
                case FST_XGUNZIP: {
                    this.readTrailer(this.footerBytes);
                    this.outStream.close();
                    this.checkedOutStream.close();
                }
            }
            super.close();
        }
    }

    @Override
    public void flush() throws IOException {
        byte[] underflow;
        super.flush();
        if (this.converter != null && (underflow = this.converter.clearUnderflow()) != null) {
            this.writeConverted(underflow);
        }
    }

    public void write(Map<String, Object> map) throws IOException {
        if (map == null) {
            throw new NullPointerError("Null map passed to RpcOutputStream.write(map)");
        }
        try {
            byte[] sourceBytes = (byte[])map.get("data");
            this.writeConverted(sourceBytes);
        }
        catch (ClassCastException exc) {
            throw new P4JavaError("RpcFunctionMapKey.DATA value not byte[] type");
        }
    }

    @Override
    public void write(byte[] sourceBytes, int off, int len) throws IOException {
        if (sourceBytes == null) {
            throw new NullPointerError("Null bytes passed to RpcOutputStream.write()");
        }
        if (off < 0) {
            throw new P4JavaError("Negative offset in RpcOutputStream.write()");
        }
        if (len < 0) {
            throw new P4JavaError("Negative length in RpcOutputStream.write()");
        }
        super.write(sourceBytes, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerError("Null bytes passed to RpcOutputStream.write()");
        }
        super.write(b, 0, b.length);
    }

    public void writeConverted(byte[] sourceBytes) throws IOException {
        int len = sourceBytes.length;
        if (len <= 0) {
            return;
        }
        int start = 0;
        switch (this.fileType) {
            case FST_UTF16: 
            case FST_UNICODE: {
                if (this.converter != null) {
                    ByteBuffer sourceBuffer;
                    ByteBuffer converted;
                    if (this.lineEndStream != null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream(10240);
                        this.lineEndStream.write(out, sourceBytes, start, len);
                        sourceBytes = out.toByteArray();
                        len = sourceBytes.length;
                        start = 0;
                    }
                    if ((converted = this.converter.convert(sourceBuffer = ByteBuffer.wrap(sourceBytes))) != null) {
                        sourceBytes = converted.array();
                        start = converted.position();
                        len = converted.limit();
                    } else {
                        len = 0;
                    }
                    if (len <= 0) {
                        return;
                    }
                    this.write(sourceBytes, start, len);
                    break;
                }
            }
            case FST_TEXT: 
            case FST_XTEXT: {
                if (this.lineEndStream != null) {
                    this.lineEndStream.write(sourceBytes, start, len);
                    break;
                }
                this.write(sourceBytes, start, len);
                break;
            }
            case FST_GUNZIP: 
            case FST_XGUNZIP: {
                if (!this.headerRead) {
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(sourceBytes, 0, len);
                    this.readHeader(byteStream, new CRC32());
                    this.headerRead = true;
                    int bytesAvailable = byteStream.available();
                    if (bytesAvailable <= 0) break;
                    this.outStream.write(sourceBytes, len - bytesAvailable, bytesAvailable);
                    if (bytesAvailable >= 8) {
                        System.arraycopy(sourceBytes, len - 8, this.footerBytes, 0, 8);
                        break;
                    }
                    System.arraycopy(sourceBytes, len - bytesAvailable, this.footerBytes, 0, bytesAvailable);
                    break;
                }
                this.outStream.write(sourceBytes, 0, len);
                if (len >= 8) {
                    System.arraycopy(sourceBytes, len - 8, this.footerBytes, 0, 8);
                    break;
                }
                System.arraycopy(this.footerBytes, len, this.footerBytes, 0, 8 - len);
                System.arraycopy(sourceBytes, 0, this.footerBytes, 8 - len, len);
                break;
            }
            default: {
                this.write(sourceBytes, 0, len);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
    }

    public RpcPerforceFile getFile() {
        return this.file;
    }

    private void readHeader(InputStream inStream, CRC32 crc) throws IOException {
        CheckedInputStream in = new CheckedInputStream(inStream, crc);
        crc.reset();
        if (this.readUShort(in) != 35615) {
            throw new IOException("Not in GZIP format");
        }
        if (this.readUByte(in) != 8) {
            throw new IOException("Unsupported compression method");
        }
        int flg = this.readUByte(in);
        this.skipBytes(in, 6);
        if ((flg & 4) == 4) {
            this.skipBytes(in, this.readUShort(in));
        }
        if ((flg & 8) == 8) {
            while (this.readUByte(in) != 0) {
            }
        }
        if ((flg & 0x10) == 16) {
            while (this.readUByte(in) != 0) {
            }
        }
        if ((flg & 2) == 2) {
            int v = (int)crc.getValue() & 0xFFFF;
            if (this.readUShort(in) != v) {
                throw new IOException("Corrupt GZIP header");
            }
        }
    }

    private void readTrailer(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        long intIn = this.readUInt(in);
        long len = this.readUInt(in);
        Checksum checksum = this.checkedOutStream.getChecksum();
        if (checksum != null && intIn != checksum.getValue()) {
            throw new IOException("Corrupt GZIP trailer (bad CRC value)");
        }
        if (len != (this.inflater.getBytesWritten() & 0xFFFFFFFFL)) {
            throw new IOException("Corrupt GZIP trailer (bad bytes-written size)");
        }
    }

    private long readUInt(InputStream in) throws IOException {
        long s = this.readUShort(in);
        return (long)this.readUShort(in) << 16 | s;
    }

    private int readUShort(InputStream in) throws IOException {
        int b = this.readUByte(in);
        return this.readUByte(in) << 8 | b;
    }

    private int readUByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        if (b < -1 || b > 255) {
            throw new IOException(".read() returned value out of range -1..255: " + b);
        }
        return b;
    }

    private void skipBytes(InputStream in, int n) throws IOException {
        byte[] tmpbuf = new byte[128];
        while (n > 0) {
            int len = in.read(tmpbuf, 0, n < tmpbuf.length ? n : tmpbuf.length);
            if (len == -1) {
                throw new EOFException("Unexpected EOF");
            }
            n -= len;
        }
    }
}

