/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.ILookahead;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcLineEndFilterInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSendFile {
    public static final String TRACE_PREFIX = "ClientSendFile";
    public static final int DEFAULT_SENDBUF_SIZE = 1024;
    private Properties props = null;
    private ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();

    protected ClientSendFile(Properties props) {
        this.props = props;
    }

    private long sendRaw(InputStream stream, RpcConnection connection, String handle, String write, MD5Digester digester) throws ConnectionException, IOException {
        long fileLength = 0L;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        byte[] bytes = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = stream.read(bytes)) > 0) {
            byte[] readBytes = new byte[bytesRead];
            System.arraycopy(bytes, 0, readBytes, 0, bytesRead);
            fileLength += (long)bytesRead;
            sendMap.clear();
            sendMap.put("data", readBytes);
            sendMap.put("handle", handle);
            RpcPacket sendPacket = RpcPacket.constructRpcPacket(write, sendMap, null);
            connection.putRpcPacket(sendPacket);
            digester.update(readBytes);
        }
        return fileLength;
    }

    private ILookahead createLookahead(final InputStream stream, Charset charset) {
        CharsetConverter newlineConverter = new CharsetConverter(CharsetDefs.DEFAULT, charset, true);
        ByteBuffer newlineBuffer = newlineConverter.convert(CharBuffer.wrap(new char[]{'\n'}));
        final int lookaheadLength = newlineBuffer.limit();
        ILookahead lookahead = new ILookahead(){

            public byte[] bytesToAdd(char lastDecodedChar) {
                byte[] add = null;
                if (lastDecodedChar == '\r') {
                    add = new byte[lookaheadLength];
                    try {
                        int read = stream.read(add);
                        if (read != add.length) {
                            byte[] realAdd = new byte[read];
                            System.arraycopy(add, 0, realAdd, 0, read);
                            add = realAdd;
                        }
                    }
                    catch (IOException e) {
                        add = null;
                    }
                }
                return add;
            }
        };
        return lookahead;
    }

    private long sendConverted(Charset charset, InputStream stream, RpcConnection connection, String handle, String write, MD5Digester digester) throws ConnectionException, IOException {
        long fileLength = 0L;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        byte[] bytes = new byte[1024];
        int bytesRead = 0;
        ILookahead lookahead = null;
        if (ClientLineEnding.CONVERT_TEXT) {
            lookahead = this.createLookahead(stream, charset);
        }
        CharsetConverter converter = new CharsetConverter(charset, CharsetDefs.UTF8);
        while ((bytesRead = stream.read(bytes)) > 0) {
            ByteBuffer inBuffer = ByteBuffer.wrap(bytes, 0, bytesRead);
            ByteBuffer converted = converter.convert(inBuffer, lookahead);
            byte[] sendBytes = converted.array();
            bytesRead = converted.limit();
            int start = converted.position();
            if (bytesRead <= 0) continue;
            if (ClientLineEnding.CONVERT_TEXT) {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(sendBytes, 0, bytesRead);
                RpcLineEndFilterInputStream lineEndStream = new RpcLineEndFilterInputStream(byteStream, null);
                bytesRead = lineEndStream.read(sendBytes, 0, bytesRead);
            }
            byte[] dataBytes = new byte[bytesRead];
            System.arraycopy(sendBytes, start, dataBytes, 0, bytesRead);
            fileLength += (long)bytesRead;
            sendMap.clear();
            sendMap.put("data", dataBytes);
            sendMap.put("handle", handle);
            RpcPacket sendPacket = RpcPacket.constructRpcPacket(write, sendMap, null);
            connection.putRpcPacket(sendPacket);
            digester.update(dataBytes);
        }
        return fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult sendFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        block27: {
            cmdEnv.newHandler();
            String clientPath = (String)resultsMap.get("path");
            String type = (String)resultsMap.get("type");
            String perms = (String)resultsMap.get("perms");
            String handle = (String)resultsMap.get("handle");
            String open = (String)resultsMap.get("open");
            String write = (String)resultsMap.get("write");
            String confirm = (String)resultsMap.get("confirm");
            String decline = (String)resultsMap.get("decline");
            String serverDigest = (String)resultsMap.get("serverDigest");
            String revertUnchanged = (String)resultsMap.get("revertUnchanged");
            String reopen = (String)resultsMap.get("reopen");
            RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(type);
            CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
            if (handler == null) {
                CommandEnv commandEnv = cmdEnv;
                commandEnv.getClass();
                handler = commandEnv.new CommandEnv.RpcHandler(handle, false, null);
                cmdEnv.addHandler(handler);
            }
            RpcPerforceFile file = null;
            InputStream inStream = null;
            MD5Digester digester = null;
            long fileLength = 0L;
            long modTime = 0L;
            file = new RpcPerforceFile(clientPath, fileType);
            modTime = file.lastModified();
            if (!handler.isError()) {
                HashMap<String, Object> respMap = new HashMap<String, Object>();
                for (String key : resultsMap.keySet()) {
                    if (key == null || key.equalsIgnoreCase("func")) continue;
                    respMap.put(key, resultsMap.get(key));
                }
                RpcPacket respPacket = RpcPacket.constructRpcPacket(open, respMap, null);
                rpcConnection.putRpcPacket(respPacket);
                if (!file.exists()) {
                    handler.setError(true);
                    cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.OS_FILE_READ_ERROR, 1, 34, new String[]{"open for read", clientPath + ": No such file or directory"}).toMap());
                } else {
                    digester = new MD5Digester();
                    Charset charset = null;
                    if (RpcPerforceFileType.FST_UTF16 == fileType) {
                        charset = CharsetDefs.UTF16;
                    } else if (RpcPerforceFileType.FST_UNICODE == fileType) {
                        charset = rpcConnection.getClientCharset();
                    }
                    if (charset == null || charset.equals(CharsetDefs.DEFAULT) || charset.equals(CharsetDefs.UTF8)) {
                        inStream = new RpcInputStream(file);
                        fileLength = this.sendRaw(inStream, rpcConnection, handle, write, digester);
                    } else {
                        inStream = new FileInputStream(file);
                        fileLength = this.sendConverted(charset, inStream, rpcConnection, handle, write, digester);
                    }
                    if (!handler.isError() && perms != null && reopen == null) {
                        if (perms.equalsIgnoreCase("rw")) {
                            this.fileCommands.setWritable(clientPath, true);
                        } else {
                            this.fileCommands.setWritable(clientPath, false);
                        }
                    }
                }
            }
            String finalise = handler.isError() ? decline : confirm;
            HashMap<String, Object> finaliseMap = new HashMap<String, Object>();
            for (String key : resultsMap.keySet()) {
                if (key == null || key.equalsIgnoreCase("func")) continue;
                finaliseMap.put(key, resultsMap.get(key));
            }
            if (digester != null) {
                finaliseMap.put("digest", digester.digestAs32ByteHex());
                finaliseMap.put("fileSize", "" + fileLength);
                if (modTime != 0L) {
                    finaliseMap.put("time", "" + modTime / 1000L);
                }
            }
            RpcPacket finalisePacket = RpcPacket.constructRpcPacket(finalise, finaliseMap, null);
            rpcConnection.putRpcPacket(finalisePacket);
            handler.setError(false);
            Object var29_27 = null;
            try {
                if (inStream != null) {
                    inStream.close();
                }
                break block27;
            }
            catch (IOException exc2) {
                Log.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc2.getLocalizedMessage());
            }
            break block27;
            {
                catch (Exception exc) {
                    Log.exception(exc);
                    handler.setError(true);
                    cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_SEND_ERROR, 3, 34, new String[]{clientPath, exc.getLocalizedMessage()}).toMap());
                    Object var29_28 = null;
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                        break block27;
                    }
                    catch (IOException exc2) {
                        Log.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc2.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var29_29 = null;
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException exc2) {
                    Log.warn("Unexpected exception on send file close; file: '" + clientPath + "'; message: " + exc2.getLocalizedMessage());
                }
                throw throwable;
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }
}

