/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server;

import com.perforce.p4java.Log;
import com.perforce.p4java.PropertyDefs;
import com.perforce.p4java.admin.IDbSchema;
import com.perforce.p4java.admin.IProtectionEntry;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.ILabelSummary;
import com.perforce.p4java.core.IServerProcess;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.core.IUserSummary;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.FileStatAncilliaryOptions;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileAnnotation;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.admin.DbSchema;
import com.perforce.p4java.impl.generic.admin.ProtectionEntry;
import com.perforce.p4java.impl.generic.core.BranchSpec;
import com.perforce.p4java.impl.generic.core.BranchSpecSummary;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.ChangelistSummary;
import com.perforce.p4java.impl.generic.core.Depot;
import com.perforce.p4java.impl.generic.core.Fix;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.p4java.impl.generic.core.JobSpec;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.impl.generic.core.LabelSummary;
import com.perforce.p4java.impl.generic.core.ServerProcess;
import com.perforce.p4java.impl.generic.core.User;
import com.perforce.p4java.impl.generic.core.UserGroup;
import com.perforce.p4java.impl.generic.core.UserSummary;
import com.perforce.p4java.impl.generic.core.file.ExtendedFileSpec;
import com.perforce.p4java.impl.generic.core.file.FileAnnotation;
import com.perforce.p4java.impl.generic.core.file.FileRevisionData;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.impl.mapbased.client.ClientSummary;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.server.IServerControl;
import com.perforce.p4java.impl.mapbased.server.ServerInfo;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.p4java.server.ServerStatus;
import com.perforce.p4java.server.callback.ICommandCallback;
import com.perforce.p4java.server.callback.IProgressCallback;
import com.perforce.p4java.server.callback.ISSOCallback;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Server
implements IServer,
IServerControl {
    public static final String SCREEN_NAME_FIELD_NAME = "SCREEN_NAME";
    public static final String IMPL_COMMENTS_FIELD_NAME = "IMPL_COMMENTS";
    public static final String IMPL_TYPE_FIELD_NAME = "IMPL_TYPE";
    public static final String MINIMUM_SUPPORTED_SERVER_LEVEL_FIELD_NAME = "MINIMUM_SUPPORTED_SERVER_LEVEL";
    public static final String PROTOCOL_NAME_FIELD_NAME = "PROTOCOL_NAME";
    public static final String DEFAULT_STATUS_FIELD_NAME = "DEFAULT_STATUS";
    protected static final String CORE_AUTH_FAIL_STRING_1 = "Perforce password (P4PASSWD)";
    protected static final String CORE_AUTH_FAIL_STRING_2 = "Access for user";
    protected static final String CORE_AUTH_FAIL_STRING_3 = "Your session has expired";
    protected static final String CORE_AUTH_FAIL_STRING_4 = "Your session was logged out";
    public static final String P4TICKETS_ENV_VAR = "P4TICKETS";
    public static final String P4TICKETS_DEFAULT_WINDOWS = "p4tickets.txt";
    public static final String P4TICKETS_DEFAULT_OTHER = ".p4tickets";
    protected static final int UNKNOWN_SERVER_VERSION = -1;
    protected static final String UNKNOWN_SERVER_HOST = null;
    protected static final int UNKNOWN_SERVER_PORT = -1;
    protected ServerStatus status = ServerStatus.UNKNOWN;
    protected Properties props = null;
    protected boolean caseSensitive = true;
    protected int serverVersion = -1;
    protected String serverHost = UNKNOWN_SERVER_HOST;
    protected int serverPort = -1;
    protected String userName = null;
    protected String password = null;
    protected String authTicket = null;
    protected IClient client = null;
    protected String clientName = null;
    protected String clientUnsetName = "noclient";
    protected String progName = "Unknown P4Java program";
    protected String progVersion = PropertyDefs.PROG_VERSION_DEFAULT;
    protected boolean setupOnConnect = false;
    protected boolean loginOnConnect = false;
    protected ICommandCallback commandCallback = null;
    protected IProgressCallback progressCallback = null;
    protected ISSOCallback ssoCallback = null;
    protected String ssoKey = null;
    protected String charsetName = null;
    protected Charset charset = null;
    protected boolean connected = false;
    protected int minumumSupportedServerVersion = 20052;
    protected String tmpDirName = null;
    protected String workingDirectoryPath = null;
    protected AtomicInteger nextCmdCallBackKey = new AtomicInteger();
    protected AtomicInteger nextProgressCallbackKey = new AtomicInteger();
    protected static boolean isRunningOnWindows = false;

    @Override
    public ICommandCallback registerCallback(ICommandCallback callback) {
        ICommandCallback oldCallback = this.commandCallback;
        this.commandCallback = callback;
        return oldCallback;
    }

    @Override
    public IProgressCallback registerProgressCallback(IProgressCallback progressCallback) {
        IProgressCallback oldCallback = this.progressCallback;
        this.progressCallback = progressCallback;
        return oldCallback;
    }

    @Override
    public ISSOCallback registerSSOCallback(ISSOCallback callback, String ssoKey) {
        ISSOCallback oldCallback = this.ssoCallback;
        this.ssoCallback = callback;
        this.ssoKey = ssoKey;
        return oldCallback;
    }

    @Override
    public ServerStatus getStatus() {
        return this.status;
    }

    @Override
    public int getServerVersionNumber() {
        return this.serverVersion;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setCharsetName(String charsetName) throws UnsupportedCharsetException {
        if (charsetName != null && !PerforceCharsets.isSupported(charsetName)) {
            throw new UnsupportedCharsetException(charsetName);
        }
        this.charsetName = charsetName;
        if (this.charsetName != null) {
            if (!Charset.isSupported(charsetName = PerforceCharsets.getJavaCharsetName(charsetName))) return false;
            this.charset = Charset.forName(charsetName);
            return true;
        } else {
            this.charset = null;
        }
        return true;
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public boolean supportsUnicode() throws ConnectionException, RequestException, AccessException {
        IServerInfo info = this.getServerInfo();
        if (info != null) {
            return info.isUnicodeEnabled();
        }
        return false;
    }

    @Override
    public String[] getKnownCharsets() {
        return PerforceCharsets.getKnownCharsets();
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        this.serverHost = host;
        this.serverPort = port;
        this.props = props != null ? props : new Properties();
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir"));
        if (this.tmpDirName == null) {
            this.tmpDirName = "/tmp";
            Log.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead");
        }
        this.progName = this.userName = this.props.getProperty("programName", this.props.getProperty("com.perforce.p4java.programName", "Unknown P4Java program"));
        this.progVersion = this.userName = this.props.getProperty("programVersion", this.props.getProperty("com.perforce.p4java.programVersion", PropertyDefs.PROG_VERSION_DEFAULT));
        Log.info("Using program name: '" + this.progName + "'; progam version: '" + this.progVersion + "'");
        Log.info("Using tmp file directory: " + this.tmpDirName);
        this.userName = this.props.getProperty("userName", this.props.getProperty("com.perforce.p4java.userName", null));
        this.password = this.props.getProperty("password", this.props.getProperty("com.perforce.p4java.password", null));
        this.clientName = this.props.getProperty("clientName", this.props.getProperty("com.perforce.p4java.clientName", null));
        this.clientUnsetName = this.props.getProperty("com.perforce.p4java.unsetClientName", "noclient");
        this.setupOnConnect = this.props.getProperty("autoConnect", this.props.getProperty("com.perforce.p4java.autoConnect", null)) != null;
        this.loginOnConnect = this.props.getProperty("autoLogin", this.props.getProperty("com.perforce.p4java.autoLogin", null)) != null;
        return this.status;
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.connected = true;
        this.status = ServerStatus.READY;
        Log.info("connected to Perforce server at " + this.serverHost + ":" + this.serverPort);
        int serverVersion = this.getServerVersion();
        if (serverVersion == -1) {
            throw new ConnectionException("Unable to determine Perforce server version for connection; check network connection, connection character set setting, and / or server status");
        }
        if (serverVersion < this.minumumSupportedServerVersion) {
            throw new ConnectionException("Attempted to connect to an unsupported Perforce server version; target server version: " + serverVersion + "; minimum supported version: " + this.minumumSupportedServerVersion);
        }
        if (this.loginOnConnect && this.userName != null && this.password != null) {
            this.login(this.password);
        }
        if (this.setupOnConnect && this.clientName != null) {
            this.client = this.getClient(this.clientName);
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        this.connected = false;
        this.status = ServerStatus.DISCONNECTED;
        Log.info("disconnected from Perforce server at " + this.serverHost + ":" + this.serverPort);
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setAuthTicket(String authTicket) {
        this.authTicket = authTicket;
    }

    @Override
    public String getAuthTicket() {
        return this.authTicket;
    }

    @Override
    public IServerInfo getServerInfo() throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.INFO, new String[0], null);
        if (resultsMap != null && resultsMap.length > 0) {
            return new ServerInfo(resultsMap[0]);
        }
        return new ServerInfo();
    }

    @Override
    public void login(String password) throws ConnectionException, RequestException, AccessException, ConfigException {
        this.login(password, false);
    }

    @Override
    public void login(String password, boolean allHosts) throws ConnectionException, RequestException, AccessException, ConfigException {
        if (password != null) {
            password = password + "\n";
        }
        int argCount = 0;
        if (allHosts) {
            ++argCount;
        }
        String[] args = new String[argCount];
        if (allHosts) {
            args[0] = "-a";
        }
        HashMap<String, Object> pwdMap = new HashMap<String, Object>();
        pwdMap.put("password", password);
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.LOGIN, args, pwdMap);
        if (resultsMap[0] != null) {
            this.handleErrorStr(resultsMap[0]);
        }
    }

    @Override
    public void logout() throws ConnectionException, RequestException, AccessException, ConfigException {
        if (this.authTicket == null) {
            return;
        }
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.LOGOUT, new String[0], null);
        this.authTicket = null;
    }

    @Override
    public List<IClientSummary> getClients(String userName, String queryString, int maxResults) throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap;
        int argCount = 0;
        if (maxResults > 0) {
            ++argCount;
        }
        String[] args = null;
        if (userName != null) {
            ++argCount;
        }
        if (queryString != null) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (userName != null) {
            if (this.getServerVersion() >= 20062) {
                args[i++] = "-u" + userName;
            } else {
                throw new RequestException("user restrictions for client lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (queryString != null) {
            if (this.getServerVersion() >= 20081) {
                args[i++] = "-e" + queryString;
            } else {
                throw new RequestException("query expressions for client lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (maxResults > 0) {
            if (this.getServerVersion() >= 20061) {
                args[i++] = "-m" + maxResults;
            } else {
                throw new RequestException("user restrictions for client lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if ((resultsMap = this.execMapCmd(CmdSpec.CLIENTS, args, null)) == null) {
            throw new P4JavaError("Null resultsMap in getClientList call");
        }
        ArrayList<IClientSummary> specList = new ArrayList<IClientSummary>();
        for (Map<String, Object> map : resultsMap) {
            String errStr = this.getErrorStr(map);
            if (errStr != null) {
                throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
            }
            specList.add(new ClientSummary(map, true));
        }
        return specList;
    }

    @Override
    public List<ILabelSummary> getLabels(String user, int maxLabels, String nameFilter, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        String[] args = null;
        if (user != null) {
            ++argCount;
        }
        if (maxLabels > 0) {
            ++argCount;
        }
        if (nameFilter != null) {
            ++argCount;
        }
        if (fileList != null) {
            argCount += fileList.size();
        }
        args = new String[argCount];
        int i = 0;
        if (user != null) {
            if (this.getServerVersion() >= 20062) {
                args[i++] = "-u" + user;
            } else {
                throw new RequestException("user restrictions for label lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (maxLabels > 0) {
            if (this.getServerVersion() >= 20061) {
                args[i++] = "-m" + maxLabels;
            } else {
                throw new RequestException("max limit for label lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (nameFilter != null) {
            if (this.getServerVersion() >= 20081) {
                args[i++] = "-e" + nameFilter;
            } else {
                throw new RequestException("query expressions for label lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        Map<String, Object>[] resultsMaps = this.execMapCmd(CmdSpec.LABELS, Server.populatePathArray(args, i, fileList), null);
        ArrayList<ILabelSummary> labelList = new ArrayList<ILabelSummary>();
        if (resultsMaps != null) {
            for (Map<String, Object> map : resultsMaps) {
                if (map == null || this.handleErrorStr(map)) continue;
                labelList.add(new LabelSummary(map));
            }
        }
        return labelList;
    }

    @Override
    public ILabel getLabel(String labelName) throws ConnectionException, RequestException, AccessException {
        if (labelName == null) {
            throw new NullPointerError("Null label name passed to ServerImpl.labelName");
        }
        String OFLAG = "-o";
        Map<String, Object>[] resultsMaps = this.execMapCmd(CmdSpec.LABEL, new String[]{"-o", labelName}, null);
        Label label = null;
        if (resultsMaps == null) {
            Log.warn("Unexpected null map array returned to ServerImpl.getLabel()");
        } else {
            for (Map<String, Object> map : resultsMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                label = new Label(map, this);
            }
        }
        return label;
    }

    @Override
    public String createLabel(ILabel label) throws ConnectionException, RequestException, AccessException {
        if (label == null) {
            throw new NullPointerError("null label passed to ServerImpl.newLabel()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.LABEL, new String[]{"-i"}, InputMapper.map(label));
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.newLabel");
        }
        return retStr;
    }

    @Override
    public String deleteLabel(String labelName, boolean force) throws ConnectionException, RequestException, AccessException {
        if (labelName == null) {
            throw new NullPointerError("null label name passed to Server.deleteLabel()");
        }
        String[] args = null;
        args = force ? new String[]{"-d", "-f", labelName} : new String[]{"-d", labelName};
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.LABEL, args, null);
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteLabel");
        }
        return retStr;
    }

    @Override
    public String updateLabel(ILabel label) throws ConnectionException, RequestException, AccessException {
        if (label == null) {
            throw new NullPointerError("null label passed to ServerImpl.updateLabel()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.LABEL, new String[]{"-i"}, InputMapper.map(label));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.updateLabel");
        }
        return retVal;
    }

    @Override
    public List<IFileSpec> getDepotFiles(List<IFileSpec> fileSpecs, boolean allRevs) throws ConnectionException, AccessException {
        if (fileSpecs == null) {
            throw new NullPointerError("Null file specification list passed to getDepotFiles");
        }
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        String[] args = allRevs ? Server.getPreferredPathArray(new String[]{"-a"}, fileSpecs) : Server.getPreferredPathArray(null, fileSpecs);
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.FILES, args, null);
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                fileList.add(this.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public List<IFileAnnotation> getFileAnnotations(List<IFileSpec> fileSpecs, DiffType wsOpts, boolean allResults, boolean useChangeNumbers, boolean followBranches) throws ConnectionException, RequestException, AccessException {
        if (wsOpts != null && !wsOpts.isWsOption()) {
            throw new RequestException("Bad whitespace option in getFileAnnotations");
        }
        int argCount = 0;
        if (allResults) {
            ++argCount;
        }
        if (useChangeNumbers) {
            ++argCount;
        }
        if (followBranches) {
            ++argCount;
        }
        if (wsOpts != null) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (allResults) {
            args[i++] = "-a";
        }
        if (useChangeNumbers) {
            args[i++] = "-c";
        }
        if (followBranches) {
            args[i++] = "-i";
        }
        if (wsOpts != null) {
            args[i++] = "-d" + wsOpts.toArgString();
        }
        ArrayList<IFileAnnotation> returnList = new ArrayList<IFileAnnotation>();
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.ANNOTATE, Server.getPreferredPathArray(args, fileSpecs), null);
        if (retMaps != null) {
            String depotFile = null;
            for (Map<String, Object> map : retMaps) {
                if (map == null) continue;
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                if (map.containsKey("depotFile")) {
                    depotFile = (String)map.get("depotFile");
                    continue;
                }
                returnList.add(new FileAnnotation(map, depotFile, this.client == null ? null : this.client.getLineEnd()));
            }
        }
        return returnList;
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, boolean listOnly, boolean delete) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        String[] args = null;
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        if (labelName != null) {
            ++argCount;
        }
        if (listOnly) {
            ++argCount;
        }
        if (delete) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (listOnly) {
            args[i++] = "-n";
        }
        if (delete) {
            args[i++] = "-d";
        }
        if (labelName != null) {
            args[i++] = "-l" + labelName;
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.TAG, Server.getPreferredPathArray(args, fileSpecs), null);
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                fileList.add(this.handleFileReturn(map));
            }
        } else {
            Log.warn("null return map array in ServerImpl.tagFiles");
        }
        return fileList;
    }

    @Override
    public List<IUserSummary> getReviews(int changelistId, List<IFileSpec> fileSpecs) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (changelistId > 0 || changelistId == 0) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (changelistId > 0) {
            args[i++] = "-c" + changelistId;
        } else if (changelistId == 0) {
            args[i++] = "-cdefault";
        }
        ArrayList<IUserSummary> userList = new ArrayList<IUserSummary>();
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.REVIEWS, Server.getPreferredPathArray(args, fileSpecs), null);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                try {
                    userList.add(new UserSummary((String)map.get("user"), (String)map.get("email"), (String)map.get("name"), null, null));
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in getReviews: " + thr.getLocalizedMessage());
                    Log.exception(thr);
                }
            }
        }
        return userList;
    }

    @Override
    public List<IFileSpec> moveFile(int changeListId, boolean listOnly, boolean noClientMove, String fileType, IFileSpec fromFile, IFileSpec toFile) throws ConnectionException, RequestException, AccessException {
        int MIN_SUPPORTED_SERVER = 20091;
        int MIN_SUPPORTED_SERVER_OPTION_K = 20092;
        if (this.serverVersion < 20091) {
            throw new RequestException("command requires a Perforce server version 2009.1 or later");
        }
        if (fromFile == null || toFile == null) {
            throw new RequestException("command requires both to and from files to be specified");
        }
        if (this.serverVersion < 20092 && noClientMove) {
            throw new RequestException("command option noClientMove requires a Perforce server version 2009.2 or later");
        }
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        int argCount = 0;
        String[] args = null;
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (listOnly) {
            ++argCount;
        }
        if (noClientMove) {
            ++argCount;
        }
        if (fileType != null) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        } else if (changeListId == 0) {
            args[i++] = "-cdefault";
        }
        if (listOnly) {
            args[i++] = "-n";
        }
        if (noClientMove) {
            args[i++] = "-k";
        }
        if (fileType != null) {
            args[i++] = "-i" + fileType;
        }
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        try {
            FileSpec fromSpec = new FileSpec(fromFile.getPreferredPath().toString());
            FileSpec toSpec = new FileSpec(toFile.getPreferredPath().toString());
            specList.add(fromSpec);
            specList.add(toSpec);
        }
        catch (ClassCastException cce) {
            Log.error("Class cast error in FileSpec.move(): " + cce.getLocalizedMessage());
            Log.exception(cce);
            throw new P4JavaError("Class cast error in FileSpec.move(): " + cce.getLocalizedMessage(), cce);
        }
        Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.MOVE, Server.getPreferredPathArray(args, specList), null);
        if (resultsArray != null) {
            for (Map<String, Object> map : resultsArray) {
                fileList.add(this.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public IUser getUser(String userName) throws ConnectionException, RequestException, AccessException {
        String[] args = null;
        args = userName == null ? new String[]{"-o"} : new String[]{"-o", userName};
        Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.USER, args, null);
        if (resultsArray != null) {
            for (Map<String, Object> map : resultsArray) {
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                return new User(map, this);
            }
        }
        return null;
    }

    @Override
    public String createUser(IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        if (user == null) {
            throw new NullPointerError("Null user passed to IServer.createUser");
        }
        return this.updateUser(user, force);
    }

    @Override
    public String updateUser(IUser user, boolean force) throws ConnectionException, RequestException, AccessException {
        if (user == null) {
            throw new NullPointerError("Null user passed to IServer.updateUser");
        }
        if (user.getLoginName() == null) {
            throw new NullPointerError("Null user name in user passed to IServer.updateUser");
        }
        String[] args = null;
        args = force ? new String[]{"-i", "-f"} : new String[]{"-i"};
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.USER, args, InputMapper.map(user));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.updateUser");
        }
        return retVal;
    }

    @Override
    public String deleteUser(String userName, boolean force) throws ConnectionException, RequestException, AccessException {
        if (userName == null) {
            throw new NullPointerError("Null user name passed to IServer.deleteUser");
        }
        String[] args = null;
        args = force ? new String[]{"-d", "-f", userName} : new String[]{"-d", userName};
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.USER, args, null);
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteUser");
        }
        return retStr;
    }

    @Override
    public List<IUserSummary> getUsers(List<String> userList, int maxUsers) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        String[] args = null;
        if (maxUsers > 0) {
            ++argCount;
        }
        if (userList != null) {
            argCount += userList.size();
        }
        args = new String[argCount];
        int i = 0;
        if (userList != null) {
            for (String user : userList) {
                args[i++] = user;
            }
        }
        if (maxUsers > 0) {
            args[i] = "-m" + maxUsers;
        }
        ArrayList<IUserSummary> resultsList = new ArrayList<IUserSummary>();
        Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.USERS, args, null);
        if (resultsArray != null) {
            for (Map<String, Object> map : resultsArray) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) continue;
                resultsList.add(new UserSummary(map, true));
            }
        }
        return resultsList;
    }

    @Override
    public List<IUserGroup> getUserGroups(String userOrGroupName, boolean indirect, boolean displayValues, int maxGroups) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        String[] args = null;
        if (maxGroups > 0) {
            ++argCount;
        }
        if (indirect) {
            ++argCount;
        }
        if (displayValues) {
            ++argCount;
        }
        if (userOrGroupName != null) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (maxGroups > 0) {
            args[i++] = "-m" + maxGroups;
        }
        if (indirect) {
            args[i++] = "-i";
        }
        if (displayValues) {
            args[i++] = "-v";
        }
        if (userOrGroupName != null) {
            args[i++] = userOrGroupName;
        }
        ArrayList<IUserGroup> resultsList = new ArrayList<IUserGroup>();
        Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.GROUPS, args, null);
        if (resultsArray != null) {
            UserGroup ugImpl = null;
            ArrayList<String> userList = null;
            for (Map<String, Object> map : resultsArray) {
                this.handleErrorStr(map);
                String groupName = (String)map.get("group");
                if (groupName == null) continue;
                if (ugImpl == null) {
                    ugImpl = new UserGroup();
                    userList = new ArrayList<String>();
                    ugImpl.setName(groupName);
                } else if (!ugImpl.getName().equals(groupName)) {
                    ugImpl.setUsers(userList);
                    resultsList.add(ugImpl);
                    ugImpl = new UserGroup();
                    ugImpl.setName(groupName);
                    userList = new ArrayList();
                    ugImpl.setUsers(userList);
                }
                try {
                    String isSubGroup;
                    String userName = (String)map.get("user");
                    String maxScanRows = (String)map.get("maxScanRows");
                    String maxLockTime = (String)map.get("maxLockTime");
                    String timeout = (String)map.get("timeout");
                    String maxResults = (String)map.get("maxResults");
                    userList.add(userName);
                    String isOwner = (String)map.get("isOwner");
                    if (isOwner != null && isOwner.equalsIgnoreCase("1") && ugImpl.getOwners() == null) {
                        ugImpl.setOwners(new ArrayList<String>());
                        ugImpl.getOwners().add(userName);
                    }
                    if ((isSubGroup = (String)map.get("isSubGroup")) != null && isSubGroup.equals("1")) {
                        ugImpl.setSubGroup(true);
                    }
                    if (maxScanRows != null) {
                        ugImpl.setMaxScanRows(new Integer(maxScanRows));
                    }
                    if (maxLockTime != null) {
                        ugImpl.setMaxLockTime(new Integer(maxLockTime));
                    }
                    if (timeout != null) {
                        ugImpl.setTimeout(new Integer(timeout));
                    }
                    if (maxResults == null) continue;
                    ugImpl.setMaxResults(new Integer(maxResults));
                }
                catch (Throwable thr) {
                    Log.warn("Unexpected exception in ServerImpl.getUserGroupList: " + thr.getMessage());
                    Log.exception(thr);
                }
            }
            if (ugImpl != null) {
                ugImpl.setUsers(userList);
                resultsList.add(ugImpl);
            }
        }
        return resultsList;
    }

    @Override
    public IUserGroup getUserGroup(String name) throws ConnectionException, RequestException, AccessException {
        UserGroup ugImpl;
        block1: {
            Map<String, Object>[] arr$;
            int len$;
            int i$;
            if (name == null) {
                throw new NullPointerError("null group name passed to Server.getUserGroup");
            }
            Map<String, Object>[] resultsArray = this.execMapCmd(CmdSpec.GROUP, new String[]{"-o", name}, null);
            ugImpl = null;
            if (resultsArray == null || (i$ = 0) >= (len$ = (arr$ = resultsArray).length)) break block1;
            Map<String, Object> map = arr$[i$];
            this.handleErrorStr(map);
            ugImpl = new UserGroup(map);
        }
        return ugImpl;
    }

    @Override
    public String createUserGroup(IUserGroup group) throws ConnectionException, RequestException, AccessException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.createUserGroup method");
        }
        return this.updateUserGroup(group, false);
    }

    @Override
    public String updateUserGroup(IUserGroup group, boolean updateIfOwner) throws ConnectionException, RequestException, AccessException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.updateUserGroup method");
        }
        String[] args = null;
        args = updateIfOwner ? new String[]{"-i", "-a"} : new String[]{"-i"};
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.GROUP, args, InputMapper.map(group));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.updateUserGroup");
        }
        return retVal;
    }

    @Override
    public String deleteUserGroup(IUserGroup group) throws ConnectionException, RequestException, AccessException {
        if (group == null) {
            throw new NullPointerError("Null group passed to IServer.deleteUserGroup method");
        }
        if (group.getName() == null) {
            throw new NullPointerError("Null group name in user group passed to IServer.deleteUserGroup method");
        }
        String[] args = new String[]{"-d", group.getName()};
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.GROUP, args, null);
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in Server.deleteUserGroup");
        }
        return retVal;
    }

    @Override
    public List<IProtectionEntry> getProtectionEntries(boolean allUsers, String hostName, String userName, String groupName, List<IFileSpec> fileList) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (allUsers) {
            ++argCount;
        }
        if (hostName != null) {
            ++argCount;
        }
        if (userName != null) {
            ++argCount;
        }
        if (groupName != null) {
            ++argCount;
        }
        if (fileList != null) {
            argCount += fileList.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (allUsers) {
            args[i++] = "-a";
        }
        if (hostName != null) {
            args[i++] = "-h" + hostName;
        }
        if (userName != null) {
            args[i++] = "-u" + userName;
        }
        if (groupName != null) {
            args[i++] = "-g" + groupName;
        }
        ArrayList<IProtectionEntry> protectsList = new ArrayList<IProtectionEntry>();
        Map<String, Object>[] protectsMaps = this.execMapCmd(CmdSpec.PROTECTS, Server.getPreferredPathArray(args, fileList, false), null);
        if (protectsMaps != null) {
            int order = 0;
            for (Map<String, Object> map : protectsMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                protectsList.add(new ProtectionEntry(map, order++));
            }
        }
        return protectsList;
    }

    @Override
    public List<IBranchSpecSummary> getBranchSpecs(String userName, String nameFilter, int maxReturns) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        String[] args = null;
        if (userName != null) {
            ++argCount;
        }
        if (nameFilter != null) {
            ++argCount;
        }
        if (maxReturns > 0) {
            ++argCount;
        }
        args = new String[argCount];
        int arg = 0;
        if (userName != null) {
            if (this.getServerVersion() >= 20062) {
                args[arg++] = "-u" + userName;
            } else {
                throw new RequestException("user restrictions for branch lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (nameFilter != null) {
            if (this.getServerVersion() >= 20081) {
                args[arg++] = "-e" + nameFilter;
            } else {
                throw new RequestException("query expressions for branch lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        if (maxReturns > 0) {
            if (this.getServerVersion() >= 20061) {
                args[arg++] = "-m" + maxReturns;
            } else {
                throw new RequestException("max limit for branch lists are not supported by this version of the Perforce server", 37, 3);
            }
        }
        ArrayList<IBranchSpecSummary> branchList = new ArrayList<IBranchSpecSummary>();
        Map<String, Object>[] branchMaps = this.execMapCmd(CmdSpec.BRANCHES, args, null);
        if (branchMaps != null) {
            for (Map<String, Object> branchMap : branchMaps) {
                this.handleErrorStr(branchMap);
                branchList.add(new BranchSpecSummary(branchMap, true));
            }
        }
        return branchList;
    }

    @Override
    public IBranchSpec getBranchSpec(String name) throws ConnectionException, RequestException, AccessException {
        if (name == null) {
            throw new NullPointerError("Null branch spec name passed to getBranchSpec");
        }
        BranchSpec branchSpec = null;
        Map<String, Object>[] branchMaps = this.execMapCmd(CmdSpec.BRANCH, new String[]{"-o", name}, null);
        if (branchMaps != null) {
            for (Map<String, Object> map : branchMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                branchSpec = new BranchSpec(map, this);
            }
        }
        return branchSpec;
    }

    @Override
    public String createBranchSpec(IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        if (branchSpec == null) {
            throw new NullPointerError("null branch spec passed to ServerImpl.newBranchSpec()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.BRANCH, new String[]{"-i"}, InputMapper.map(branchSpec));
        String retStr = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retStr = retStr == null ? this.getInfoStr(map) : retStr + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.newBranchSpec");
        }
        return retStr;
    }

    @Override
    public String updateBranchSpec(IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        if (branchSpec == null) {
            throw new NullPointerError("null label passed to ServerImpl.updateBranchSpec()");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.BRANCH, new String[]{"-i"}, InputMapper.map(branchSpec));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.updateBranchSpec");
        }
        return retVal;
    }

    @Override
    public String deleteBranchSpec(String branchSpecName, boolean force) throws ConnectionException, RequestException, AccessException {
        if (branchSpecName == null) {
            throw new NullPointerError("Null branch spec name passed to IServer.deleteBranchSpec method");
        }
        String[] args = null;
        args = force ? new String[]{"-d", "-f", branchSpecName} : new String[]{"-d", branchSpecName};
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.BRANCH, args, null);
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        } else {
            Log.warn("null return map array in ServerImpl.deleteBranchSpec");
        }
        return retVal;
    }

    @Override
    public IClient getCurrentClient() {
        return this.client;
    }

    @Override
    public void setCurrentClient(IClient client) {
        this.client = client;
        this.clientName = this.client != null && client != null ? this.client.getName() : null;
    }

    @Override
    public IClient getClient(String clientName) throws ConnectionException, RequestException, AccessException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to IServer.getClient()");
        }
        String[] args = new String[]{"-o", clientName};
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CLIENT, args, null);
        Client client = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map) || !map.containsKey("Update") && !map.containsKey("Access")) continue;
                client = new Client(this, map);
            }
        }
        return client;
    }

    @Override
    public IClient getClient(IClientSummary clientSummary) throws ConnectionException, RequestException, AccessException {
        if (clientSummary == null) {
            throw new NullPointerError("Null client summary passed to IServer.getClient()");
        }
        return this.getClient(clientSummary.getName());
    }

    @Override
    public IClient getClientTemplate(String clientName, boolean allowExistent) throws ConnectionException, RequestException, AccessException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to IServer.getClient()");
        }
        String[] args = new String[]{"-o", clientName};
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CLIENT, args, null);
        Client client = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                boolean nonExistent;
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                boolean bl = nonExistent = !map.containsKey("Update") && !map.containsKey("Access");
                if (!allowExistent && !nonExistent) continue;
                client = new Client(this, map);
            }
        }
        return client;
    }

    @Override
    public IClient getClientTemplate(String clientName) throws ConnectionException, RequestException, AccessException {
        return this.getClientTemplate(clientName, false);
    }

    @Override
    public String createClient(IClient newClient) throws ConnectionException, RequestException, AccessException {
        if (newClient == null) {
            throw new NullPointerError("Null new client spec in newClient method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.CLIENT, new String[]{"-i"}, InputMapper.map(newClient));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String updateClient(IClient client) throws ConnectionException, RequestException, AccessException {
        if (client == null) {
            throw new NullPointerError("Null client in IServer.updateClient method");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.CLIENT, new String[]{"-i"}, InputMapper.map(client));
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String deleteClient(String clientName, boolean force) throws ConnectionException, RequestException, AccessException {
        if (clientName == null) {
            throw new NullPointerError("Null client name passed to ServerImpl.deleteClient");
        }
        String[] args = null;
        args = force ? new String[]{"-d", "-f", clientName} : new String[]{"-d", clientName};
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.CLIENT, args, null);
        String retVal = null;
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IDepot> getDepots() throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap;
        ArrayList<IDepot> metadataArray = new ArrayList<IDepot>();
        for (Map<String, Object> map : resultsMap = this.execMapCmd(CmdSpec.DEPOTS, new String[0], null)) {
            if (this.handleErrorStr(map)) continue;
            try {
                metadataArray.add(new Depot(map));
            }
            catch (Exception exc) {
                Log.exception(exc);
                throw new P4JavaError("Unexpected conversion error in getDepotList: " + exc.getLocalizedMessage(), exc);
            }
        }
        return metadataArray;
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, IChangelist.Type type, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap;
        Vector<String> argVec = new Vector<String>();
        String[] argStrings = null;
        ArrayList<IChangelistSummary> changeListList = new ArrayList<IChangelistSummary>();
        if (maxMostRecent > 0) {
            argVec.add("-m" + maxMostRecent);
        }
        if (clientName != null) {
            argVec.add("-c" + clientName);
        }
        if (userName != null) {
            argVec.add("-u" + userName);
        }
        if (includeIntegrated) {
            argVec.add("-i");
        }
        if (type != null) {
            argVec.add("-s" + type.toString());
        }
        if (longDesc) {
            argVec.add("-l");
        }
        if (fileSpecs != null) {
            for (IFileSpec fSpec : fileSpecs) {
                argVec.add(fSpec.getAnnotatedPreferredPathString());
            }
        }
        if (argVec.size() > 0) {
            argStrings = new String[argVec.size()];
            int i = 0;
            for (String str : argVec) {
                argStrings[i++] = str;
            }
        } else {
            argStrings = new String[]{};
        }
        if ((resultsMap = this.execMapCmd(CmdSpec.CHANGES, argStrings, null)) != null) {
            for (Map<String, Object> result : resultsMap) {
                if (this.handleErrorStr(result)) continue;
                try {
                    changeListList.add(new ChangelistSummary(result, true));
                }
                catch (Exception exc) {
                    Log.exception(exc);
                    throw new P4JavaError("Unexpected conversion error in getChangelist: " + exc.getLocalizedMessage(), exc);
                }
            }
        }
        return changeListList;
    }

    @Override
    public List<IChangelistSummary> getChangelists(int maxMostRecent, List<IFileSpec> fileSpecs, String clientName, String userName, boolean includeIntegrated, boolean submittedOnly, boolean pendingOnly, boolean longDesc) throws ConnectionException, RequestException, AccessException {
        IChangelist.Type type = null;
        if (submittedOnly) {
            type = IChangelist.Type.SUBMITTED;
        } else if (pendingOnly) {
            type = IChangelist.Type.PENDING;
        }
        return this.getChangelists(maxMostRecent, fileSpecs, clientName, userName, includeIntegrated, type, longDesc);
    }

    @Override
    public IChangelist getChangelist(int id) throws ConnectionException, RequestException, AccessException {
        Changelist changeList = null;
        String[] args = null;
        args = id == 0 ? new String[]{"-o"} : new String[]{"-o", "" + id};
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CHANGE, args, null);
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                changeList = new Changelist(map, this);
            }
        }
        return changeList;
    }

    @Override
    public String deletePendingChangelist(int id) throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.CHANGE, new String[]{"-d", "" + id}, null);
        String retVal = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + " \n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public List<IFileSpec> getChangelistFiles(int id) throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.DESCRIBE, new String[]{"-s", "" + id}, null);
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (resultsMap != null && resultsMap.length > 0 && resultsMap[0] != null) {
            Map<String, Object> map = resultsMap[0];
            int i = 0;
            while (map.get("rev" + i) != null) {
                FileSpec fSpec = new FileSpec(map, this, i);
                fSpec.setChangelistId(id);
                fileList.add(fSpec);
                ++i;
            }
        }
        return fileList;
    }

    @Override
    public InputStream getChangelistDiffs(int id, DiffType diffType) throws ConnectionException, RequestException, AccessException {
        int argCount = 1;
        if (diffType != null) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int i = 0;
        if (diffType != null) {
            args[i++] = "-d" + diffType.toArgString();
        }
        args[i++] = "" + id;
        return this.execStreamCmd(CmdSpec.DESCRIBE, args);
    }

    @Override
    public Map<IFileSpec, List<IFileRevisionData>> getRevisionHistory(List<IFileSpec> fileSpecs, int maxRevs, boolean contentHistory, boolean includeInherited, boolean longOutput, boolean truncatedLongOutput) throws ConnectionException, AccessException {
        Map<String, Object>[] historyMap;
        int argCount = 0;
        String[] args = null;
        HashMap<IFileSpec, List<IFileRevisionData>> revMap = new HashMap<IFileSpec, List<IFileRevisionData>>();
        if (maxRevs > 0) {
            ++argCount;
        }
        if (contentHistory) {
            ++argCount;
        }
        if (includeInherited) {
            ++argCount;
        }
        if (longOutput) {
            ++argCount;
        }
        if (truncatedLongOutput) {
            ++argCount;
        }
        args = new String[argCount];
        int i = 0;
        if (maxRevs > 0) {
            args[i++] = "-m" + maxRevs;
        }
        if (contentHistory) {
            args[i++] = "-h";
        }
        if (includeInherited) {
            args[i++] = "-i";
        }
        if (longOutput) {
            args[i++] = "-l";
        }
        if (truncatedLongOutput) {
            args[i++] = "-L";
        }
        if ((historyMap = this.execMapCmd(CmdSpec.FILELOG, Server.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> result : historyMap) {
                String errStr = this.handleFileErrorStr(result);
                if (errStr != null) {
                    FileSpec fSpec = new FileSpec(FileSpecOpStatus.ERROR, errStr, this.getGenericCode(result), this.getSeverityCode(result));
                    String depotPath = (String)result.get("depotFile");
                    fSpec.setDepotPath(depotPath);
                    revMap.put(fSpec, null);
                    continue;
                }
                int revNum = 0;
                ArrayList<FileRevisionData> revList = new ArrayList<FileRevisionData>();
                String depotFilePath = (String)result.get("depotFile");
                FileSpec fSpec = new FileSpec();
                fSpec.setDepotPath(depotFilePath);
                revMap.put(fSpec, revList);
                while (result.get("rev" + revNum) != null) {
                    revList.add(new FileRevisionData(result, revNum));
                    ++revNum;
                }
            }
        }
        return revMap;
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, boolean allClients, String clientName, int maxFiles, int changeListId) throws ConnectionException, AccessException {
        Map<String, Object>[] openMap;
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        int argCount = 0;
        if (allClients) {
            ++argCount;
        }
        if (clientName != null) {
            ++argCount;
        }
        if (maxFiles > 0) {
            ++argCount;
        }
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (allClients) {
            args[i++] = "-a";
        }
        if (maxFiles > 0) {
            args[i++] = "-m" + maxFiles;
        }
        if (changeListId > 0) {
            args[i++] = "-c" + changeListId;
        } else if (changeListId == 0) {
            args[i++] = "-cdefault";
        }
        if (clientName != null) {
            args[i++] = "-C" + clientName;
        }
        if ((openMap = this.execMapCmd(CmdSpec.OPENED, Server.getPreferredPathArray(args, fileSpecs), null)) != null) {
            for (Map<String, Object> map : openMap) {
                specList.add(this.handleFileReturn(map));
            }
        }
        return specList;
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, boolean allRevs, boolean noHeaderLine) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (allRevs) {
            ++argCount;
        }
        if (noHeaderLine) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (allRevs) {
            args[i++] = "-a";
        }
        if (noHeaderLine) {
            args[i++] = "-q";
        }
        if (fileSpecs != null) {
            for (IFileSpec fSpec : fileSpecs) {
                args[i++] = fSpec.getAnnotatedPreferredPathString();
            }
        }
        return this.execStreamCmd(CmdSpec.PRINT, args);
    }

    @Override
    public List<IFileSpec> getDirectories(List<IFileSpec> fileSpecs, boolean clientOnly, boolean deletedOnly, boolean haveListOnly) throws ConnectionException, AccessException {
        Map<String, Object>[] dirMaps;
        if (fileSpecs == null) {
            throw new NullPointerError("Null fileSpecs in getDirectories");
        }
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        int argCount = 0;
        if (clientOnly) {
            ++argCount;
        }
        if (deletedOnly) {
            ++argCount;
        }
        if (haveListOnly) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (clientOnly) {
            args[i++] = "-C";
        }
        if (deletedOnly) {
            args[i++] = "-D";
        }
        if (haveListOnly) {
            args[i++] = "-H";
        }
        if ((dirMaps = this.execMapCmd(CmdSpec.DIRS, Server.populatePathArray(args, i, fileSpecs), null)) != null) {
            for (Map<String, Object> map : dirMaps) {
                if (map == null) continue;
                String errStr = this.handleFileErrorStr(map);
                if (errStr == null) {
                    specList.add(new FileSpec((String)map.get("dir")));
                    continue;
                }
                if (this.isInfoMessage(map)) {
                    specList.add(new FileSpec(FileSpecOpStatus.INFO, errStr, this.getGenericCode(map), this.getSeverityCode(map)));
                    continue;
                }
                specList.add(new FileSpec(FileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map)));
            }
        }
        return specList;
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, String branchSpec, boolean reverseMappings) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        if (branchSpec != null) {
            ++argCount;
        }
        if (reverseMappings) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int i = 0;
        if (branchSpec != null) {
            args[i++] = "-b" + branchSpec;
        }
        if (reverseMappings) {
            args[i++] = "-r";
        }
        if (fileSpecs != null) {
            for (IFileSpec fileSpec : fileSpecs) {
                args[i++] = fileSpec.getAnnotatedPreferredPathString();
            }
        }
        Map<String, Object>[] mapArray = this.execMapCmd(CmdSpec.INTEGRATED, args, null);
        ArrayList<IFileSpec> integList = new ArrayList<IFileSpec>();
        if (mapArray != null) {
            for (Map<String, Object> map : mapArray) {
                integList.add(this.handleIntegrationFileReturn(map, null));
            }
        }
        return integList;
    }

    @Override
    public List<IChangelist> getInterchanges(IFileSpec fromFile, IFileSpec toFile, boolean showFiles, boolean longDesc, int maxChangelistId) throws ConnectionException, RequestException, AccessException {
        if (fromFile == null || toFile == null) {
            throw new NullPointerError("Null file spec passed to IServer.getInterchanges");
        }
        int argCount = 2;
        if (showFiles) {
            ++argCount;
        }
        if (longDesc) {
            ++argCount;
        }
        if (maxChangelistId > 0) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int arg = 0;
        if (showFiles) {
            args[arg++] = "-f";
        }
        if (longDesc) {
            args[arg++] = "-l";
        }
        if (maxChangelistId > 0) {
            args[arg++] = "-C" + maxChangelistId;
        }
        args[arg++] = fromFile.getAnnotatedPreferredPathString();
        args[arg++] = toFile.getPreferredPathString();
        Map<String, Object>[] mapArray = this.execMapCmd(CmdSpec.INTERCHANGES, args, null);
        return this.processInterchangeMaps(mapArray, showFiles);
    }

    @Override
    public List<IChangelist> getInterchanges(String branchSpecName, List<IFileSpec> fromFileList, List<IFileSpec> toFileList, boolean showFiles, boolean longDesc, int maxChangelistId, boolean reverseMapping, boolean biDirectional) throws ConnectionException, RequestException, AccessException {
        if (branchSpecName == null || branchSpecName.trim().length() == 0) {
            throw new NullPointerError("Null or empty branchspec name passed to IServer.getInterchanges");
        }
        int argCount = 1;
        if (showFiles) {
            ++argCount;
        }
        if (longDesc) {
            ++argCount;
        }
        if (maxChangelistId > 0) {
            ++argCount;
        }
        if (reverseMapping) {
            ++argCount;
        }
        if (biDirectional) {
            ++argCount;
        }
        if (fromFileList != null && fromFileList.size() > 0) {
            argCount += fromFileList.size();
        }
        if (toFileList != null && toFileList.size() > 0) {
            argCount += toFileList.size();
        }
        String[] args = new String[argCount];
        int arg = 0;
        if (showFiles) {
            args[arg++] = "-f";
        }
        if (longDesc) {
            args[arg++] = "-l";
        }
        if (maxChangelistId > 0) {
            args[arg++] = "-C" + maxChangelistId;
        }
        if (reverseMapping) {
            args[arg++] = "-r";
        }
        if (biDirectional) {
            args[arg++] = "-s";
        }
        args[arg++] = "-b" + branchSpecName;
        if (fromFileList != null && fromFileList.size() > 0) {
            for (IFileSpec fSpec : fromFileList) {
                args[arg++] = fSpec.getAnnotatedPreferredPathString();
            }
        }
        if (toFileList != null && toFileList.size() > 0) {
            for (IFileSpec fSpec : toFileList) {
                if (biDirectional) {
                    args[arg++] = fSpec.getPreferredPathString();
                    continue;
                }
                args[arg++] = fSpec.getAnnotatedPreferredPathString();
            }
        }
        Map<String, Object>[] mapArray = this.execMapCmd(CmdSpec.INTERCHANGES, args, null);
        return this.processInterchangeMaps(mapArray, showFiles);
    }

    @Override
    public List<IExtendedFileSpec> getExtendedFiles(List<IFileSpec> fileSpecs, int maxFiles, int sinceChangelist, int affectedByChangelist, FileStatOutputOptions outputOptions, FileStatAncilliaryOptions ancilliaryOptions) throws ConnectionException, AccessException {
        int argCount = 0;
        if (sinceChangelist >= 0) {
            ++argCount;
        }
        if (affectedByChangelist >= 0) {
            ++argCount;
        }
        if (maxFiles > 0) {
            ++argCount;
        }
        if (outputOptions != null) {
            if (outputOptions.isMappedFiles()) {
                ++argCount;
            }
            if (outputOptions.isSyncedFiles()) {
                ++argCount;
            }
            if (outputOptions.isOpenedNotHeadRevFiles()) {
                ++argCount;
            }
            if (outputOptions.isOpenedFiles()) {
                ++argCount;
            }
            if (outputOptions.isOpenedResolvedFiles()) {
                ++argCount;
            }
            if (outputOptions.isOpenedNeedsResolvingFiles()) {
                ++argCount;
            }
            if (outputOptions.isShelvedFiles()) {
                ++argCount;
            }
        }
        if (ancilliaryOptions != null) {
            if (ancilliaryOptions.isAllRevs()) {
                ++argCount;
            }
            if (ancilliaryOptions.isFileSizeDigest()) {
                ++argCount;
            }
            if (ancilliaryOptions.isBothPathTypes()) {
                ++argCount;
            }
            if (ancilliaryOptions.isPendingIntegrationRecs()) {
                ++argCount;
            }
            if (ancilliaryOptions.isExcludeLocalPath()) {
                ++argCount;
            }
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (sinceChangelist > 0) {
            args[i++] = "-c" + sinceChangelist;
        } else if (sinceChangelist == 0) {
            args[i++] = "-cdefault";
        }
        if (affectedByChangelist > 0) {
            args[i++] = "-e" + affectedByChangelist;
        } else if (affectedByChangelist == 0) {
            args[i++] = "-edefault";
        }
        if (maxFiles > 0) {
            args[i++] = "-m" + maxFiles;
        }
        if (outputOptions != null) {
            if (outputOptions.isMappedFiles()) {
                args[i++] = "-Rc";
            }
            if (outputOptions.isSyncedFiles()) {
                args[i++] = "-Rh";
            }
            if (outputOptions.isOpenedNotHeadRevFiles()) {
                args[i++] = "-Rn";
            }
            if (outputOptions.isOpenedFiles()) {
                args[i++] = "-Ro";
            }
            if (outputOptions.isOpenedResolvedFiles()) {
                args[i++] = "-Rr";
            }
            if (outputOptions.isOpenedNeedsResolvingFiles()) {
                args[i++] = "-Ru";
            }
            if (outputOptions.isShelvedFiles()) {
                args[i++] = "-Rs";
            }
        }
        if (ancilliaryOptions != null) {
            if (ancilliaryOptions.isAllRevs()) {
                args[i++] = "-Of";
            }
            if (ancilliaryOptions.isFileSizeDigest()) {
                args[i++] = "-Ol";
            }
            if (ancilliaryOptions.isBothPathTypes()) {
                args[i++] = "-Op";
            }
            if (ancilliaryOptions.isPendingIntegrationRecs()) {
                args[i++] = "-Or";
            }
            if (ancilliaryOptions.isExcludeLocalPath()) {
                args[i++] = "-Os";
            }
        }
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.FSTAT, Server.populatePathArray(args, i, fileSpecs), null);
        ArrayList<IExtendedFileSpec> specList = new ArrayList<IExtendedFileSpec>();
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                String errStr = this.handleFileErrorStr(map);
                ExtendedFileSpec eSpec = null;
                eSpec = errStr == null ? new ExtendedFileSpec(map, this, -1) : (this.isInfoMessage(map) ? new ExtendedFileSpec(FileSpecOpStatus.INFO, errStr) : new ExtendedFileSpec(FileSpecOpStatus.ERROR, errStr));
                specList.add(eSpec);
            }
        }
        return specList;
    }

    @Override
    public List<IJob> getJobs(List<IFileSpec> fileSpecs, int maxJobs, boolean longDescriptions, boolean reverseOrder, boolean includeIntegrated, String jobView) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (maxJobs > 0) {
            ++argCount;
        }
        if (longDescriptions) {
            ++argCount;
        }
        if (reverseOrder) {
            ++argCount;
        }
        if (includeIntegrated) {
            ++argCount;
        }
        if (jobView != null) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (maxJobs > 0) {
            args[i++] = "-m" + maxJobs;
        }
        if (longDescriptions) {
            args[i++] = "-l";
        }
        if (reverseOrder) {
            args[i++] = "-r";
        }
        if (includeIntegrated) {
            args[i++] = "-i";
        }
        if (jobView != null) {
            args[i++] = "-e" + jobView;
        }
        ArrayList<IJob> jobList = new ArrayList<IJob>();
        Map<String, Object>[] jobMaps = this.execMapCmd(CmdSpec.JOBS, Server.populatePathArray(args, i, fileSpecs), null);
        if (jobMaps != null) {
            for (Map<String, Object> map : jobMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                jobList.add(new Job(this, map, longDescriptions));
            }
        }
        return jobList;
    }

    @Override
    public IJob getJob(String jobId) throws ConnectionException, RequestException, AccessException {
        if (jobId == null) {
            throw new P4JavaError("Null jobId in server.getJob()");
        }
        Map<String, Object>[] resultsMap = this.execMapCmd(CmdSpec.JOB, new String[]{"-o", jobId}, null);
        Job job = null;
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                job = new Job(this, map);
            }
        }
        return job;
    }

    @Override
    public IJob createJob(Map<String, Object> fieldMap) throws ConnectionException, RequestException, AccessException {
        if (fieldMap == null) {
            throw new NullPointerError("Null field map passed to ServerImpl.createJob");
        }
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.JOB, new String[]{"-i"}, fieldMap);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                String[] strs;
                this.handleErrorStr(map);
                String infoStr = this.getInfoStr(map);
                if (infoStr == null || !infoStr.contains("Job ") || !infoStr.contains(" saved") || (strs = infoStr.split(" ")).length != 3 || strs[1] == null) continue;
                return this.getJob(strs[1]);
            }
        }
        return null;
    }

    @Override
    public String updateJob(IJob job) throws ConnectionException, RequestException, AccessException {
        if (job == null) {
            throw new NullPointerError("Null job passed to Server.updateJob");
        }
        String retVal = null;
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.JOB, new String[]{"-i"}, job.getRawFields());
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public String deleteJob(String jobId) throws ConnectionException, RequestException, AccessException {
        if (jobId == null) {
            throw new NullPointerError("Null job ID passed to Server.deleteJob");
        }
        String retVal = null;
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.JOB, new String[]{"-d", jobId}, null);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
                if (!this.isInfoMessage(map)) continue;
                retVal = retVal == null ? this.getInfoStr(map) : retVal + "\n" + this.getInfoStr(map);
            }
        }
        return retVal;
    }

    @Override
    public IJobSpec getJobSpec() throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] specMaps = this.execMapCmd(CmdSpec.JOBSPEC, new String[]{"-o"}, null);
        JobSpec jobSpec = null;
        if (specMaps != null) {
            for (Map<String, Object> map : specMaps) {
                if (map == null) continue;
                this.handleErrorStr(map);
                if (this.isInfoMessage(map)) continue;
                jobSpec = new JobSpec(map, this);
            }
        }
        return jobSpec;
    }

    @Override
    public List<IFix> getFixList(List<IFileSpec> fileSpecs, int changeListId, String jobId, boolean includeIntegrations, int maxFixes) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (maxFixes > 0) {
            ++argCount;
        }
        if (changeListId > 0 || changeListId == 0) {
            ++argCount;
        }
        if (jobId != null) {
            ++argCount;
        }
        if (includeIntegrations) {
            ++argCount;
        }
        if (fileSpecs != null) {
            argCount += fileSpecs.size();
        }
        String[] args = new String[argCount];
        int i = 0;
        if (maxFixes > 0) {
            args[i++] = "-m" + maxFixes;
        }
        if (changeListId > 0) {
            args[i++] = "-c" + (changeListId == 0 ? "default" : Integer.valueOf(changeListId));
        }
        if (jobId != null) {
            args[i++] = "-j" + jobId;
        }
        if (includeIntegrations) {
            args[i++] = "-i";
        }
        ArrayList<IFix> fixList = new ArrayList<IFix>();
        Map<String, Object>[] fixMaps = this.execMapCmd(CmdSpec.FIXES, Server.populatePathArray(args, i, fileSpecs), null);
        if (fixMaps != null) {
            for (Map<String, Object> map : fixMaps) {
                if (map == null) continue;
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                fixList.add(new Fix(map));
            }
        }
        return fixList;
    }

    @Override
    public List<IFix> fixJobs(List<String> jobIdList, int changeListId, String status, boolean delete) throws ConnectionException, RequestException, AccessException {
        if (jobIdList == null) {
            throw new P4JavaError("Null jobIdList in fixJobs");
        }
        if (jobIdList.size() == 0) {
            throw new RequestException("fix jobs method requires a non-empty jobs list");
        }
        int argCount = jobIdList.size() + 1 + (status == null ? 0 : 1) + (delete ? 1 : 0);
        String[] args = new String[argCount];
        int i = 0;
        args[i++] = "-c" + (changeListId == 0 ? "default" : Integer.valueOf(changeListId));
        if (status != null) {
            args[i++] = "-s" + status;
        }
        if (delete) {
            args[i++] = "-d";
        }
        for (String id : jobIdList) {
            if (id == null) {
                throw new P4JavaError("Null job id in jobIdList in fixJobs method");
            }
            args[i++] = id;
        }
        ArrayList<IFix> fixList = new ArrayList<IFix>();
        Map<String, Object>[] fixMap = this.execMapCmd(CmdSpec.FIX, args, null);
        if (fixMap != null) {
            for (Map<String, Object> map : fixMap) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                fixList.add(new Fix(map));
            }
        }
        return fixList;
    }

    @Override
    public String getCounter(String counterName) throws ConnectionException, RequestException, AccessException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to getCounter method");
        }
        Map<String, Object>[] counterMapArray = this.execMapCmd(CmdSpec.COUNTER, new String[]{counterName}, null);
        String retVal = "";
        if (counterMapArray != null) {
            for (Map<String, Object> map : counterMapArray) {
                if (map == null || !map.containsKey("value")) continue;
                return (String)map.get("value");
            }
        }
        return retVal;
    }

    @Override
    public void setCounter(String counterName, String value, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to setCounter method");
        }
        if (value == null) {
            throw new NullPointerError("null counter value passed to setCounter method");
        }
        int argCount = 2;
        if (perforceCounter) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int arg = 0;
        if (perforceCounter) {
            args[arg++] = "-f";
        }
        args[arg++] = counterName;
        args[arg++] = value;
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.COUNTER, args, null);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
            }
        }
    }

    @Override
    public void deleteCounter(String counterName, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        if (counterName == null) {
            throw new NullPointerError("null counter name passed to setCounter method");
        }
        int argCount = 2;
        if (perforceCounter) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int arg = 0;
        if (perforceCounter) {
            args[arg++] = "-f";
        }
        args[arg++] = "-d";
        args[arg++] = counterName;
        Map<String, Object>[] retMaps = this.execMapCmd(CmdSpec.COUNTER, args, null);
        if (retMaps != null) {
            for (Map<String, Object> map : retMaps) {
                this.handleErrorStr(map);
            }
        }
    }

    @Override
    public Map<String, String> getCounters() throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] counterMapArray = this.execMapCmd(CmdSpec.COUNTERS, null, null);
        HashMap<String, String> counterMap = new HashMap<String, String>();
        if (counterMapArray != null) {
            for (Map<String, Object> map : counterMapArray) {
                String errStr = this.getErrorOrInfoStr(map);
                if (errStr != null) {
                    if (this.isAuthFail(errStr)) {
                        throw new AccessException(errStr);
                    }
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                try {
                    counterMap.put((String)map.get("counter"), (String)map.get("value"));
                }
                catch (Exception exc) {
                    Log.error("getCounter conversion error: " + exc.getLocalizedMessage());
                    Log.exception(exc);
                }
            }
        }
        return counterMap;
    }

    @Override
    public List<IServerProcess> getServerProcesses() throws ConnectionException, RequestException, AccessException {
        ArrayList<IServerProcess> processList = new ArrayList<IServerProcess>();
        Map<String, Object>[] monitorMaps = this.execMapCmd(CmdSpec.MONITOR, new String[]{"show"}, null);
        if (monitorMaps != null) {
            for (Map<String, Object> map : monitorMaps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                processList.add(new ServerProcess(map));
            }
        }
        return processList;
    }

    @Override
    public InputStream getServerFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (file1 != null) {
            ++argCount;
        }
        if (file2 != null) {
            ++argCount;
        }
        if (branchSpecName != null) {
            ++argCount;
        }
        if (quiet) {
            ++argCount;
        }
        if (includeNonTextDiffs) {
            ++argCount;
        }
        if (gnuDiffs) {
            ++argCount;
        }
        if (diffType != null) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int arg = 0;
        if (diffType != null) {
            args[arg++] = "-d" + diffType.toArgString();
        }
        if (quiet) {
            args[arg++] = "-q";
        }
        if (includeNonTextDiffs) {
            args[arg++] = "-t";
        }
        if (gnuDiffs) {
            args[arg++] = "-u";
        }
        if (branchSpecName != null) {
            args[arg++] = "-b" + branchSpecName;
        }
        if (file1 != null) {
            args[arg++] = file1.getAnnotatedPreferredPathString();
        }
        if (file2 != null) {
            args[arg++] = file2.getAnnotatedPreferredPathString();
        }
        return this.execStreamCmd(CmdSpec.DIFF2, args);
    }

    @Override
    public List<IDbSchema> getDbSchema(List<String> tableSpecs) throws ConnectionException, RequestException, AccessException {
        String[] args = null;
        if (tableSpecs != null) {
            args = new String[tableSpecs.size()];
            int i = 0;
            for (String table : tableSpecs) {
                args[i++] = table;
            }
        }
        Map<String, Object>[] maps = this.execMapCmd(CmdSpec.DBSCHEMA, args, null);
        ArrayList<IDbSchema> schemaList = new ArrayList<IDbSchema>();
        if (maps != null) {
            for (Map<String, Object> map : maps) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                schemaList.add(new DbSchema(map));
            }
        }
        return schemaList;
    }

    @Override
    public List<Map<String, Object>> getExportRecords(boolean useJournal, long maxRecs, int sourceNum, long offset, boolean format, String journalPrefix, String filter) throws ConnectionException, RequestException, AccessException {
        int argCount = 0;
        if (maxRecs > 0L) {
            ++argCount;
        }
        if (sourceNum >= 0) {
            ++argCount;
        }
        if (format) {
            ++argCount;
        }
        if (journalPrefix != null) {
            ++argCount;
        }
        if (filter != null) {
            ++argCount;
        }
        String[] args = new String[argCount];
        int i = 0;
        if (maxRecs > 0L) {
            args[i++] = "-l" + maxRecs;
        }
        if (sourceNum >= 0) {
            args[i++] = (useJournal ? "-j" : "-c") + sourceNum + (offset >= 0L ? (useJournal ? "/" : "#") + offset : "");
        }
        if (journalPrefix != null) {
            args[i++] = "-J" + journalPrefix;
        }
        if (format) {
            args[i++] = "-f";
        }
        if (filter != null) {
            args[i++] = "-F" + filter;
        }
        Map<String, Object>[] mapArray = this.execMapCmd(CmdSpec.EXPORT, args, null);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (mapArray != null) {
            for (Map<String, Object> map : mapArray) {
                String errStr = this.getErrorStr(map);
                if (errStr != null) {
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                if (map.containsKey("func")) {
                    map.remove("func");
                }
                mapList.add(map);
            }
        }
        return mapList;
    }

    public boolean handleErrorStr(Map<String, Object> map) throws RequestException, AccessException {
        String errStr = this.getErrorStr(map);
        if (errStr != null) {
            if (this.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return false;
    }

    public IFileSpec handleFileReturn(Map<String, Object> map) throws AccessException, ConnectionException {
        return this.handleFileReturn(map, this.client);
    }

    public IFileSpec handleFileReturn(Map<String, Object> map, IClient client) throws AccessException, ConnectionException {
        if (map != null) {
            String errStr = this.handleFileErrorStr(map);
            if (errStr == null) {
                return new FileSpec(map, this, -1);
            }
            if (this.isInfoMessage(map)) {
                return new FileSpec(FileSpecOpStatus.INFO, errStr, this.getGenericCode(map), this.getSeverityCode(map));
            }
            return new FileSpec(FileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return null;
    }

    public IFileSpec handleIntegrationFileReturn(Map<String, Object> map, IClient client) throws AccessException, ConnectionException {
        return this.handleIntegrationFileReturn(map, false);
    }

    public IFileSpec handleIntegrationFileReturn(Map<String, Object> map, boolean ignoreInfo) throws AccessException, ConnectionException {
        if (map != null) {
            String errStr = this.handleFileErrorStr(map);
            if (errStr == null) {
                return new FileSpec(map, this, -1);
            }
            if (this.isInfoMessage(map)) {
                if (ignoreInfo) {
                    return new FileSpec(map, this, -1);
                }
                return new FileSpec(FileSpecOpStatus.INFO, errStr);
            }
            return new FileSpec(FileSpecOpStatus.ERROR, errStr, this.getGenericCode(map), this.getSeverityCode(map));
        }
        return null;
    }

    public String handleFileErrorStr(Map<String, Object> map) throws ConnectionException, AccessException {
        String errStr = this.getErrorOrInfoStr(map);
        if (errStr != null) {
            if (this.isAuthFail(errStr)) {
                throw new AccessException(errStr);
            }
            return errStr.trim();
        }
        return null;
    }

    public static String guardNull(String str) {
        String nullStr = "<null>";
        return str == null ? "<null>" : str;
    }

    public static String[] getPreferredPathArray(String[] preamble, List<IFileSpec> specList, boolean annotate) {
        String[] pathArray = new String[(preamble == null ? 0 : preamble.length) + (specList == null ? 0 : specList.size())];
        int i = 0;
        if (preamble != null) {
            for (String str : preamble) {
                pathArray[i++] = str;
            }
        }
        if (specList != null) {
            for (IFileSpec fSpec : specList) {
                if (fSpec != null && fSpec.getOpStatus() == FileSpecOpStatus.VALID) {
                    if (annotate) {
                        pathArray[i++] = fSpec.getAnnotatedPreferredPathString();
                        continue;
                    }
                    pathArray[i++] = fSpec.getPreferredPathString();
                    continue;
                }
                pathArray[i++] = null;
            }
        }
        return pathArray;
    }

    public static String[] getPreferredPathArray(String[] preamble, List<IFileSpec> specList) {
        return Server.getPreferredPathArray(preamble, specList, true);
    }

    public static String[] populatePathArray(String[] pathArray, int start, List<IFileSpec> fileSpecList) {
        if (pathArray == null) {
            return null;
        }
        if (fileSpecList == null) {
            return pathArray;
        }
        if (start < 0) {
            throw new P4JavaError("negative start index in populatePathArray: " + start);
        }
        if (start > pathArray.length || pathArray.length < start + fileSpecList.size()) {
            throw new P4JavaError("pathArray too small in populatePathArray");
        }
        int i = start;
        for (IFileSpec fSpec : fileSpecList) {
            pathArray[i] = fSpec != null && fSpec.getOpStatus() == FileSpecOpStatus.VALID ? fSpec.getAnnotatedPreferredPathString() : null;
            ++i;
        }
        return pathArray;
    }

    public Map<String, Object>[] execMapCmd(CmdSpec cmdSpec, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException {
        if (cmdSpec == null) {
            throw new NullPointerError("Null command spec in execMapCmd");
        }
        try {
            return this.execMapCmd(cmdSpec.toString(), cmdArgs, inMap);
        }
        catch (RequestException exc) {
            return null;
        }
    }

    public InputStream execStreamCmd(CmdSpec cmdSpec, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        if (cmdSpec == null) {
            throw new NullPointerError("Null command spec in execMapCmd");
        }
        return this.execStreamCmd(cmdSpec.toString(), cmdArgs);
    }

    protected boolean isUnicode() {
        return this.charsetName != null;
    }

    public abstract String getErrorStr(Map<String, Object> var1);

    public abstract String getErrorOrInfoStr(Map<String, Object> var1);

    public abstract String getInfoStr(Map<String, Object> var1);

    public abstract boolean isAuthFail(String var1);

    public abstract boolean isInfoMessage(Map<String, Object> var1);

    protected abstract int getGenericCode(Map<String, Object> var1);

    protected abstract int getSeverityCode(Map<String, Object> var1);

    @Override
    public abstract Map<String, Object>[] execMapCmd(String var1, String[] var2, Map<String, Object> var3) throws ConnectionException, AccessException, RequestException;

    @Override
    public abstract Map<String, Object>[] execQuietMapCmd(String var1, String[] var2, Map<String, Object> var3) throws ConnectionException, RequestException, AccessException;

    @Override
    public abstract InputStream execStreamCmd(String var1, String[] var2) throws ConnectionException, RequestException, AccessException;

    @Override
    public abstract InputStream execQuietStreamCmd(String var1, String[] var2) throws ConnectionException, RequestException, AccessException;

    public String getClientName() {
        return this.clientName;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectoryPath;
    }

    @Override
    public void setWorkingDirectory(String dirPath) {
        this.workingDirectoryPath = dirPath;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    protected int getServerVersion() throws ConnectionException {
        if (this.serverVersion != -1) {
            return this.serverVersion;
        }
        try {
            Map<String, Object>[] resultMap = this.execMapCmd(CmdSpec.INFO.toString().toLowerCase(Locale.ENGLISH), new String[0], null);
            if (resultMap != null) {
                for (Map<String, Object> map : resultMap) {
                    if (!map.containsKey("serverVersion")) continue;
                    this.serverVersion = this.parseVersionString((String)map.get("serverVersion"));
                    return this.serverVersion;
                }
            }
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new ConnectionException(exc.getLocalizedMessage());
        }
        return -1;
    }

    protected String getInfoServerAddress() {
        String address;
        block3: {
            address = null;
            try {
                Map<String, Object>[] resultMap = this.execMapCmd(CmdSpec.INFO.toString().toLowerCase(Locale.ENGLISH), new String[0], null);
                if (resultMap == null) break block3;
                for (Map<String, Object> map : resultMap) {
                    if (!map.containsKey("serverAddress")) continue;
                    address = map.get("serverAddress").toString();
                    break;
                }
            }
            catch (Exception exc) {
                Log.exception(exc);
            }
        }
        return address;
    }

    protected int parseVersionString(String versionString) {
        String candidate;
        String[] candParts;
        String[] subStrings;
        if (versionString != null && (subStrings = versionString.split("/")).length >= 3 && (candParts = (candidate = subStrings[2]).split("\\.")).length >= 2) {
            try {
                return new Integer(candParts[0] + candParts[1]);
            }
            catch (NumberFormatException nfe) {
                Log.error("Unexpected exception in P4CmdServerImpl.parseVersionString: " + nfe);
            }
        }
        return -1;
    }

    public static boolean isRunningOnWindows() {
        return isRunningOnWindows;
    }

    protected String getP4TicketsOSLocation() {
        String location = null;
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (home != null && os != null) {
            StringBuilder builtLocation = new StringBuilder(home);
            builtLocation.append(File.separatorChar);
            if (os.toLowerCase(Locale.ENGLISH).contains("windows")) {
                builtLocation.append(P4TICKETS_DEFAULT_WINDOWS);
            } else {
                builtLocation.append(P4TICKETS_DEFAULT_OTHER);
            }
            location = builtLocation.toString();
        }
        return location;
    }

    protected List<IChangelist> processInterchangeMaps(Map<String, Object>[] mapArray, boolean showFiles) throws ConnectionException, AccessException, RequestException {
        ArrayList<IChangelist> interchangeList = new ArrayList<IChangelist>();
        if (mapArray != null) {
            for (Map<String, Object> map : mapArray) {
                if (map == null) continue;
                String errStr = this.handleFileErrorStr(map);
                if (errStr != null) {
                    if (this.getGenericCode(map) == 17 || this.getSeverityCode(map) == 2 || errStr.contains("all revision(s) already integrated")) continue;
                    throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                }
                Changelist changelist = new Changelist(new ChangelistSummary(map, true, (IServer)this), this, false);
                interchangeList.add(changelist);
                if (!showFiles) continue;
                ArrayList<IFileSpec> fileSpecs = new ArrayList<IFileSpec>();
                int i = 0;
                String depotKey = "depotFile";
                while (map.get("depotFile" + i) != null) {
                    FileSpec fileSpec = new FileSpec(map, this, i);
                    fileSpec.setChangelistId(changelist.getId());
                    fileSpecs.add(fileSpec);
                    ++i;
                }
                changelist.setFileSpecs(fileSpecs);
            }
        }
        return interchangeList;
    }

    public ISSOCallback getSSOCallback() {
        return this.ssoCallback;
    }

    public String getSSOKey() {
        return this.ssoKey;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName != null && (osName.contains("Windows") || osName.contains("windows"))) {
            isRunningOnWindows = true;
        }
    }
}

